/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.transport.http;

import com.phaos.SSL.SSLCertificate;
import com.phaos.SSL.SSLParams;
import com.phaos.cert.CertificateTrustPolicy;
import com.phaos.cert.KeyPairPKCS12;
import com.phaos.cert.TrustedCAPolicy;
import com.phaos.cert.X509;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PrivateKeyPKCS8;
import com.phaos.https.HttpsURLStreamHandlerFactory;
import com.phaos.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SSLUtil {
    private static boolean _initialized;
    private static final boolean _debug = false;
    private static final String ROOTCA_JAR = "agrootca.jar";
    private static SSLCertificate _cert;
    private static final String STR_HEAD = "-----BEGIN";
    private static final String STR_CERTBEGIN = "-----BEGIN CERTIFICATE-----";
    private static final String STR_CERTEND = "-----END CERTIFICATE-----";

    static void init() throws MalformedURLException {
        if (!_initialized) {
            try {
                SSLParams sSLParams = SSLUtil.getSSLParams();
                URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new HttpsURLStreamHandlerFactory(sSLParams));
            }
            catch (Exception exception) {
                throw new MalformedURLException("unable to initialize for SSL: " + exception.getMessage());
            }
        }
        _initialized = true;
    }

    private static SSLParams getSSLParams() {
        short[] sArray = new short[]{53, 57, 56, 47, 51, 50, 10, 22, 19, 4, 5, 102, 98, 100, 99, 101, 9, 21, 18, 3, 6, 8, 20, 17};
        SSLParams sSLParams = new SSLParams();
        sSLParams.setAllowTLS1(true);
        sSLParams.setClientCipherSuites(sArray);
        sSLParams.setDebug(false);
        sSLParams.setResumableSessions(true);
        String string = System.getProperty("java.class.path");
        int n = string.indexOf(ROOTCA_JAR);
        if (n > 0) {
            int n2 = n;
            while (n2 > 0) {
                if (string.charAt(n2) == File.pathSeparatorChar) {
                    ++n2;
                    break;
                }
                --n2;
            }
            String string2 = string.substring(n2, n + ROOTCA_JAR.length());
            SSLUtil.loadCACerts(string2, sSLParams);
        }
        if (_cert != null) {
            sSLParams.setClientCert(_cert);
        }
        return sSLParams;
    }

    private static void loadCACerts(String string, SSLParams sSLParams) {
        JarFile jarFile = null;
        TrustedCAPolicy trustedCAPolicy = new TrustedCAPolicy();
        try {
            jarFile = new JarFile(string);
        }
        catch (Exception exception) {
            System.err.println("unable to load " + string + ": " + exception.getMessage());
            return;
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.getName().startsWith("META-INF/")) continue;
            try {
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                X509 x509 = new X509(inputStream);
                inputStream.close();
                trustedCAPolicy.addTrustedCA(x509);
            }
            catch (Exception exception) {
                System.err.println("failed to load " + jarEntry.getName() + " from " + string + ": " + exception.getMessage());
                if (System.getProperty("JBWDebug") == null) continue;
                exception.printStackTrace();
            }
        }
        trustedCAPolicy.setRequireCAFlag(false);
        sSLParams.setCertificateTrustPolicy((CertificateTrustPolicy)trustedCAPolicy);
    }

    public static void getPKCS12(byte[] byArray, String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        KeyPairPKCS12 keyPairPKCS12 = new KeyPairPKCS12(string, (InputStream)byteArrayInputStream);
        _cert = new SSLCertificate();
        _cert.setCertificateList(keyPairPKCS12.getCertificateChain());
        _cert.setPrivateKey(keyPairPKCS12.getPrivateKey());
    }

    public static void setPKCS12(byte[] byArray, byte[] byArray2, String string) throws IOException {
        Object object;
        if (SSLUtil.ifPossiblyBase64Encoding(byArray)) {
            object = new String(byArray);
            byArray = SSLUtil.decodeBase64Cert((String)object);
        }
        object = new ByteArrayInputStream(byArray2);
        PrivateKeyPKCS8 privateKeyPKCS8 = new PrivateKeyPKCS8(string, (InputStream)object);
        privateKeyPKCS8 = new PrivateKeyPKCS8(privateKeyPKCS8.getKey());
        X509 x509 = new X509(byArray);
        Vector<X509> vector = new Vector<X509>();
        vector.add(x509);
        KeyPairPKCS12 keyPairPKCS12 = new KeyPairPKCS12("SeCuRiTyIsGoOd", privateKeyPKCS8, vector, -2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        keyPairPKCS12.output((OutputStream)byteArrayOutputStream);
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
        keyPairPKCS12 = new KeyPairPKCS12("SeCuRiTyIsGoOd", (InputStream)byteArrayInputStream);
        PrivateKey privateKey = privateKeyPKCS8.getKey();
        _cert = new SSLCertificate();
        _cert.setCertificateList(keyPairPKCS12.getCertificateChain());
        _cert.setPrivateKey(privateKey);
    }

    private static byte[] decodeBase64Cert(String string) {
        if (null == string) {
            return null;
        }
        int n = string.indexOf(STR_CERTBEGIN);
        int n2 = string.indexOf(STR_CERTEND);
        n = n == -1 ? 0 : (n += STR_CERTBEGIN.length());
        if (n2 == -1) {
            n2 = string.length();
        }
        return Utils.fromBase64((String)string.substring(n, n2));
    }

    private static boolean ifPossiblyBase64Encoding(byte[] byArray) {
        if (null == byArray) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] <= 0) {
                return false;
            }
            ++n;
        }
        return byArray.length >= STR_HEAD.length();
    }
}

