/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.transport.jms;

import com.sssw.jbroker.web.Binding;
import com.sssw.jbroker.web.ServiceObject;
import com.sssw.jbroker.web.core.Constants;
import com.sssw.jbroker.web.portable.ClientRequest;
import com.sssw.jbroker.web.spi.TransportHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.rpc.JAXRPCException;

public class JmsHandler
implements TransportHandler,
Constants {
    private static final boolean _debug = true;
    public static final String _void = "<Envelope xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/' xmlns='http://schemas.xmlsoap.org/soap/envelope/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:SOAP-ENC='http://schemas.xmlsoap.org/soap/encoding/'> <SOAP-ENV:Body>  <void:response   SOAP-ENV:encodingStyle='http://schemas.xmlsoap.org/soap/encoding/'   xmlns:void='urn:void'>   <result xsi:null='true'/>  </foo:response> </SOAP-ENV:Body></Envelope>";
    public static final byte[] _voidBytes = "<Envelope xmlns:SOAP-ENV='http://schemas.xmlsoap.org/soap/envelope/' xmlns='http://schemas.xmlsoap.org/soap/envelope/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:SOAP-ENC='http://schemas.xmlsoap.org/soap/encoding/'> <SOAP-ENV:Body>  <void:response   SOAP-ENV:encodingStyle='http://schemas.xmlsoap.org/soap/encoding/'   xmlns:void='urn:void'>   <result xsi:null='true'/>  </foo:response> </SOAP-ENV:Body></Envelope>".getBytes();
    public static final InputStream _voidStream = new ByteArrayInputStream(_voidBytes);

    public JmsHandler(Properties properties) {
    }

    public String getProtocol() {
        return "jms";
    }

    public TransportHandler.TransportEndpoint createEndpoint(ServiceObject serviceObject) throws MalformedURLException {
        return new JmsEndPoint(serviceObject._getCurrentBinding());
    }

    public TransportHandler.TransportEndpoint createEndpoint(Binding binding) throws MalformedURLException {
        return new JmsEndPoint(binding);
    }

    private static class JmsEndPoint
    implements TransportHandler.TransportEndpoint {
        private String _url;
        private String _username;
        private String _password;
        private String _topicFactoryClass;
        private String _queueFactoryClass;
        private String _topicFactoryJNDI = "topic/connectionFactory";
        private String _queueFactoryJNDI = "queue/connectionFactory";
        private TopicConnectionFactory _topicFactory;
        private QueueConnectionFactory _queueFactory;
        private String _topicJNDI;
        private String _queueJNDI;
        private Topic _topic;
        private Queue _queue;
        private String _topicReplyJNDI;
        private String _queueReplyJNDI;
        private Topic _topicReply;
        private Queue _queueReply;
        private String _durableName;
        private String _selector;
        private int _timeout;
        private boolean _requestor;
        private boolean _correlate;
        private Hashtable _env;
        private InitialContext _ctx;
        private TopicConnection _topicConn;
        private QueueConnection _queueConn;
        private TopicSession _topicSession;
        private QueueSession _queueSession;
        private TopicPublisher _publisher;
        private QueueSender _sender;
        private TopicSubscriber _subscriber;
        private QueueReceiver _receiver;

        JmsEndPoint(Binding binding) throws MalformedURLException {
            this._url = binding.getURLStr();
            int n = this._url.indexOf("jms://");
            if (n == -1) {
                throw new MalformedURLException("protocol must be jms: " + this._url);
            }
            this._queueJNDI = this._url.substring(n + 6);
            System.out.println("created jms endpoint: " + this._queueJNDI);
        }

        private void getInitialContext() throws NamingException {
            if (this._ctx != null) {
                return;
            }
            if (this._env != null) {
                System.out.println("creating ctx with " + this._env);
                Object v = this._env.get("ORBDefaultInitRef");
                if (v != null && v instanceof String) {
                    System.setProperty("ORBDefaultInitRef", (String)v);
                }
                this._ctx = new InitialContext(this._env);
                return;
            }
            this._env = new Hashtable();
            this._env.put("org.omg.CORBA.ORBClass", "com.sssw.jbroker.ORBLite");
            this._env.put("org.omg.CORBA.ORBSingletonClass", "com.sssw.jbroker.orb.SingletonORB");
            this._env.put("javax.rmi.CORBA.StubClass", "com.sssw.jbroker.rmi.StubDelegate");
            this._env.put("javax.rmi.CORBA.UtilClass", "com.sssw.jbroker.rmi.UtilDelegate");
            this._env.put("javax.rmi.CORBA.PortableRemoteObjectClass", "com.sssw.jbroker.rmi.PortableRemoteObjectDelegate");
            this._env.put("java.naming.factory.object", "com.sssw.jms.naming.JMQObjectFactory");
            this._env.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
            this._env.put("ORBDefaultInitRef", "iioploc://localhost:3506");
            System.setProperty("ORBDefaultInitRef", "iioploc://localhost:3506");
            System.out.println("creating ctx with " + this._env);
            this._ctx = new InitialContext(this._env);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setProperty(String string, Object object) {
            System.out.println("setting " + string + " to " + object);
            if (string.equals("user.id")) {
                if (object == null) {
                    this._username = null;
                } else {
                    if (!(object instanceof String)) throw new JAXRPCException(string + " must be a string");
                    this._username = (String)object;
                }
            } else if (string.equals("user.password")) {
                if (object == null) {
                    this._password = null;
                } else {
                    if (!(object instanceof String)) throw new JAXRPCException(string + " must be a string");
                    this._password = (String)object;
                }
            } else if (string.equals("jms.topic.factory")) {
                if (object == null) {
                    this._topicFactory = null;
                } else {
                    if (!(object instanceof TopicConnectionFactory)) throw new JAXRPCException(string + " must be a topic connection factory");
                    this._topicFactory = (TopicConnectionFactory)object;
                }
            } else if (string.equals("jms.topic.factory.jndi")) {
                if (object == null) {
                    this._topicFactoryJNDI = null;
                } else {
                    if (!(object instanceof String)) throw new JAXRPCException(string + " must be a string");
                    try {
                        this._topicFactoryJNDI = (String)object;
                        this.getInitialContext();
                        this._topicFactory = (TopicConnectionFactory)this._ctx.lookup(this._topicFactoryJNDI);
                    }
                    catch (NamingException namingException) {
                        throw new JAXRPCException("failed to lookup " + this._topicFactoryJNDI + ": " + namingException.getMessage(), namingException);
                    }
                }
            } else if (string.equals("jms.topic.factory.class")) {
                if (object == null) {
                    this._topicFactoryClass = null;
                } else {
                    if (!(object instanceof String)) throw new JAXRPCException(string + " must be a string");
                    try {
                        this._topicFactoryClass = (String)object;
                        Class<?> clazz = Class.forName(this._topicFactoryClass);
                        this._topicFactory = (TopicConnectionFactory)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        throw new JAXRPCException("failed to instantiate class: " + exception.getMessage(), exception);
                    }
                }
            } else if (string.equals("jms.queue.factory")) {
                if (object == null) {
                    this._queueFactory = null;
                } else {
                    if (!(object instanceof QueueConnectionFactory)) throw new JAXRPCException(string + " must be a queue connection factory");
                    this._queueFactory = (QueueConnectionFactory)object;
                }
            } else if (string.equals("jms.queue.factory.jndi")) {
                if (object == null) {
                    this._queueFactoryJNDI = null;
                } else {
                    if (!(object instanceof String)) throw new JAXRPCException(string + " must be a string");
                    try {
                        this._queueFactoryJNDI = (String)object;
                        this.getInitialContext();
                        this._queueFactory = (QueueConnectionFactory)this._ctx.lookup(this._queueFactoryJNDI);
                    }
                    catch (NamingException namingException) {
                        throw new JAXRPCException("failed to lookup " + this._queueFactoryJNDI + ": " + namingException.getMessage(), namingException);
                    }
                }
            } else if (string.equals("jms.queue.factory.class")) {
                if (object == null) {
                    this._queueFactoryClass = null;
                } else {
                    if (!(object instanceof String)) throw new JAXRPCException(string + " must be a string");
                    try {
                        String string2 = (String)object;
                        Class<?> clazz = Class.forName(string2);
                        this._queueFactory = (QueueConnectionFactory)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        throw new JAXRPCException("failed to instantiate class: " + exception.getMessage(), exception);
                    }
                }
            } else if (string.equals("jms.topic")) {
                if (object == null) {
                    this._topic = null;
                } else {
                    if (!(object instanceof Topic)) throw new JAXRPCException(string + " must be a topic");
                    this._topic = (Topic)object;
                }
            } else if (string.equals("jms.topic.jndi")) {
                if (object == null) {
                    this._topicJNDI = null;
                } else {
                    if (!(object instanceof String)) throw new JAXRPCException(string + " must be a string");
                    try {
                        this._topicJNDI = (String)object;
                        this.getInitialContext();
                        this._topic = (Topic)this._ctx.lookup(this._topicJNDI);
                    }
                    catch (NamingException namingException) {
                        throw new JAXRPCException("failed to lookup " + this._topicJNDI + ": " + namingException.getMessage(), namingException);
                    }
                }
            } else if (string.equals("jms.topic.reply")) {
                if (object == null) {
                    this._topicReply = null;
                } else {
                    if (!(object instanceof Topic)) throw new JAXRPCException(string + " must be a topic");
                    this._topicReply = (Topic)object;
                }
            } else if (string.equals("jms.topic.reply.jndi")) {
                if (object == null) {
                    this._topicReplyJNDI = null;
                } else {
                    if (!(object instanceof String)) throw new JAXRPCException(string + " must be a string");
                    try {
                        this._topicReplyJNDI = (String)object;
                        this.getInitialContext();
                        this._topicReply = (Topic)this._ctx.lookup(this._topicReplyJNDI);
                    }
                    catch (NamingException namingException) {
                        throw new JAXRPCException("failed to lookup " + this._topicReplyJNDI + ": " + namingException.getMessage(), namingException);
                    }
                }
            } else if (string.equals("jms.topic.durable")) {
                if (object == null) {
                    this._durableName = null;
                } else {
                    if (!(object instanceof String)) throw new JAXRPCException(string + " must be a string");
                    this._durableName = (String)object;
                }
            } else if (string.equals("jms.queue")) {
                if (object == null) {
                    this._queue = null;
                } else {
                    if (!(object instanceof Queue)) throw new JAXRPCException(string + " must be a queue");
                    this._queue = (Queue)object;
                }
            } else if (string.equals("jms.queue.jndi")) {
                if (object == null) {
                    this._queueJNDI = null;
                } else {
                    if (!(object instanceof String)) throw new JAXRPCException(string + " must be a string");
                    try {
                        this._queueJNDI = (String)object;
                        this.getInitialContext();
                        this._queue = (Queue)this._ctx.lookup(this._queueJNDI);
                    }
                    catch (NamingException namingException) {
                        throw new JAXRPCException("failed to lookup " + this._queueJNDI + ": " + namingException.getMessage(), namingException);
                    }
                }
            } else if (string.equals("jms.queue.reply")) {
                if (object == null) {
                    this._queueReply = null;
                } else {
                    if (!(object instanceof Queue)) throw new JAXRPCException(string + " must be a queue");
                    this._queueReply = (Queue)object;
                }
            } else if (string.equals("jms.queue.reply.jndi")) {
                if (object == null) {
                    this._queueReplyJNDI = null;
                } else {
                    if (!(object instanceof String)) throw new JAXRPCException(string + " must be a string");
                    try {
                        this._queueReplyJNDI = (String)object;
                        this.getInitialContext();
                        this._queueReply = (Queue)this._ctx.lookup(this._queueReplyJNDI);
                    }
                    catch (NamingException namingException) {
                        JAXRPCException jAXRPCException = new JAXRPCException("failed to lookup " + this._queueReplyJNDI + ": " + namingException.getMessage(), namingException);
                    }
                }
            } else if (string.equals("jms.reply.timeout")) {
                if (object == null) {
                    this._timeout = 0;
                } else if (object instanceof Integer) {
                    int n = (Integer)object;
                    if (n < 0) {
                        throw new JAXRPCException("timeout can't be negative");
                    }
                    this._timeout = n;
                } else {
                    if (!(object instanceof String)) throw new JAXRPCException(string + " must be an integer");
                    try {
                        int n = Integer.valueOf((String)object);
                        if (n < 0) {
                            throw new JAXRPCException("timeout can't be negative");
                        }
                        this._timeout = n;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new JAXRPCException("invalid integer: " + object);
                    }
                }
            } else if (string.equals("jms.reply.selector")) {
                if (object == null) {
                    this._selector = null;
                } else {
                    if (!(object instanceof String)) throw new JAXRPCException(string + " must be a string");
                    this._selector = (String)object;
                }
            } else if (string.equals("jms.use.requestor")) {
                if (object == null) {
                    this._requestor = false;
                } else {
                    if (!(object instanceof Boolean)) throw new JAXRPCException(string + " must be a boolean");
                    this._requestor = (Boolean)object;
                }
            } else if (string.equals("jms.use.correlation.id")) {
                if (object == null) {
                    this._correlate = false;
                } else {
                    if (!(object instanceof Boolean)) throw new JAXRPCException(string + " must be a boolean");
                    this._correlate = (Boolean)object;
                }
            } else if (string.equals("jms.jndi.environment")) {
                if (object == null) {
                    this._ctx = null;
                } else {
                    if (!(object instanceof Hashtable)) throw new JAXRPCException(string + " must be a Hashtable");
                    this._env = (Hashtable)object;
                    try {
                        this.getInitialContext();
                    }
                    catch (NamingException namingException) {
                        throw new JAXRPCException("failed to get initial context", namingException);
                    }
                }
            } else {
                if (!string.equals("jms.jndi.initial.context")) return;
                if (object == null) {
                    this._ctx = null;
                } else {
                    if (!(object instanceof InitialContext)) throw new JAXRPCException(string + " must be an InitialContext");
                    this._ctx = (InitialContext)object;
                }
            }
            this.reset();
        }

        private void reset() throws JAXRPCException {
            try {
                block5: {
                    try {
                        if (this._topicConn != null) {
                            this._topicConn.close();
                        }
                        if (this._queueConn == null) break block5;
                        this._queueConn.close();
                    }
                    catch (JMSException jMSException) {
                        throw new JAXRPCException("failed to close connection", jMSException);
                    }
                }
                Object var3_1 = null;
                this._topicConn = null;
                this._queueConn = null;
                this._topicSession = null;
                this._queueSession = null;
                this._publisher = null;
                this._sender = null;
                this._subscriber = null;
                this._receiver = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this._topicConn = null;
                this._queueConn = null;
                this._topicSession = null;
                this._queueSession = null;
                this._publisher = null;
                this._sender = null;
                this._subscriber = null;
                this._receiver = null;
                throw throwable;
            }
        }

        private void establish() throws JAXRPCException {
            block13: {
                if (this._topicConn != null || this._queueConn != null) {
                    return;
                }
                try {
                    if (this._queueFactory != null || this._queueFactoryJNDI != null) {
                        boolean bl;
                        if (this._queue == null && this._queueJNDI != null) {
                            this.getInitialContext();
                            this._queue = (Queue)this._ctx.lookup(this._queueJNDI);
                        }
                        if (this._queue == null) {
                            throw new JAXRPCException("no target queue has been specified");
                        }
                        if (this._queueFactory == null) {
                            this.getInitialContext();
                            this._queueFactory = (QueueConnectionFactory)this._ctx.lookup(this._queueFactoryJNDI);
                        }
                        this._queueConn = this._username != null && this._password != null ? this._queueFactory.createQueueConnection(this._username, this._password) : this._queueFactory.createQueueConnection();
                        System.out.println("created " + this._queueConn);
                        this._queueSession = this._queueConn.createQueueSession(false, 1);
                        System.out.println("created " + this._queueSession);
                        this._sender = this._queueSession.createSender(this._queue);
                        System.out.println("created " + this._sender + " on " + this._queue);
                        boolean bl2 = bl = !this._correlate && !this._requestor && this._queueReply != null;
                        if (bl) {
                            this._receiver = this._selector != null ? this._queueSession.createReceiver(this._queueReply, this._selector) : this._queueSession.createReceiver(this._queueReply);
                            System.out.println("created " + this._receiver + " on " + this._queueReply);
                        }
                        this._queueConn.start();
                        break block13;
                    }
                    if (this._topicFactory != null || this._topicFactoryJNDI != null) {
                        boolean bl;
                        if (this._topic == null) {
                            throw new JAXRPCException("no target topic has been specified");
                        }
                        if (this._topicFactory == null) {
                            this.getInitialContext();
                            this._topicFactory = (TopicConnectionFactory)this._ctx.lookup(this._topicFactoryJNDI);
                        }
                        this._topicConn = this._username != null && this._password != null ? this._topicFactory.createTopicConnection(this._username, this._password) : this._topicFactory.createTopicConnection();
                        System.out.println("created " + this._topicConn);
                        this._topicSession = this._topicConn.createTopicSession(false, 1);
                        System.out.println("created " + this._topicSession);
                        this._publisher = this._topicSession.createPublisher(this._topic);
                        System.out.println("created " + this._publisher + " on " + this._topic);
                        boolean bl3 = bl = !this._correlate && !this._requestor && this._topicReply != null;
                        if (bl) {
                            this._subscriber = this._durableName != null ? (this._selector != null ? this._topicSession.createDurableSubscriber(this._topicReply, this._durableName, this._selector, false) : this._topicSession.createDurableSubscriber(this._topicReply, this._durableName)) : (this._selector != null ? this._topicSession.createSubscriber(this._topicReply, this._selector, false) : this._topicSession.createSubscriber(this._topicReply));
                            System.out.println("created " + this._subscriber + " on " + this._topicReply);
                        }
                        this._topicConn.start();
                        break block13;
                    }
                    throw new JAXRPCException("no connection factory has been specified");
                }
                catch (NamingException namingException) {
                    namingException.printStackTrace();
                    throw new JAXRPCException("failed to lookup factory: " + namingException.getMessage(), namingException);
                }
                catch (JMSException jMSException) {
                    jMSException.printStackTrace();
                    throw new JAXRPCException("failed to establish connection: " + jMSException.getMessage(), jMSException);
                }
            }
        }

        private TopicSubscriber createSubscriber(Topic topic) throws JMSException {
            Object object;
            Object object2 = null;
            if (this._correlate) {
                object = "JMSCorrelationID = '" + System.currentTimeMillis() + "'";
                object2 = this._selector == null || this._selector.length() == 0 ? object : (String)object + " and " + this._selector;
            }
            object = this._durableName != null ? (object2 != null ? this._topicSession.createDurableSubscriber(topic, this._durableName, object2, false) : this._topicSession.createDurableSubscriber(topic, this._durableName)) : (object2 != null ? this._topicSession.createSubscriber(topic, object2, false) : this._topicSession.createSubscriber(topic));
            System.out.println("created " + object + " on " + topic + " with selector " + (String)object2);
            return object;
        }

        private QueueReceiver createReceiver(Queue queue) throws JMSException {
            Object object;
            Object object2 = null;
            if (this._correlate) {
                object = "JMSCorrelationID = '" + System.currentTimeMillis() + "'";
                object2 = this._selector == null || this._selector.length() == 0 ? object : (String)object + " and " + this._selector;
            }
            object = object2 != null ? this._queueSession.createReceiver(queue, object2) : this._queueSession.createReceiver(queue);
            System.out.println("created " + object + " on " + queue + " with selector " + (String)object2);
            return object;
        }

        public InputStream invoke(ClientRequest clientRequest, Properties properties) {
            return this.invoke(clientRequest);
        }

        public InputStream invoke(ClientRequest clientRequest) {
            TextMessage textMessage;
            Object object;
            Map map = clientRequest._getProperties();
            if (map != null) {
                object = map.entrySet().iterator();
                textMessage = object.next();
                this.setProperty((String)textMessage.getKey(), textMessage.getValue());
            }
            this.establish();
            try {
                Object object2;
                object = new ByteArrayOutputStream();
                clientRequest.size();
                clientRequest.writeTo((OutputStream)object);
                ((OutputStream)object).flush();
                if (this._queueSession != null) {
                    Object object3;
                    textMessage = this._queueSession.createTextMessage();
                    if (map != null) {
                        object3 = (String)map.get("javax.xml.rpc.soap.http.soapaction.uri");
                        if (object3 != null) {
                            textMessage.setStringProperty("javax.xml.rpc.soap.http.soapaction.uri", (String)object3);
                        }
                        if ((object3 = (String)map.get("soapAction")) != null) {
                            textMessage.setStringProperty("soapAction", (String)object3);
                        }
                    }
                    object3 = this._queueReply;
                    if (this._requestor) {
                        object3 = this._queueSession.createTemporaryQueue();
                    }
                    if (object3 != null) {
                        System.out.println("setting replyTo to " + object3);
                        textMessage.setJMSReplyTo((Destination)object3);
                    }
                    textMessage.setText(new String(((ByteArrayOutputStream)object).toByteArray()));
                    this._sender.send((Message)textMessage);
                    System.out.println("sent " + textMessage);
                    QueueReceiver queueReceiver = null;
                    if (this._requestor) {
                        queueReceiver = this.createReceiver((Queue)object3);
                    } else if (object3 != null) {
                        QueueReceiver queueReceiver2 = queueReceiver = this._correlate ? this.createReceiver(this._queueReply) : this._receiver;
                    }
                    if (queueReceiver != null) {
                        Message message = this._timeout > 0 ? queueReceiver.receive((long)this._timeout) : queueReceiver.receive();
                        System.out.println("received " + message);
                        if (this._receiver == null) {
                            queueReceiver.close();
                        }
                        if (message == null) {
                            throw new JAXRPCException("didn't get reply message");
                        }
                        if (message instanceof TextMessage) {
                            return new ByteArrayInputStream(((TextMessage)message).getText().getBytes());
                        }
                        throw new JAXRPCException("response was not a text message");
                    }
                    return _voidStream;
                }
                textMessage = this._topicSession.createTextMessage();
                if (map != null) {
                    object2 = (String)map.get("javax.xml.rpc.soap.http.soapaction.uri");
                    if (object2 != null) {
                        textMessage.setStringProperty("javax.xml.rpc.soap.http.soapaction.uri", (String)object2);
                    }
                    if ((object2 = (String)map.get("soapAction")) != null) {
                        textMessage.setStringProperty("soapAction", (String)object2);
                    }
                }
                object2 = this._topicReply;
                if (this._requestor) {
                    object2 = this._topicSession.createTemporaryTopic();
                }
                if (object2 != null) {
                    System.out.println("setting replyTo to " + object2);
                    textMessage.setJMSReplyTo((Destination)object2);
                }
                textMessage.setText(new String(((ByteArrayOutputStream)object).toByteArray()));
                this._publisher.publish((Message)textMessage);
                System.out.println("published " + textMessage);
                TopicSubscriber topicSubscriber = null;
                if (this._requestor) {
                    topicSubscriber = this.createSubscriber((Topic)object2);
                } else if (object2 != null) {
                    TopicSubscriber topicSubscriber2 = topicSubscriber = this._correlate ? this.createSubscriber(this._topicReply) : this._subscriber;
                }
                if (topicSubscriber != null) {
                    Message message = this._timeout > 0 ? topicSubscriber.receive((long)this._timeout) : topicSubscriber.receive();
                    System.out.println("received " + message);
                    if (this._subscriber == null) {
                        topicSubscriber.close();
                    }
                    if (message instanceof TextMessage) {
                        return new ByteArrayInputStream(((TextMessage)message).getText().getBytes());
                    }
                    throw new JAXRPCException("response was not a text message");
                }
                return _voidStream;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new JAXRPCException("unexpected I/O exception: " + iOException.getMessage(), iOException);
            }
            catch (JMSException jMSException) {
                jMSException.printStackTrace();
                throw new JAXRPCException("unable to send message: " + jMSException.getMessage(), jMSException);
            }
            catch (Exception exception) {
                if (exception instanceof JAXRPCException) {
                    throw (JAXRPCException)exception;
                }
                exception.printStackTrace();
                throw new JAXRPCException("unexpected error: " + exception.getMessage(), exception);
            }
        }
    }
}

