/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.transport.local;

import com.sssw.jbroker.web.Binding;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.core.Constants;
import com.sssw.jbroker.web.core.MultipartRequest;
import com.sssw.jbroker.web.portable.ClientRequest;
import com.sssw.jbroker.web.portable.InvokeHandler;
import com.sssw.jbroker.web.portable.OutputStream;
import com.sssw.jbroker.web.portable.ServerResponse;
import com.sssw.jbroker.web.portable.ServletSkeleton;
import com.sssw.jbroker.web.spi.TransportHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class LoopBackHandler
implements TransportHandler,
Constants {
    private static boolean _debug = false;
    private static final String _CHARSET = "charset";

    public LoopBackHandler(Properties properties) {
    }

    public String getProtocol() {
        return "local";
    }

    public TransportHandler.TransportEndpoint createEndpoint(Binding binding) throws MalformedURLException {
        try {
            String string = null;
            String string2 = binding.getURLStr();
            if (string2.startsWith("local://")) {
                string = string2.substring(8);
            } else if (string2.startsWith("local:")) {
                string = string2.substring(6);
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(string, true, classLoader);
            if (clazz == null) {
                throw new ClassNotFoundException(string);
            }
            ServletSkeleton servletSkeleton = (ServletSkeleton)clazz.newInstance();
            servletSkeleton.init();
            return new LoopBackEndPoint(servletSkeleton);
        }
        catch (Exception exception) {
            if (exception instanceof ServiceException) {
                throw (ServiceException)exception;
            }
            throw new ServiceException("unable to create local endpoint " + exception.getMessage());
        }
    }

    private static class LoopBackEndPoint
    implements TransportHandler.TransportEndpoint {
        private final InvokeHandler _handler;

        LoopBackEndPoint(InvokeHandler invokeHandler) {
            this._handler = invokeHandler;
        }

        public void setProperty(String string, Object object) {
        }

        public InputStream invoke(ClientRequest clientRequest, Properties properties) {
            try {
                HashMap hashMap = new HashMap();
                String string = (String)clientRequest._getProperties().get("http.content.type");
                InputStream inputStream = this.getInputStream(clientRequest);
                ServerResponse serverResponse = this._handler._invoke(properties, inputStream);
                String string2 = (String)serverResponse._getProperties().get("http.content.type");
                if (string2 == null) {
                    string2 = (String)serverResponse._getProperties().get("content-type");
                }
                if (string2 == null) {
                    string2 = string;
                }
                ((Hashtable)properties).put("content-type", string2);
                return this.getInputStream(serverResponse);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new ServiceException(iOException.getMessage());
            }
        }

        private Reader getReader(OutputStream outputStream) throws IOException {
            return new InputStreamReader(this.getInputStream(outputStream));
        }

        private InputStream getInputStream(OutputStream outputStream) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            outputStream.writeTo(byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }

        private Reader getReader(OutputStream outputStream, Map map, Properties properties) throws IOException {
            String string = (String)outputStream._getProperties().get("http.content.type");
            if (_debug) {
                System.out.println("http.content.type=" + string);
            }
            String string2 = (String)outputStream._getProperties().get("http.content.location");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            Reader reader = null;
            boolean bl = MultipartRequest.isMultipart(string);
            if (bl) {
                MultipartRequest multipartRequest = MultipartRequest.createMultipartRequest(byteArrayInputStream, string, string2);
                map.putAll(multipartRequest.getMIMEParts());
                reader = multipartRequest.getRoot();
            } else {
                String string3 = null;
                if (string != null) {
                    Properties properties2 = MultipartRequest.getAttributes(string, ";");
                    string3 = properties2.getProperty(LoopBackHandler._CHARSET);
                }
                Reader reader2 = reader = string3 == null ? new InputStreamReader(byteArrayInputStream) : new InputStreamReader((InputStream)byteArrayInputStream, string3);
            }
            if (properties != null) {
                properties.setProperty("content-type", string);
                if (string2 != null) {
                    properties.setProperty("content-location", string2);
                }
            }
            return reader;
        }
    }
}

