/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.xml.rpc;

import com.sssw.jbroker.web.Binding;
import com.sssw.jbroker.web.ServiceException;
import com.sssw.jbroker.web.core.DelegateImpl;
import com.sssw.jbroker.web.encoding.DefaultTypeMappingRegistry;
import com.sssw.jbroker.web.encoding.TypeMap;
import com.sssw.jbroker.web.portable.ClientRequest;
import com.sssw.jbroker.web.portable.ClientResponse;
import com.sssw.jbroker.web.soap.PrimitiveTypeMapper;
import com.sssw.jbroker.web.xml.rpc.ServiceImpl;
import com.sssw.jbroker.web.xml.rpc.handler.HandlerChainImpl;
import java.io.EOFException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerChain;

public final class CallImpl
implements Call {
    private String _SOAP = "soap";
    private String _DOCUMENT = "document";
    private String _RPC = "rpc";
    private String _EMPTY_SAC = "\"\"";
    private String _SOAP_ENC_URI = "http://schemas.xmlsoap.org/soap/encoding/";
    private boolean _isParameterAndReturnSpecRequired = true;
    private ArrayList _parameterInfos = new ArrayList();
    private QName _returnXMLType;
    private Class _returnJavaType;
    private QName _portType;
    private QName _operationName;
    private final QName _portName;
    private String _endpointAddress;
    private String _schemaURI;
    private HashMap _properties = new HashMap();
    private Map _outParams = new DupMap();
    private PrimitiveTypeMapper _primMapper = PrimitiveTypeMapper.getSingleton();
    private DefaultTypeMappingRegistry _typeMappingRegistry = null;
    private Object _returnValue;
    private DelegateImpl _delegate = new DelegateImpl();
    private ServiceImpl _service;
    private static final ArrayList _propertyNames = new ArrayList();
    private boolean _invoked;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;

    public CallImpl(ServiceImpl serviceImpl, QName qName) {
        this._service = serviceImpl;
        this._portName = qName;
        this._portType = new QName("");
        this.setTypeMappingRegistry(serviceImpl.getTypeMappingRegistry());
        this.setDefaults();
    }

    private void setDefaults() {
        this._properties.put("javax.xml.rpc.encodingstyle.namespace.uri", this._SOAP_ENC_URI);
        this._properties.put("javax.xml.rpc.soap.http.soapaction.use", Boolean.FALSE);
        this._properties.put("javax.xml.rpc.soap.http.soapaction.uri", this._EMPTY_SAC);
        this._properties.put("javax.xml.rpc.session.maintain", Boolean.TRUE);
        this._properties.put("javax.xml.rpc.soap.operation.style", this._RPC);
        this._properties.put("xmlrpc.schema.uri", "http://www.w3.org/2001/XMLSchema");
    }

    public boolean isParameterAndReturnSpecRequired(QName qName) {
        return this._isParameterAndReturnSpecRequired;
    }

    public void addParameter(String string, QName qName, ParameterMode parameterMode) {
        int n;
        if (!this._isParameterAndReturnSpecRequired) {
            throw new JAXRPCException("Parameter spec is complete");
        }
        QName qName2 = null;
        if (string.charAt(0) == '{' && (n = string.indexOf("}")) > 0) {
            qName2 = new QName(string.substring(1, n), string.substring(n + 1));
        }
        if (qName2 == null) {
            qName2 = new QName(null, string);
        }
        this.addParameter(qName2, qName, null, parameterMode);
    }

    public void addParameter(String string, QName qName, Class clazz, ParameterMode parameterMode) {
        int n;
        QName qName2 = null;
        if (string.charAt(0) == '{' && (n = string.indexOf("}")) > 0) {
            qName2 = new QName(string.substring(1, n), string.substring(n + 1));
        }
        if (qName2 == null) {
            qName2 = new QName(null, string);
        }
        this.addParameter(qName2, qName, clazz, parameterMode);
    }

    public void addParameter(QName qName, QName qName2, Class clazz, ParameterMode parameterMode) {
        if (!this._isParameterAndReturnSpecRequired) {
            throw new IllegalArgumentException("Parameter spec is concrete!");
        }
        if (clazz != null && (class$javax$xml$rpc$holders$Holder == null ? (class$javax$xml$rpc$holders$Holder = CallImpl.class$("javax.xml.rpc.holders.Holder")) : class$javax$xml$rpc$holders$Holder).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("holder parameters not allowed");
        }
        this._parameterInfos.add(new ParameterInfo(qName, qName2, clazz, parameterMode));
    }

    public QName getParameterTypeByName(String string) {
        int n = 0;
        while (n < this._parameterInfos.size()) {
            ParameterInfo parameterInfo = (ParameterInfo)this._parameterInfos.get(n);
            if (parameterInfo.getName().getLocalPart().equals(string)) {
                return parameterInfo.getXMLType();
            }
            ++n;
        }
        return null;
    }

    public void setReturnType(QName qName) {
        if (!this._isParameterAndReturnSpecRequired) {
            throw new JAXRPCException("Parameter spec is complete");
        }
        this._returnXMLType = qName;
    }

    public void setReturnType(QName qName, Class clazz) {
        if (!this._isParameterAndReturnSpecRequired) {
            throw new JAXRPCException("Parameter spec is complete");
        }
        this._returnXMLType = qName;
        this._returnJavaType = clazz;
    }

    public Class getReturnJavaType() {
        return this._returnJavaType;
    }

    public QName getReturnType() {
        return this._returnXMLType;
    }

    public void removeAllParameters() {
        if (!this._isParameterAndReturnSpecRequired) {
            throw new JAXRPCException("Parameter spec is complete");
        }
        this._parameterInfos.clear();
    }

    public QName getOperationName() {
        return this._operationName;
    }

    public void setOperationName(QName qName) {
        this._operationName = qName;
    }

    public QName getPortTypeName() {
        return this._portType;
    }

    public void setPortTypeName(QName qName) {
        this._portType = qName;
    }

    public String getTargetEndpointAddress() {
        return this._endpointAddress;
    }

    public void setTargetEndpointAddress(String string) {
        this._endpointAddress = string;
    }

    public void setProperty(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException("Property Name not specified");
        }
        if (!_propertyNames.contains(string)) {
            throw new IllegalArgumentException(string + "is an invalid Property");
        }
        if (string != null && string.equals("javax.xml.rpc.soap.http.soapaction.uri")) {
            if (object == null) {
                this._properties.put(string, "\"\"");
            } else if (object instanceof String) {
                String string2 = (String)object;
                if (!string2.startsWith("\"") && !string2.endsWith("\"")) {
                    string2 = "\"" + string2 + "\"";
                }
                this._properties.put(string, string2);
            } else {
                this._properties.put(string, object);
            }
        } else {
            this._properties.put(string, object);
        }
    }

    public Object getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Property Name not specified");
        }
        if (!_propertyNames.contains(string)) {
            throw new IllegalArgumentException(string + "is an invalid Property");
        }
        return this._properties.get(string);
    }

    public void removeProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Property Name not specified");
        }
        if (!_propertyNames.contains(string)) {
            throw new IllegalArgumentException(string + "is an invalid Property");
        }
        this._properties.remove(string);
    }

    public Iterator getPropertyNames() {
        return ((AbstractList)_propertyNames).iterator();
    }

    public Object invoke(Object[] objectArray) throws RemoteException {
        this._properties.put("xmlrpc.soap.operation.twoWay", Boolean.TRUE);
        if (this._operationName == null) {
            throw new IllegalArgumentException("set operationName before calling this method!");
        }
        return this._invoke(this._operationName, objectArray);
    }

    public Object invoke(QName qName, Object[] objectArray) throws RemoteException {
        this._properties.put("xmlrpc.soap.operation.twoWay", Boolean.TRUE);
        return this._invoke(qName, objectArray);
    }

    public void invokeOneWay(Object[] objectArray) {
        this._properties.put("xmlrpc.soap.operation.twoWay", Boolean.FALSE);
        if (this._operationName == null) {
            throw new IllegalArgumentException("set operationName before calling this method!");
        }
        try {
            this._invoke(this._operationName, objectArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this._invoked = false;
    }

    private Object _invoke(QName qName, Object[] objectArray) throws RemoteException {
        this.setRequestProperties();
        this._properties.put("xmlrpc.soap.operation.name", qName);
        try {
            ClientRequest clientRequest = this.createRequest();
            this.serializeINParams(objectArray, clientRequest);
            List list = this._service.getHandlerRegistry().getHandlerChain(this._portName);
            this._setHandlerChain(new HandlerChainImpl(list));
            ClientResponse clientResponse = this._delegate.invoke(clientRequest);
            this.deserializeOUTParams(clientResponse);
            this._invoked = true;
            return this._returnValue;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            ServiceException serviceException;
            if (throwable instanceof ServiceException && (serviceException = (ServiceException)throwable).getTargetException() != null) {
                throwable2 = serviceException.getTargetException();
            }
            throw ServiceException.mapToRemote(throwable2);
        }
    }

    private void setRequestProperties() {
        boolean bl;
        String string = (String)this._properties.get("javax.xml.rpc.soap.operation.style");
        boolean bl2 = this._DOCUMENT.equalsIgnoreCase(string);
        if (!bl2 && !(bl = this._RPC.equalsIgnoreCase(string))) {
            throw new IllegalArgumentException("Illegal style for SOAP");
        }
        this._properties.put("xmlrpc.soap.operation.isDocument", new Boolean(bl2));
    }

    private ClientRequest createRequest() throws MalformedURLException {
        Binding binding = new Binding(this._SOAP, this._endpointAddress);
        this._delegate.setCurrentBinding(binding);
        ClientRequest clientRequest = this._delegate.soapRequest(this._properties);
        clientRequest.setTypeMappingRegistry(this._typeMappingRegistry);
        clientRequest._setProperties(this._properties);
        return clientRequest;
    }

    void _setHandlerChain(HandlerChain handlerChain) {
        this._delegate.setHandlerChain(handlerChain);
    }

    private void serializeINParams(Object[] objectArray, ClientRequest clientRequest) throws IOException {
        Object object = null;
        int n = 0;
        while (n < objectArray.length) {
            object = objectArray[n];
            ParameterInfo parameterInfo = (ParameterInfo)this._parameterInfos.get(n);
            if (parameterInfo.getParameterMode() != ParameterMode.OUT) {
                clientRequest.writeObject(object, parameterInfo.getName().getNamespaceURI(), parameterInfo.getName().getLocalPart());
            }
            ++n;
        }
    }

    private void deserializeOUTParams(ClientResponse clientResponse) throws IOException {
        Object object;
        Object object2 = null;
        this._outParams = new DupMap();
        int n = this._parameterInfos.size();
        int n2 = 0;
        while (n2 < n) {
            object = (ParameterInfo)this._parameterInfos.get(n2);
            if (((ParameterInfo)object).getParameterMode() != ParameterMode.IN) {
                Class clazz = ((ParameterInfo)object).getJavaType();
                if (clazz == null) {
                    clazz = this.getTypeMapping(((ParameterInfo)object).getXMLType());
                }
                try {
                    object2 = clientResponse.readObject(clazz, ((ParameterInfo)object).getName().getNamespaceURI(), ((ParameterInfo)object).getName().getLocalPart());
                    this._outParams.put(((ParameterInfo)object).getName().getLocalPart(), object2);
                }
                catch (EOFException eOFException) {
                    object2 = null;
                }
            }
            ++n2;
        }
        if (this._returnXMLType != null) {
            object = this._returnJavaType;
            if (object == null) {
                object = this.getTypeMapping(this._returnXMLType);
            }
            try {
                this._returnValue = object2 = clientResponse.readObject((Class)object, this._returnXMLType.getNamespaceURI(), this._returnXMLType.getLocalPart());
            }
            catch (EOFException eOFException) {
                this._returnValue = null;
            }
        }
    }

    public Map getOutputParams() {
        if (!this._invoked) {
            throw new JAXRPCException("Not yet invoked or a one way call!");
        }
        return this._outParams;
    }

    public List getOutputValues() {
        if (!this._invoked) {
            throw new JAXRPCException("Not yet invoked or a one way call!");
        }
        ArrayList arrayList = new ArrayList();
        Set set = this._outParams.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    void setTypeMappingRegistry(TypeMappingRegistry typeMappingRegistry) {
        this._typeMappingRegistry = (DefaultTypeMappingRegistry)typeMappingRegistry;
    }

    public void setSchemaURI(String string) {
        this._properties.put("xmlrpc.schema.uri", string);
    }

    public void setSOAPActionURI(String string) {
        this._properties.put("javax.xml.rpc.soap.http.soapaction.uri", string);
    }

    public void setDocumentStyle(boolean bl) {
        String string = null;
        string = bl ? this._DOCUMENT : this._RPC;
        this._properties.put("javax.xml.rpc.soap.operation.style", string);
    }

    private Class getTypeMapping(QName qName) {
        TypeMap typeMap = null;
        typeMap = this._primMapper.get(qName);
        if (typeMap != null) {
            return typeMap.getJavaType();
        }
        typeMap = this._typeMappingRegistry.get(qName);
        if (typeMap != null) {
            return typeMap.getJavaType();
        }
        return null;
    }

    private boolean isReturnParam(QName qName) {
        return this._returnXMLType != null && this._returnXMLType.equals(qName);
    }

    private boolean isReturnType(ParameterInfo parameterInfo) {
        if (parameterInfo.getJavaType() != null && parameterInfo.getJavaType().equals(this._returnJavaType)) {
            return parameterInfo.getXMLType().equals(this._returnXMLType);
        }
        return parameterInfo.getXMLType().equals(this._returnXMLType);
    }

    public String toString() {
        return "portName=" + this._portName + ":operation=" + this._operationName + "\nparamters=" + this._parameterInfos;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _propertyNames.add("javax.xml.rpc.encodingstyle.namespace.uri");
        _propertyNames.add("javax.xml.rpc.soap.operation.style");
        _propertyNames.add("javax.xml.rpc.security.auth.password");
        _propertyNames.add("javax.xml.rpc.session.maintain");
        _propertyNames.add("javax.xml.rpc.soap.http.soapaction.uri");
        _propertyNames.add("javax.xml.rpc.soap.http.soapaction.use");
        _propertyNames.add("javax.xml.rpc.security.auth.username");
        _propertyNames.add("xmlrpc.schema.uri");
    }

    private static final class DupEntry
    implements Map.Entry {
        private final Object _key;
        private Object _value;

        private DupEntry(Object object, Object object2) {
            this._key = object;
            this._value = object2;
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        public int hashCode() {
            return this._key.hashCode() + this._value.hashCode();
        }

        public boolean equals(Object object) {
            try {
                DupEntry dupEntry = (DupEntry)object;
                return this._key.equals(dupEntry._key) && this._value.equals(dupEntry._value);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public Object setValue(Object object) {
            Object object2 = this._value;
            this._value = object;
            return object2;
        }
    }

    private static final class DupMap
    extends AbstractMap {
        private final ArrayList _list = new ArrayList();

        public Set entrySet() {
            return new DupSet(this._list);
        }

        public Object get(Object object) {
            int n = this._list.indexOf(object);
            if (n >= 0) {
                DupEntry dupEntry = (DupEntry)this._list.get(n);
                return dupEntry.getValue();
            }
            return null;
        }

        public Object put(Object object, Object object2) {
            this._list.add(new DupEntry(object, object2));
            return null;
        }
    }

    private static final class DupSet
    extends AbstractSet {
        private final ArrayList _list;

        public DupSet(ArrayList arrayList) {
            this._list = arrayList;
        }

        public Iterator iterator() {
            return ((AbstractList)this._list).iterator();
        }

        public int size() {
            return this._list.size();
        }
    }

    static final class ParameterInfo {
        private QName _name = null;
        private QName _xmlType = null;
        private Class _javaType = null;
        private ParameterMode _mode = ParameterMode.OUT;

        public QName getName() {
            return this._name;
        }

        public QName getXMLType() {
            return this._xmlType;
        }

        public Class getJavaType() {
            return this._javaType;
        }

        public ParameterMode getParameterMode() {
            return this._mode;
        }

        ParameterInfo(QName qName, QName qName2, ParameterMode parameterMode) {
            this._name = qName;
            this._xmlType = qName2;
            this._mode = parameterMode;
        }

        ParameterInfo(QName qName, QName qName2, Class clazz, ParameterMode parameterMode) {
            this._name = qName;
            this._xmlType = qName2;
            this._javaType = clazz;
            this._mode = parameterMode;
        }

        public String toString() {
            return "{name=" + this._name + ",xmlType=" + this._xmlType + ",javaType=" + this._javaType + ",mode=" + this._mode + "}";
        }
    }
}

