/*
 * Decompiled with CFR 0.152.
 */
package com.sssw.jbroker.web.xml.rpc;

import com.sssw.jbroker.tools.wsdl2java.CodeGenerator;
import com.sssw.jbroker.tools.wsdl2java.Main;
import com.sssw.jbroker.tools.wsdlast.ASTBinding;
import com.sssw.jbroker.tools.wsdlast.ASTDocument;
import com.sssw.jbroker.tools.wsdlast.ASTHttpPort;
import com.sssw.jbroker.tools.wsdlast.ASTOperation;
import com.sssw.jbroker.tools.wsdlast.ASTPart;
import com.sssw.jbroker.tools.wsdlast.ASTPort;
import com.sssw.jbroker.tools.wsdlast.ASTService;
import com.sssw.jbroker.tools.wsdlast.ASTSoapBodyMessage;
import com.sssw.jbroker.tools.wsdlast.ASTSoapOperation;
import com.sssw.jbroker.tools.wsdlast.ASTSoapPort;
import com.sssw.jbroker.web.Binding;
import com.sssw.jbroker.web.xml.rpc.ServiceImpl;
import java.net.URL;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;

public class DynamicServiceImpl
extends ServiceImpl {
    private URL _wsdlLocation;
    private HashMap _ports = new HashMap();
    private HashMap _calls = new HashMap();

    public DynamicServiceImpl(URL uRL, QName qName) throws ServiceException {
        super(qName);
        ASTService[] aSTServiceArray;
        if (qName == null) {
            throw new ServiceException("Service QName must be specified");
        }
        this._wsdlLocation = uRL;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector vector = new Vector();
        hashtable.put("nowarn", "");
        hashtable.put("nogenerate", "");
        hashtable.put("notypes", "");
        ASTDocument aSTDocument = null;
        try {
            aSTServiceArray = new CodeGenerator(vector);
            Main main = new Main();
            aSTDocument = Main.compile((CodeGenerator)aSTServiceArray, this._wsdlLocation.toString(), hashtable);
        }
        catch (Exception exception) {
            throw new ServiceException("Invalid wsdl location: " + exception.getMessage());
        }
        if (aSTDocument == null) {
            throw new ServiceException("Invalid wsdl location");
        }
        aSTServiceArray = aSTDocument.getServices();
        if (aSTServiceArray == null || aSTServiceArray.length == 0) {
            throw new ServiceException("No Services found");
        }
        boolean bl = false;
        int n = 0;
        n = 0;
        while (n < aSTServiceArray.length) {
            if (qName.equals(new QName(aSTServiceArray[n].getNsURI(), aSTServiceArray[n].getLocalName()))) {
                bl = true;
            }
            if (bl) break;
            ++n;
        }
        if (!bl) {
            throw new ServiceException("Invalid Service " + qName);
        }
        this.configureService(aSTServiceArray[n]);
    }

    public Remote getPort(Class clazz) throws ServiceException {
        throw new ServiceException("Not implemented");
    }

    public Remote getPort(QName qName, Class clazz) throws ServiceException {
        if (!this._ports.containsKey(qName)) {
            throw new ServiceException("Invalid PortName");
        }
        if (clazz == null) {
            throw new ServiceException("No class specified");
        }
        Binding binding = (Binding)this._ports.get(qName);
        return this.getPort(clazz, binding, null, this._typeMappingRegistry, qName);
    }

    public Call createCall() throws ServiceException {
        return super.createCall();
    }

    public Call createCall(QName qName) throws ServiceException {
        if (qName == null) {
            throw new ServiceException("Port must be specified");
        }
        return super.createCall(qName);
    }

    public Call createCall(QName qName, QName qName2) throws ServiceException {
        if (qName2 == null) {
            throw new ServiceException("Operation must be specified");
        }
        return super.createCall(qName, qName2);
    }

    public Call createCall(QName qName, String string) throws ServiceException {
        if (string == null || string.length() == 0) {
            throw new ServiceException("Operation name must be specified");
        }
        return super.createCall(qName, string);
    }

    public Iterator getPorts() {
        return this._ports.keySet().iterator();
    }

    public URL getWSDLDocumentLocation() {
        return this._wsdlLocation;
    }

    public String toString() {
        return "{Configured jBroker Web Service {" + this.getServiceName().toString() + "}}";
    }

    public void configureService(ASTService aSTService) {
        ASTPort[] aSTPortArray = aSTService.getPorts();
        if (aSTPortArray == null) {
            return;
        }
        int n = 0;
        while (n < aSTPortArray.length) {
            ASTOperation[] aSTOperationArray;
            QName qName = new QName(aSTPortArray[n].getNsURI(), aSTPortArray[n].getLocalName());
            String string = null;
            if (aSTPortArray[n] instanceof ASTHttpPort) {
                string = ((ASTHttpPort)aSTPortArray[n]).getLocation();
            } else if (aSTPortArray[n] instanceof ASTSoapPort) {
                string = ((ASTSoapPort)aSTPortArray[n]).getLocation();
            }
            ASTBinding aSTBinding = aSTPortArray[n].getBinding();
            Binding binding = null;
            if (string != null) {
                binding = new Binding("soap", string);
            }
            this._ports.put(qName, binding);
            if (aSTBinding != null && (aSTOperationArray = aSTBinding.getOperations()) != null) {
                int n2 = 0;
                while (n2 < aSTOperationArray.length) {
                    QName qName2 = new QName(aSTOperationArray[n2].getNsURI(), aSTOperationArray[n2].getName());
                    try {
                        Call call = this.createCall(qName, qName2);
                        if (aSTOperationArray[n2] instanceof ASTSoapOperation) {
                            this.generateSoapCallParameters((ASTSoapOperation)aSTOperationArray[n2], call);
                        }
                        if (string != null) {
                            call.setTargetEndpointAddress(string);
                        }
                        this.addCall(qName, call);
                    }
                    catch (ServiceException serviceException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public Call[] getCalls(QName qName) throws ServiceException {
        if (qName == null) {
            throw new ServiceException("PortName not specified");
        }
        if (!this._calls.containsKey(qName)) {
            throw new ServiceException("Invalid PortName");
        }
        ArrayList arrayList = (ArrayList)this._calls.get(qName);
        if (arrayList == null) {
            return null;
        }
        Call[] callArray = new Call[arrayList.size()];
        return arrayList.toArray(callArray);
    }

    private void addCall(QName qName, Call call) {
        ArrayList<Call> arrayList = (ArrayList<Call>)this._calls.get(qName);
        if (arrayList == null) {
            arrayList = new ArrayList<Call>();
            this._calls.put(qName, arrayList);
        }
        arrayList.add(call);
    }

    void generateSoapCallParameters(ASTSoapOperation aSTSoapOperation, Call call) {
        Object object;
        Object object2;
        QName qName;
        int n;
        Object object3;
        ASTSoapBodyMessage aSTSoapBodyMessage = (ASTSoapBodyMessage)aSTSoapOperation.getInput();
        ASTSoapBodyMessage aSTSoapBodyMessage2 = (ASTSoapBodyMessage)aSTSoapOperation.getOutput();
        if (aSTSoapBodyMessage != null) {
            object3 = aSTSoapBodyMessage.getParts();
            n = 0;
            while (n < ((ASTPart[])object3).length) {
                qName = object3[n].getQName() != null ? ((ASTPart)object3[n]).getQName() : new QName(aSTSoapOperation.getNsURI(), ((ASTPart)object3[n]).getName());
                object2 = ((ASTPart)object3[n]).getMode() == 1 ? ParameterMode.IN : ParameterMode.INOUT;
                object = ((ASTPart)object3[n]).getMode() == 1 ? ((ASTPart)object3[n]).getDataType() : ((ASTPart)object3[n]).getInOutType();
                String string = aSTSoapOperation.isDocument() ? qName.toString() : ((ASTPart)object3[n]).getJavafiedName();
                try {
                    Class<?> clazz = Class.forName(object);
                    call.addParameter(string, qName, clazz, (ParameterMode)object2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                ++n;
            }
        }
        if (aSTSoapBodyMessage2 != null && aSTSoapBodyMessage2.hasOutParameters()) {
            object3 = aSTSoapBodyMessage2.getParts();
            n = 0;
            while (n < ((ASTPart[])object3).length) {
                if (((ASTPart)object3[n]).getMode() != 3) {
                    qName = ((ASTPart)object3[n]).getQName() != null ? ((ASTPart)object3[n]).getQName() : new QName(aSTSoapOperation.getNsURI(), ((ASTPart)object3[n]).getName());
                    object2 = aSTSoapOperation.isDocument() ? qName.toString() : ((ASTPart)object3[n]).getJavafiedName();
                    try {
                        object = Class.forName(((ASTPart)object3[n]).getInOutType());
                        call.addParameter((String)object2, qName, (Class)object, ParameterMode.OUT);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }
        if (aSTSoapBodyMessage2 != null && !aSTSoapBodyMessage2.isVoid()) {
            object3 = aSTSoapBodyMessage2.getParts();
            n = 0;
            while (n < ((ASTPart[])object3).length) {
                if (((ASTPart)object3[n]).getMode() == 2) {
                    qName = ((ASTPart)object3[n]).getQName() != null ? ((ASTPart)object3[n]).getQName() : new QName(aSTSoapOperation.getNsURI(), ((ASTPart)object3[n]).getName());
                    object2 = aSTSoapOperation.isDocument() ? qName.toString() : ((ASTPart)object3[n]).getJavafiedName();
                    try {
                        object = Class.forName(((ASTPart)object3[n]).getDataType());
                        call.setReturnType(qName, (Class)object);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    break;
                }
                ++n;
            }
        }
        object3 = aSTSoapOperation.isDocument() ? "document" : "rpc";
        call.setProperty("javax.xml.rpc.soap.operation.style", object3);
        if (((String)object3).equals("document")) {
            call.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", null);
        } else {
            String string = aSTSoapOperation.getEncodingStyle();
            if (string != null && string.length() > 0) {
                call.setProperty("javax.xml.rpc.encodingstyle.namespace.uri", string);
            }
        }
        String string = aSTSoapOperation.getAction();
        if (string != null && !string.startsWith("\"") && !string.endsWith("\"")) {
            string = "\"\\\"" + string + "\\\"\"";
        }
        call.setProperty("javax.xml.rpc.soap.http.soapaction.uri", string);
    }
}

