/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.format;

import java.io.IOException;
import java.io.Writer;
import org.gjt.xpp.XmlEndTag;
import org.gjt.xpp.XmlNode;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.XmlRecorder;
import org.gjt.xpp.XmlStartTag;
import org.gjt.xpp.XmlWritable;

public class Recorder
implements XmlRecorder {
    protected String[] declaredPrefixes;
    protected String[] declaredNs;
    protected Writer out;

    public Writer getOutput() {
        return this.out;
    }

    public void setOutput(Writer writer) {
        this.out = writer;
    }

    public void write(Object object) throws IOException, XmlPullParserException {
        if (object instanceof XmlNode) {
            this.writeNode((XmlNode)object);
        } else if (object instanceof XmlStartTag) {
            this.writeStartTag((XmlStartTag)object);
        } else if (object instanceof XmlEndTag) {
            this.writeEndTag((XmlEndTag)object);
        } else if (object instanceof XmlWritable) {
            ((XmlWritable)object).writeXml(this.out);
        } else if (object != null) {
            this.writeContent(object.toString());
        }
    }

    public void writeXml(XmlWritable xmlWritable) throws IOException, XmlPullParserException {
        xmlWritable.writeXml(this.out);
    }

    public void writeContent(String string) throws IOException, XmlPullParserException {
        if (string == null) {
            throw new XmlPullParserException("null string can not be written as XML element content");
        }
        this.writeEscaped(string, false);
    }

    public void writeEndTag(XmlEndTag xmlEndTag) throws IOException, XmlPullParserException {
        if (xmlEndTag.getRawName() == null) {
            throw new XmlPullParserException("raw name of XML element can not be null");
        }
        this.out.write("</");
        this.out.write(xmlEndTag.getRawName());
        this.out.write(62);
    }

    public void writeStartTag(XmlStartTag xmlStartTag) throws IOException, XmlPullParserException {
        this.writeStartTagStart(xmlStartTag);
        this.out.write(62);
    }

    public void writeStartTagStart(XmlStartTag xmlStartTag) throws IOException, XmlPullParserException {
        if (xmlStartTag.getRawName() == null) {
            throw new XmlPullParserException("raw name of XML element can not be null");
        }
        this.out.write(60);
        this.out.write(xmlStartTag.getRawName());
        int n = 0;
        while (n < xmlStartTag.getAttributeCount()) {
            if (!xmlStartTag.isAttributeNamespaceDeclaration(n)) {
                this.out.write(32);
                this.out.write(xmlStartTag.getAttributeRawName(n));
                this.out.write("='");
                this.writeEscaped(xmlStartTag.getAttributeValue(n), true);
                this.out.write(39);
            }
            ++n;
        }
    }

    public void writeStartTagAsEndTag(XmlStartTag xmlStartTag) throws IOException, XmlPullParserException {
        if (xmlStartTag.getRawName() == null) {
            throw new XmlPullParserException("raw name of XML end tag can not be null");
        }
        this.out.write("</");
        this.out.write(xmlStartTag.getRawName());
        this.out.write(62);
    }

    public void writeNode(XmlNode xmlNode) throws IOException, XmlPullParserException {
        String string;
        int n;
        String[] stringArray;
        this.writeStartTagStart(xmlNode);
        int n2 = xmlNode.getDeclaredNamespaceLength();
        if (n2 > 0) {
            int n3;
            if (this.declaredNs == null || n2 > this.declaredNs.length) {
                n3 = n2 + 10;
                stringArray = new String[n3];
                String[] stringArray2 = new String[n3];
                n = this.declaredNs != null ? this.declaredNs.length : 0;
                int n4 = 0;
                while (n4 < n) {
                    stringArray[n4] = this.declaredPrefixes[n4];
                    stringArray2[n4] = this.declaredNs[n4];
                    ++n4;
                }
                this.declaredPrefixes = stringArray;
                this.declaredNs = stringArray2;
            }
            xmlNode.readDeclaredPrefixes(this.declaredPrefixes, 0, n2);
            xmlNode.readDeclaredNamespaceUris(this.declaredNs, 0, n2);
            n3 = 0;
            while (n3 < n2) {
                this.out.write(" xmlns:");
                this.out.write(this.declaredPrefixes[n3]);
                this.out.write("='");
                this.writeEscaped(this.declaredNs[n3], true);
                this.out.write(39);
                ++n3;
            }
        }
        if ((string = xmlNode.getDefaultNamespaceUri()) != null && ((stringArray = xmlNode.getParentNode()) != null && !string.equals(stringArray.getDefaultNamespaceUri()) || stringArray == null && !"".equals(string))) {
            this.out.write(" xmlns='");
            this.writeEscaped(string, true);
            this.out.write(39);
        }
        boolean bl = false;
        int n5 = xmlNode.getChildrenCount();
        n = 0;
        while (n < n5) {
            Object object = xmlNode.getChildAt(n);
            if (object != null) {
                if (!bl) {
                    bl = true;
                    this.out.write(62);
                }
                this.write(object);
            }
            ++n;
        }
        if (bl) {
            this.writeStartTagAsEndTag(xmlNode);
        } else {
            this.out.write("/>");
        }
    }

    protected void writeEscaped(String string, boolean bl) throws IOException, XmlPullParserException {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    if (n2 > n) {
                        this.out.write(string, n, n2 - n);
                    }
                    n = n2 + 1;
                    this.out.write("&lt;");
                    break;
                }
                case '\r': {
                    if (n2 > n) {
                        this.out.write(string, n, n2 - n);
                    }
                    n = n2 + 1;
                    this.out.write("&#xD;");
                    break;
                }
                case '&': {
                    if (n2 > n) {
                        this.out.write(string, n, n2 - n);
                    }
                    n = n2 + 1;
                    this.out.write("&amp;");
                    break;
                }
                case '\t': {
                    if (!bl) break;
                    if (n2 > n) {
                        this.out.write(string, n, n2 - n);
                    }
                    n = n2 + 1;
                    this.out.write("&#x9;");
                    break;
                }
                case '\n': {
                    if (!bl) break;
                    if (n2 > n) {
                        this.out.write(string, n, n2 - n);
                    }
                    n = n2 + 1;
                    this.out.write("&#xA;");
                    break;
                }
                case '\'': {
                    if (!bl) break;
                    if (n2 > n) {
                        this.out.write(string, n, n2 - n);
                    }
                    n = n2 + 1;
                    this.out.write("&apos;");
                }
            }
            ++n2;
        }
        if (n == 0) {
            this.out.write(string);
        } else {
            this.out.write(string, n, n2 - n);
        }
    }
}

