/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.node;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gjt.xpp.XmlNode;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.impl.tag.PullParserRuntimeException;
import org.gjt.xpp.impl.tag.StartTag;

public class Node
extends StartTag
implements XmlNode {
    protected static final Iterator EMPTY_ENUMERATION = new EmptyIterator();
    protected ArrayList children;
    protected int childrenCount;
    protected Object oneChild;
    protected XmlNode parent;
    protected String defaultNamespaceUri;
    protected Map prefix2Ns = new HashMap();
    protected int declaredNsEnd;
    protected String[] declaredNs;
    protected String[] declaredPrefixes;

    public Map getPrefix2Ns() {
        return this.prefix2Ns;
    }

    public void resetNode() {
        super.resetStartTag();
        this.parent = null;
        this.childrenCount = 0;
        this.oneChild = null;
        if (this.children != null) {
            this.children.clear();
        }
        this.removeDeclaredNamespaces();
    }

    public XmlNode newNode() throws XmlPullParserException {
        return new Node();
    }

    public XmlNode newNode(String string, String string2) throws XmlPullParserException {
        Node node = new Node();
        String string3 = this.namespace2Prefix(string);
        if (string3 == null) {
            throw new XmlPullParserException("namespace '" + string + "' has no prefix declared in node tree");
        }
        node.modifyTag(string, string2, "".equals(string3) ? string2 : string3 + ':' + string2);
        return node;
    }

    public XmlNode getParentNode() {
        return this.parent;
    }

    public Iterator children() {
        if (this.childrenCount == 0) {
            return EMPTY_ENUMERATION;
        }
        if (this.childrenCount == 1) {
            return new OneChildIterator(this.oneChild);
        }
        return ((AbstractList)this.children).iterator();
    }

    public int getChildrenCount() {
        return this.childrenCount;
    }

    public Object getChildAt(int n) {
        if (this.childrenCount > 0) {
            if (this.childrenCount == 1) {
                return this.oneChild;
            }
            if (n < this.childrenCount) {
                return this.children.get(n);
            }
            throw new IllegalArgumentException("no child at position " + n);
        }
        throw new IllegalArgumentException("this node has no children");
    }

    public void setParentNode(XmlNode xmlNode) {
        this.parent = xmlNode;
        this.prefix2Ns.putAll(xmlNode.getPrefix2Ns());
    }

    public void appendChild(Object object) throws XmlPullParserException {
        if (this.childrenCount == 0) {
            this.oneChild = object;
        } else {
            if (this.children == null) {
                this.children = new ArrayList(4);
            }
            if (this.childrenCount == 1) {
                if (this.children.size() > 0) {
                    this.children.clear();
                }
                this.children.add(this.oneChild);
            }
            this.children.add(object);
        }
        if (object instanceof XmlNode) {
            ((XmlNode)object).setParentNode(this);
        }
        ++this.childrenCount;
    }

    public void insertChildAt(int n, Object object) throws XmlPullParserException {
        if (this.childrenCount == 0) {
            if (n != 0) {
                throw new XmlPullParserException("to insert first child position must be 0 not " + n);
            }
            this.oneChild = object;
        } else {
            if (this.children == null) {
                this.children = new ArrayList(4);
            }
            if (this.childrenCount == 1) {
                if (this.children.size() > 0) {
                    this.children.clear();
                }
                this.children.add(this.oneChild);
            }
            this.children.add(n, object);
        }
        if (object instanceof XmlNode) {
            ((XmlNode)object).setParentNode(this);
        }
        ++this.childrenCount;
    }

    public void removeChildAt(int n) throws XmlPullParserException {
        Object object = null;
        if (this.childrenCount == 0) {
            throw new XmlPullParserException("node has no children to remove");
        }
        if (this.childrenCount == 1) {
            if (n != 0) {
                throw new XmlPullParserException("to remove last child position must be 0 not " + n);
            }
            object = this.oneChild;
            this.oneChild = null;
        } else if (this.childrenCount == 2) {
            if (n == 0) {
                this.oneChild = this.children.get(1);
                object = this.children.get(0);
            } else if (n == 1) {
                this.oneChild = this.children.get(0);
                object = this.children.get(1);
            } else {
                throw new XmlPullParserException("only two children position must 0 or 1 but not " + n);
            }
            this.children.clear();
        } else {
            object = this.children.get(n);
            this.children.remove(n);
        }
        if (object instanceof XmlNode) {
            ((XmlNode)object).setParentNode(null);
        }
        --this.childrenCount;
    }

    public void replaceChildAt(int n, Object object) throws XmlPullParserException {
        if (this.childrenCount == 1) {
            if (n != 0) {
                throw new XmlPullParserException("to set first child position must be 0 not " + n);
            }
            this.oneChild = object;
        } else if (this.childrenCount > 1) {
            this.children.add(n, object);
        } else {
            throw new XmlPullParserException("node must have at least one children to set child at " + n);
        }
        if (object instanceof XmlNode) {
            ((XmlNode)object).setParentNode(this);
        }
    }

    public void ensureChildrenCapacity(int n) throws XmlPullParserException {
        if (n <= 1) {
            return;
        }
        if (this.children == null) {
            this.children = new ArrayList(n);
        } else {
            this.children.ensureCapacity(n);
        }
    }

    public void removeChildren() throws XmlPullParserException {
        if (this.childrenCount == 1 && this.oneChild instanceof XmlNode) {
            ((XmlNode)this.oneChild).setParentNode(null);
        }
        this.oneChild = null;
        if (this.children != null && this.children.size() > 0) {
            Iterator iterator = ((AbstractList)this.children).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof XmlNode)) continue;
                ((XmlNode)e).setParentNode(null);
            }
            this.children.clear();
        }
        this.childrenCount = 0;
    }

    public String getQNameLocal(String string) {
        int n = string.lastIndexOf(58);
        return string.substring(n + 1);
    }

    public String getQNameUri(String string) {
        int n = string.lastIndexOf(58);
        if (n > 0) {
            String string2 = string.substring(0, n);
            try {
                return this.prefix2Namespace(string2);
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new PullParserRuntimeException(xmlPullParserException);
            }
        }
        return this.defaultNamespaceUri;
    }

    public String prefix2Namespace(String string) throws XmlPullParserException {
        if (string == null) {
            return null;
        }
        if ("".equals(string)) {
            return this.defaultNamespaceUri;
        }
        String string2 = null;
        if (this.declaredNsEnd > 0) {
            string2 = (String)this.prefix2Ns.get(string);
        }
        if (this.parent != null && string2 == null) {
            return this.parent.prefix2Namespace(string);
        }
        return string2;
    }

    public String namespace2Prefix(String string) throws XmlPullParserException {
        if (string == null) {
            throw new XmlPullParserException("null is not allowed for namespace name");
        }
        if (string.equals(this.getDefaultNamespaceUri())) {
            return "";
        }
        int n = 0;
        while (n < this.declaredNsEnd) {
            if (string.equals(this.declaredNs[n])) {
                return this.declaredPrefixes[n];
            }
            ++n;
        }
        if (this.parent != null) {
            return this.parent.namespace2Prefix(string);
        }
        return null;
    }

    public String getDefaultNamespaceUri() {
        return this.defaultNamespaceUri;
    }

    public void setDefaultNamespaceUri(String string) {
        this.defaultNamespaceUri = string;
    }

    public int getDeclaredNamespaceLength() {
        return this.declaredNsEnd;
    }

    public void readDeclaredNamespaceUris(String[] stringArray, int n, int n2) {
        if (n2 > this.declaredNsEnd) {
            throw new IllegalArgumentException("this node has only " + this.declaredNsEnd + " namespace URIs and not " + n2);
        }
        System.arraycopy(this.declaredNs, 0, stringArray, n, n2);
    }

    public void readDeclaredPrefixes(String[] stringArray, int n, int n2) {
        if (n2 > this.declaredNsEnd) {
            throw new IllegalArgumentException("this node has only " + this.declaredNsEnd + " prefixes and nor " + n2);
        }
        System.arraycopy(this.declaredPrefixes, 0, stringArray, n, n2);
    }

    public void ensureDeclaredNamespacesCapacity(int n) {
        if (this.declaredNs == null || this.declaredNs.length < n) {
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            if (this.declaredNsEnd > 0) {
                System.arraycopy(this.declaredNs, 0, stringArray, 0, this.declaredNsEnd);
                System.arraycopy(this.declaredPrefixes, 0, stringArray2, 0, this.declaredNsEnd);
            }
            this.declaredNs = stringArray;
            this.declaredPrefixes = stringArray2;
        }
    }

    public void addNamespaceDeclaration(String string, String string2) throws XmlPullParserException {
        this.ensureDeclaredNamespacesCapacity(this.declaredNsEnd + 1);
        this.declaredNs[this.declaredNsEnd] = string2;
        this.declaredPrefixes[this.declaredNsEnd] = string;
        ++this.declaredNsEnd;
        if (this.prefix2Ns != null) {
            this.prefix2Ns.put(string, string2);
        }
    }

    public void addDeclaredNamespaces(String[] stringArray, int n, int n2, String[] stringArray2) {
        if (n2 == 0) {
            return;
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("number of added namespaces can not be negative");
        }
        this.ensureDeclaredNamespacesCapacity(this.declaredNsEnd + n2);
        System.arraycopy(stringArray2, n, this.declaredNs, this.declaredNsEnd, n2);
        System.arraycopy(stringArray, n, this.declaredPrefixes, this.declaredNsEnd, n2);
        this.declaredNsEnd += n2;
        if (this.prefix2Ns != null) {
            int n3 = n;
            while (n3 < n + n2) {
                this.prefix2Ns.put(stringArray[n3], stringArray2[n3]);
                ++n3;
            }
        }
    }

    public void removeDeclaredNamespaces() {
        this.prefix2Ns.clear();
        this.declaredNsEnd = 0;
        this.defaultNamespaceUri = null;
    }

    protected void printFields(StringBuffer stringBuffer) {
        super.printFields(stringBuffer);
        stringBuffer.append(" children=[ ");
        if (this.childrenCount == 0) {
            stringBuffer.append("");
        } else if (this.childrenCount == 1) {
            stringBuffer.append("'");
            stringBuffer.append(this.oneChild);
            stringBuffer.append("'");
        } else if (this.children != null) {
            int n = 0;
            while (n < this.children.size()) {
                stringBuffer.append('\'');
                stringBuffer.append(this.children.get(n));
                stringBuffer.append("', ");
                ++n;
            }
        }
        stringBuffer.append(" ]");
        XmlNode xmlNode = this.getParentNode();
        String string = this.getDefaultNamespaceUri();
        if (!(string == null || xmlNode != null && string.equals(xmlNode.getDefaultNamespaceUri()))) {
            stringBuffer.append(" xmlns='");
            stringBuffer.append(string);
            stringBuffer.append('\'');
        }
        if (this.declaredNsEnd > 0) {
            stringBuffer.append(" namespaces = [");
            int n = 0;
            while (n < this.declaredNsEnd) {
                stringBuffer.append(" xmlns:");
                stringBuffer.append(this.declaredPrefixes[n]);
                stringBuffer.append("='");
                stringBuffer.append(this.declaredNs[n]);
                stringBuffer.append("'");
                ++n;
            }
            stringBuffer.append(" ]");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Node={");
        this.printFields(stringBuffer);
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    static final class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new PullParserRuntimeException("trying to access elements beyond end of enumeration");
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static final class OneChildIterator
    implements Iterator {
        Object oneChild;

        OneChildIterator(Object object) {
            this.oneChild = object;
        }

        public boolean hasNext() {
            return this.oneChild != null;
        }

        public Object next() {
            if (this.oneChild != null) {
                Object object = this.oneChild;
                this.oneChild = null;
                return object;
            }
            throw new PullParserRuntimeException("trying to access elements beyond end of iterator");
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

