/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.pullnode;

import java.io.IOException;
import java.util.Iterator;
import org.gjt.xpp.XmlPullNode;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.impl.tag.PullParserRuntimeException;

class PullNodeIterator
implements Iterator {
    XmlPullNode node;
    int pos;

    PullNodeIterator(XmlPullNode xmlPullNode) {
        this.node = xmlPullNode;
        this.pos = 0;
    }

    public boolean hasNext() {
        if (this.node.isFinished()) {
            return this.pos < this.node.getChildrenCount();
        }
        int n = this.node.getChildrenCountSoFar();
        if (this.pos < n) {
            return true;
        }
        try {
            Object object;
            while ((object = this.node.readNextChild()) != null) {
                if (this.pos != ++n - 1) continue;
                return true;
            }
            return false;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new PullParserRuntimeException("next value could not be read ", xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new PullParserRuntimeException("next value could not be read ", iOException);
        }
    }

    public Object next() {
        return this.node.getChildAt(this.pos++);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

