/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.pullparser;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.gjt.xpp.XmlEndTag;
import org.gjt.xpp.XmlNode;
import org.gjt.xpp.XmlPullParser;
import org.gjt.xpp.XmlPullParserBufferControl;
import org.gjt.xpp.XmlPullParserEventPosition;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.XmlStartTag;
import org.gjt.xpp.impl.pullparser.ElementContent;
import org.gjt.xpp.impl.tag.Attribute;
import org.gjt.xpp.impl.tag.PullParserRuntimeException;
import org.gjt.xpp.impl.tokenizer.Tokenizer;

public final class PullParser
implements XmlPullParser,
XmlPullParserBufferControl,
XmlPullParserEventPosition {
    private static final boolean TRACE_SIZING = false;
    protected static final boolean USE_QNAMEBUF = false;
    protected static final boolean CHECK_ATTRIB_UNIQ = true;
    protected boolean emptyElement;
    protected boolean emptyElementEnd;
    protected boolean seenRootElement;
    protected String elContent;
    protected Tokenizer tokenizer = new Tokenizer();
    protected int eventStart;
    protected int eventEnd;
    protected byte state;
    protected byte token;
    protected boolean supportNs;
    protected boolean reportNsAttribs;
    protected Map prefix2Ns = new HashMap();
    protected int attrPosEnd;
    protected int attrPosSize;
    protected Attribute[] attrPos;
    protected int elStackDepth;
    protected int elStackSize;
    protected ElementContent[] elStack;

    public void setInput(Reader reader) {
        this.resetState();
        this.eventStart = 0;
        this.eventEnd = 0;
        this.tokenizer.setInput(reader);
    }

    public void setInput(char[] cArray) {
        this.resetState();
        this.eventStart = 0;
        this.eventEnd = 0;
        this.tokenizer.setInput(cArray, 0, cArray.length);
    }

    public void setInput(char[] cArray, int n, int n2) throws XmlPullParserException {
        this.resetState();
        this.eventEnd = this.eventStart = n;
        this.tokenizer.setInput(cArray, n, n2);
    }

    public void reset() {
        this.tokenizer.reset();
        this.resetState();
    }

    public boolean isAllowedMixedContent() {
        return this.tokenizer.isAllowedMixedContent();
    }

    public void setAllowedMixedContent(boolean bl) {
        this.tokenizer.setAllowedMixedContent(bl);
    }

    public boolean isNamespaceAware() {
        return this.supportNs;
    }

    public void setNamespaceAware(boolean bl) throws XmlPullParserException {
        if (this.elStackDepth > 0 || this.seenRootElement) {
            throw new XmlPullParserException("namespace support can only be set when not parsing");
        }
        this.supportNs = bl;
    }

    public boolean isNamespaceAttributesReporting() {
        return this.reportNsAttribs;
    }

    public void setNamespaceAttributesReporting(boolean bl) {
        this.reportNsAttribs = bl;
    }

    public String getNamespaceUri() {
        if (this.state != 2 && this.state != 3) {
            throw new PullParserRuntimeException("no end or start tag available to read" + this.getPosDesc());
        }
        ElementContent elementContent = this.elStack[this.getDepth() - 1];
        return elementContent.uri;
    }

    public String getLocalName() {
        if (this.state != 2 && this.state != 3) {
            throw new PullParserRuntimeException("no end or start tag available to read" + this.getPosDesc());
        }
        ElementContent elementContent = this.elStack[this.getDepth() - 1];
        return elementContent.localName;
    }

    public String getPrefix() {
        if (this.state != 2 && this.state != 3) {
            throw new PullParserRuntimeException("no end or start tag available to read" + this.getPosDesc());
        }
        ElementContent elementContent = this.elStack[this.getDepth() - 1];
        return elementContent.prefix;
    }

    public String getRawName() {
        if (this.state != 2 && this.state != 3) {
            throw new PullParserRuntimeException("no end or start tag available to read" + this.getPosDesc());
        }
        ElementContent elementContent = this.elStack[this.getDepth() - 1];
        return elementContent.qName;
    }

    public String getQNameLocal(String string) {
        int n = string.lastIndexOf(58);
        return string.substring(n + 1);
    }

    public String getDefaultNs() throws XmlPullParserException {
        if (this.elStackDepth == 0) {
            throw new XmlPullParserException("parsing must be started to get uri from qname");
        }
        return this.elStack[this.elStackDepth - 1].defaultNs;
    }

    public Map getPrefix2Ns() {
        return this.prefix2Ns;
    }

    public String getQNameUri(String string) throws XmlPullParserException {
        if (this.elStackDepth == 0) {
            throw new XmlPullParserException("parsing must be started to get uri from qname");
        }
        int n = string.lastIndexOf(58);
        if (n > 0) {
            String string2 = string.substring(0, n);
            return (String)this.prefix2Ns.get(string2);
        }
        return this.elStack[this.elStackDepth - 1].defaultNs;
    }

    public int getDepth() {
        return this.state != 3 ? this.elStackDepth : this.elStackDepth + 1;
    }

    public int getNamespacesLength(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("element depth must be bigger than zero");
        }
        int n2 = this.getDepth();
        if (n > n2) {
            throw new IllegalArgumentException("the depth " + n + " that was passed for length of namespaces " + " can not be bigger than current depth of " + n2);
        }
        ElementContent elementContent = this.elStack[n - 1];
        return elementContent.prefixesEnd;
    }

    public void readNamespacesPrefixes(int n, String[] stringArray, int n2, int n3) throws XmlPullParserException {
        if (n <= 0) {
            throw new XmlPullParserException("element depth must be bigger than zero");
        }
        int n4 = this.getDepth();
        if (n > n4) {
            throw new XmlPullParserException("passed prefixes array of length " + n + " can not be bigger than current depth of " + n4);
        }
        ElementContent elementContent = this.elStack[n - 1];
        if (n3 > elementContent.prefixesEnd) {
            throw new XmlPullParserException("number of prefixes to copy " + n3 + " is bigger than available " + elementContent.prefixesEnd);
        }
        System.arraycopy(elementContent.prefixes, 0, stringArray, n2, n3);
    }

    public void readNamespacesUris(int n, String[] stringArray, int n2, int n3) throws XmlPullParserException {
        if (n <= 0) {
            throw new XmlPullParserException("element depth must be bigger than zero");
        }
        int n4 = this.getDepth();
        if (n > n4) {
            throw new XmlPullParserException("passed namespace URIs array of length " + n + " can not be bigger than current depth of " + n4);
        }
        ElementContent elementContent = this.elStack[n - 1];
        if (n3 > elementContent.prefixesEnd) {
            throw new XmlPullParserException("number of namespace URIs to copy " + n3 + " is bigger than available " + elementContent.prefixesEnd);
        }
        System.arraycopy(elementContent.namespaceURIs, 0, stringArray, n2, n3);
    }

    public String getPosDesc() {
        String string;
        switch (this.state) {
            case 2: {
                string = "START_TAG";
                break;
            }
            case 4: {
                string = "CONTENT";
                break;
            }
            case 3: {
                string = "END_TAG";
                break;
            }
            case 1: {
                string = "END_DOCUMENT";
                break;
            }
            default: {
                string = "UNKNONW_EVENT (" + this.state + ")";
            }
        }
        return this.tokenizer.getPosDesc() + " (parser state " + string + ")";
    }

    public int getLineNumber() {
        return this.tokenizer.getLineNumber();
    }

    public int getColumnNumber() {
        return this.tokenizer.getColumnNumber();
    }

    public byte next() throws XmlPullParserException, IOException {
        this.eventEnd = this.eventStart = this.tokenizer.pos;
        if (this.emptyElement) {
            this.emptyElement = false;
            this.emptyElementEnd = true;
            this.elContent = "";
            this.state = 4;
            return 4;
        }
        if (this.emptyElementEnd) {
            --this.elStackDepth;
            if (this.elStackDepth == 0) {
                this.seenRootElement = true;
            }
            this.emptyElementEnd = false;
            this.state = 3;
            return 3;
        }
        Attribute attribute = null;
        ElementContent elementContent = null;
        block11: do {
            this.token = this.tokenizer.next();
            switch (this.token) {
                case 2: {
                    this.state = 1;
                    if (this.elStackDepth > 0) {
                        throw new XmlPullParserException("expected element end tag '" + this.elStack[this.elStackDepth - 1].qName + "' not end of document" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    this.eventEnd = this.tokenizer.pos;
                    return this.state;
                }
                case 10: {
                    this.state = (byte)4;
                    if (this.elStackDepth > 0) {
                        this.elContent = null;
                        this.eventEnd = this.tokenizer.posEnd;
                        return this.state;
                    }
                    if (this.tokenizer.seenContent) {
                        throw new XmlPullParserException("only whitespace content allowed outside root element" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    this.eventEnd = this.eventStart = this.tokenizer.pos;
                    break;
                }
                case 110: {
                    int n;
                    this.eventStart = this.tokenizer.posStart - 2;
                    this.state = (byte)3;
                    if (this.seenRootElement) {
                        throw new XmlPullParserException("no markup allowed outside root element" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    --this.elStackDepth;
                    if (this.elStackDepth == 0) {
                        this.seenRootElement = true;
                    }
                    if (this.elStackDepth < 0) {
                        throw new XmlPullParserException("end tag without start stag" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    elementContent = this.elStack[this.elStackDepth];
                    String string = new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                    if (!string.equals(this.elStack[this.elStackDepth].qName)) {
                        throw new XmlPullParserException("end tag name should be " + this.elStack[this.elStackDepth].qName + " not " + string + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    if (this.supportNs && elementContent.prefixes != null) {
                        n = elementContent.prefixesEnd - 1;
                        while (n >= 0) {
                            if (elementContent.prefixPrevNs[n] != null) {
                                this.prefix2Ns.put(elementContent.prefixes[n], elementContent.prefixPrevNs[n]);
                            } else {
                                this.prefix2Ns.remove(elementContent.prefixes[n]);
                            }
                            --n;
                        }
                    }
                    this.eventEnd = this.tokenizer.pos;
                    return this.state;
                }
                case 120: {
                    this.eventStart = this.tokenizer.posStart - 1;
                    this.state = (byte)2;
                    if (this.seenRootElement) {
                        throw new XmlPullParserException("no markup allowed outside root element" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    this.emptyElement = false;
                    if (this.elStackDepth >= this.elStackSize) {
                        this.ensureCapacity(this.elStackDepth);
                    }
                    elementContent = this.elStack[this.elStackDepth];
                    elementContent.prefixesEnd = 0;
                    this.attrPosEnd = 0;
                    elementContent.defaultNs = null;
                    elementContent.qName = new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                    if (this.supportNs && this.tokenizer.posNsColon >= 0) {
                        if (this.tokenizer.nsColonCount > 1) {
                            throw new XmlPullParserException("only one colon allowed in prefixed element name" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        elementContent.prefix = elementContent.qName.substring(0, this.tokenizer.posNsColon - this.tokenizer.posStart);
                        elementContent.localName = elementContent.qName.substring(this.tokenizer.posNsColon - this.tokenizer.posStart + 1);
                    } else {
                        elementContent.prefix = null;
                        elementContent.localName = elementContent.qName;
                    }
                    elementContent.uri = null;
                    ++this.elStackDepth;
                    break;
                }
                case 122: {
                    if (this.attrPosEnd >= this.attrPosSize) {
                        this.ensureAttribs(this.attrPosEnd + 1);
                    }
                    attribute = this.attrPos[this.attrPosEnd];
                    attribute.qName = new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                    attribute.uri = null;
                    if (this.supportNs && this.tokenizer.posNsColon >= 0) {
                        if (this.tokenizer.nsColonCount > 1) {
                            throw new XmlPullParserException("only one colon allowed in prefixed attribute name" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        attribute.prefix = attribute.qName.substring(0, this.tokenizer.posNsColon - this.tokenizer.posStart);
                        if (this.tokenizer.posEnd == this.tokenizer.posNsColon) {
                            throw new XmlPullParserException("xmlns: is not allowed to declare default namespace, use xmlns instead" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        attribute.localName = attribute.qName.substring(this.tokenizer.posNsColon - this.tokenizer.posStart + 1);
                        break;
                    }
                    attribute.prefix = null;
                    attribute.localName = attribute.qName;
                    break;
                }
                case 127: {
                    int n;
                    attribute.value = this.tokenizer.parsedContent ? new String(this.tokenizer.pc, this.tokenizer.pcStart, this.tokenizer.pcEnd - this.tokenizer.pcStart) : new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                    if (this.supportNs) {
                        if ("xmlns".equals(attribute.prefix)) {
                            if (elementContent.prefixesEnd >= elementContent.prefixesSize) {
                                elementContent.ensureCapacity(elementContent.prefixesEnd);
                            }
                            if (attribute.value.length() == 0) {
                                throw new XmlPullParserException("the declared xmlns namespace for '" + attribute.localName + "' name " + " may not be empty" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                            }
                            elementContent.prefixes[elementContent.prefixesEnd] = attribute.localName;
                            elementContent.namespaceURIs[elementContent.prefixesEnd] = attribute.value;
                            elementContent.prefixPrevNs[elementContent.prefixesEnd] = (String)this.prefix2Ns.get(attribute.localName);
                            n = 0;
                            while (n < elementContent.prefixesEnd) {
                                if (attribute.localName.equals(elementContent.prefixes[n])) {
                                    throw new XmlPullParserException("duplicate xmlns declaration name '" + attribute.localName + "'" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                                }
                                ++n;
                            }
                            ++elementContent.prefixesEnd;
                            this.prefix2Ns.put(attribute.localName, attribute.value);
                            if (!this.reportNsAttribs) continue block11;
                            attribute.xmlnsAttrib = true;
                            ++this.attrPosEnd;
                            break;
                        }
                        if ("xmlns".equals(attribute.qName)) {
                            if (elementContent.defaultNs != null) {
                                throw new XmlPullParserException("default namespace was alredy declared by xmlns attribute" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                            }
                            elementContent.defaultNs = attribute.value;
                            if (!this.reportNsAttribs) continue block11;
                            attribute.xmlnsAttrib = true;
                            ++this.attrPosEnd;
                            break;
                        }
                        attribute.xmlnsAttrib = false;
                        ++this.attrPosEnd;
                        break;
                    }
                    n = 0;
                    while (n < this.attrPosEnd) {
                        if (attribute.qName.equals(this.attrPos[n].qName)) {
                            throw new XmlPullParserException("duplicate attribute name '" + attribute.qName + "'" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        ++n;
                    }
                    attribute.xmlnsAttrib = false;
                    ++this.attrPosEnd;
                    break;
                }
                case 111: {
                    this.emptyElement = true;
                    break;
                }
                case 112: {
                    int n;
                    if (this.supportNs) {
                        if (elementContent.defaultNs == null) {
                            elementContent.defaultNs = this.elStackDepth > 1 ? this.elStack[this.elStackDepth - 2].defaultNs : "";
                        }
                        if (elementContent.prefix != null) {
                            elementContent.uri = (String)this.prefix2Ns.get(elementContent.prefix);
                            if (elementContent.uri == null) {
                                throw new XmlPullParserException("no namespace for prefix '" + elementContent.prefix + "'" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                            }
                        } else {
                            elementContent.uri = elementContent.defaultNs;
                            elementContent.localName = elementContent.qName;
                        }
                        n = 0;
                        while (n < this.attrPosEnd) {
                            attribute = this.attrPos[n];
                            if (!attribute.xmlnsAttrib && attribute.uri == null && attribute.prefix != null) {
                                attribute.uri = (String)this.prefix2Ns.get(attribute.prefix);
                                if (attribute.uri == null) {
                                    throw new XmlPullParserException("no namespace for prefix " + attribute.prefix + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                                }
                            }
                            ++n;
                        }
                        int n2 = 1;
                        while (n2 < this.attrPosEnd) {
                            attribute = this.attrPos[n2];
                            int n3 = 0;
                            while (n3 < n2) {
                                if (!attribute.xmlnsAttrib && !this.attrPos[n3].xmlnsAttrib && attribute.localName.equals(this.attrPos[n3].localName) && (attribute.uri != null && attribute.uri.equals(this.attrPos[n3].uri) || attribute.uri == null && this.attrPos[n3].uri == null)) {
                                    throw new XmlPullParserException("duplicate attribute name '" + attribute.qName + "'" + (attribute.uri != null ? " (with namespace '" + attribute.uri + "')" : "") + " and " + (attribute.uri != null ? " (with namespace '" + attribute.uri + "')" : "") + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                                }
                                ++n3;
                            }
                            ++n2;
                        }
                    } else {
                        elementContent.prefix = null;
                        elementContent.localName = elementContent.qName;
                        elementContent.uri = "";
                    }
                    this.eventEnd = this.tokenizer.pos;
                    return this.state;
                }
                case 50: {
                    throw new XmlPullParserException("<![DOCTYPE declarations not supported" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                }
                default: {
                    throw new XmlPullParserException("unknown token " + this.token + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                }
            }
        } while (this.token != 112);
        throw new XmlPullParserException("invalid state of tokenizer token=" + this.token);
    }

    public byte getEventType() {
        return this.state;
    }

    public boolean isWhitespaceContent() throws XmlPullParserException {
        if (this.state != 4) {
            throw new XmlPullParserException("no content available to read");
        }
        return !this.tokenizer.seenContent;
    }

    public int getContentLength() throws XmlPullParserException {
        if (this.state != 4) {
            throw new XmlPullParserException("no content available");
        }
        return this.tokenizer.parsedContent ? this.tokenizer.pcEnd - this.tokenizer.pcStart : this.tokenizer.posEnd - this.tokenizer.posStart;
    }

    public String readContent() throws XmlPullParserException {
        if (this.state != 4) {
            throw new XmlPullParserException("no content available to read");
        }
        if (this.elContent == null) {
            this.elContent = this.tokenizer.parsedContent ? new String(this.tokenizer.pc, this.tokenizer.pcStart, this.tokenizer.pcEnd - this.tokenizer.pcStart) : new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
        }
        return this.elContent;
    }

    public void readEndTag(XmlEndTag xmlEndTag) throws XmlPullParserException {
        if (this.state != 3) {
            throw new XmlPullParserException("no end tag available to read" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
        }
        ElementContent elementContent = this.elStack[this.elStackDepth];
        xmlEndTag.resetEndTag();
        xmlEndTag.modifyTag(elementContent.uri, elementContent.localName, elementContent.qName);
    }

    public void readStartTag(XmlStartTag xmlStartTag) throws XmlPullParserException {
        if (this.state != 2) {
            throw new XmlPullParserException("no start tag available to read" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
        }
        xmlStartTag.resetStartTag();
        ElementContent elementContent = this.elStack[this.elStackDepth - 1];
        xmlStartTag.modifyTag(elementContent.uri, elementContent.localName, elementContent.qName);
        xmlStartTag.ensureAttributesCapacity(this.attrPosEnd);
        int n = 0;
        while (n < this.attrPosEnd) {
            Attribute attribute = this.attrPos[n];
            xmlStartTag.addAttribute(attribute.uri, attribute.localName, attribute.qName, attribute.value, attribute.xmlnsAttrib);
            ++n;
        }
    }

    public void readNodeWithoutChildren(XmlNode xmlNode) throws XmlPullParserException {
        this.readStartTag(xmlNode);
        if (this.supportNs) {
            ElementContent elementContent = this.elStack[this.elStackDepth - 1];
            xmlNode.setDefaultNamespaceUri(elementContent.defaultNs);
            xmlNode.addDeclaredNamespaces(elementContent.prefixes, 0, elementContent.prefixesEnd, elementContent.namespaceURIs);
        }
    }

    public byte readNode(XmlNode xmlNode) throws XmlPullParserException, IOException {
        this.readNodeWithoutChildren(xmlNode);
        ElementContent elementContent = this.elStack[this.elStackDepth - 1];
        int n = this.elStackDepth;
        while (true) {
            byte by = this.next();
            switch (by) {
                case 2: {
                    XmlNode xmlNode2 = xmlNode.newNode();
                    this.readNodeWithoutChildren(xmlNode2);
                    xmlNode.appendChild(xmlNode2);
                    elementContent = this.elStack[this.elStackDepth - 1];
                    elementContent.node = xmlNode;
                    xmlNode = xmlNode2;
                    break;
                }
                case 4: {
                    xmlNode.appendChild(this.readContent());
                    break;
                }
                case 3: {
                    if (this.elStackDepth >= n) {
                        xmlNode = this.elStack[this.elStackDepth].node;
                        break;
                    }
                    return by;
                }
            }
        }
    }

    public byte skipNode() throws XmlPullParserException, IOException {
        if (this.state != 2) {
            throw new XmlPullParserException("start tag must be read before skiping subtree" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
        }
        int n = 1;
        byte by = 3;
        while (n > 0) {
            by = this.next();
            switch (by) {
                case 2: {
                    ++n;
                    break;
                }
                case 3: {
                    --n;
                }
            }
        }
        return by;
    }

    public int getHardLimit() {
        return this.tokenizer.getHardLimit();
    }

    public void setHardLimit(int n) throws XmlPullParserException {
        this.tokenizer.setHardLimit(n);
    }

    public int getSoftLimit() {
        return this.tokenizer.getSoftLimit();
    }

    public void setSoftLimit(int n) throws XmlPullParserException {
        this.tokenizer.setSoftLimit(n);
    }

    public int getBufferShrinkOffset() {
        return this.tokenizer.getBufferShrinkOffset();
    }

    public void setBufferShrinkable(boolean bl) throws XmlPullParserException {
        this.tokenizer.setBufferShrinkable(bl);
    }

    public boolean isBufferShrinkable() {
        return this.tokenizer.isBufferShrinkable();
    }

    public int getEventStart() {
        return this.eventStart;
    }

    public int getEventEnd() {
        return this.eventEnd;
    }

    public char[] getEventBuffer() {
        return this.tokenizer.buf;
    }

    protected void ensureCapacity(int n) {
        int n2 = 2 * n;
        if (n2 == 0) {
            n2 = 8;
        }
        if (this.elStackSize < n2) {
            ElementContent[] elementContentArray = new ElementContent[n2];
            if (this.elStack != null) {
                System.arraycopy(this.elStack, 0, elementContentArray, 0, this.elStackSize);
            }
            int n3 = this.elStackSize;
            while (n3 < n2) {
                elementContentArray[n3] = new ElementContent();
                ++n3;
            }
            this.elStack = elementContentArray;
            this.elStackSize = n2;
        }
    }

    protected void ensureAttribs(int n) {
        int n2 = 2 * n;
        if (n2 == 0) {
            n2 = 8;
        }
        if (this.attrPosEnd < n2) {
            Attribute[] attributeArray = new Attribute[n2];
            if (this.attrPos != null) {
                System.arraycopy(this.attrPos, 0, attributeArray, 0, this.attrPosSize);
            }
            int n3 = this.attrPosSize;
            while (n3 < n2) {
                attributeArray[n3] = new Attribute();
                ++n3;
            }
            this.attrPos = attributeArray;
            this.attrPosSize = n2;
        }
    }

    protected void resetState() {
        this.tokenizer.paramNotifyDoctype = true;
        this.state = (byte)-1;
        this.token = (byte)-1;
        this.eventStart = -1;
        this.elStackDepth = 0;
        this.prefix2Ns.clear();
        this.prefix2Ns.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.emptyElement = false;
        this.seenRootElement = false;
    }
}

