/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.tokenizer;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import org.gjt.xpp.impl.tag.PullParserRuntimeException;
import org.gjt.xpp.impl.tokenizer.TokenizerBufferOverflowException;
import org.gjt.xpp.impl.tokenizer.TokenizerException;

public final class Tokenizer {
    public static final byte END_DOCUMENT = 2;
    public static final byte CONTENT = 10;
    public static final byte CHARACTERS = 20;
    public static final byte CDSECT = 30;
    public static final byte COMMENT = 40;
    public static final byte DOCTYPE = 50;
    public static final byte PI = 60;
    public static final byte ENTITY_REF = 70;
    public static final byte CHAR_REF = 75;
    public static final byte ETAG_NAME = 110;
    public static final byte EMPTY_ELEMENT = 111;
    public static final byte STAG_END = 112;
    public static final byte STAG_NAME = 120;
    public static final byte ATTR_NAME = 122;
    public static final byte ATTR_CHARACTERS = 124;
    public static final byte ATTR_CONTENT = 127;
    public boolean paramNotifyCharacters;
    public boolean paramNotifyComment;
    public boolean paramNotifyCDSect;
    public boolean paramNotifyDoctype;
    public boolean paramNotifyPI;
    public boolean paramNotifyCharRef;
    public boolean paramNotifyEntityRef;
    public boolean paramNotifyAttValue;
    public char[] buf = new char[1024];
    public int pos;
    public int posStart;
    public int posEnd;
    public int posNsColon;
    public int nsColonCount;
    public boolean seenContent;
    public boolean parsedContent;
    public char[] pc = new char[1024];
    public int pcStart;
    public int pcEnd;
    private static final boolean NORMALIZE_LINE_BREAKS = true;
    private static final boolean TRACING = false;
    private static final boolean TRACE_SIZING = false;
    private boolean paramPC = true;
    private boolean paramNoMixContent = false;
    private boolean mixInElement = false;
    private boolean backtracking = false;
    private static final int BUF_SIZE = 1024;
    private int readChunkSize = 1024;
    private int loadFactor = 99;
    private int posSafe = this.loadFactor * 1024 / 100;
    private int softLimit = -1;
    private int hardLimit = -1;
    private int shrinkOffset = 0;
    private boolean shrinkable = true;
    private boolean reading = true;
    private Reader reader;
    private int bufStart;
    private int bufEnd;
    private int bufSize = 1024;
    private int posCol;
    private int posRow;
    private char prevCh;
    private char prevPrevCh;
    private char attrMarker;
    private char charRefValue;
    private boolean charRefHex;
    private boolean reachedEnd;
    private boolean seenStartTag;
    private byte previousState;
    private byte state;
    private static final byte STATE_INIT = 1;
    private static final byte STATE_FINISH = 6;
    private static final byte STATE_FINISHED = 7;
    private static final byte STATE_CONTENT_INIT = 10;
    private static final byte STATE_CONTENT_CONTINUED = 11;
    private static final byte STATE_CONTENT = 12;
    private static final byte STATE_SEEN_LT = 13;
    private static final byte STATE_SEEN_LT_BANG = 14;
    private static final byte STATE_CDSECT = 30;
    private static final byte STATE_CDSECT_BRACKET = 31;
    private static final byte STATE_CDSECT_BRACKET_BRACKET = 32;
    private static final byte STATE_COMMENT = 40;
    private static final byte STATE_COMMENT_DASH = 41;
    private static final byte STATE_COMMENT_DASH_DASH = 42;
    private static final byte STATE_DOCTYPE = 50;
    private static final byte STATE_DOCTYPE_BRACKET = 51;
    private static final byte STATE_DOCTYPE_BRACKET_BRACKET = 52;
    private static final byte STATE_PI = 60;
    private static final byte STATE_PI_END = 61;
    private static final byte STATE_SEEN_AMP = 70;
    private static final byte STATE_ENTITY_REF = 71;
    private static final byte STATE_CHAR_REF = 75;
    private static final byte STATE_CHAR_REF_DIGITS = 76;
    private static final byte STATE_SCAN_ETAG_NAME = 110;
    private static final byte STATE_SCAN_STAG_NAME = 120;
    private static final byte STATE_SCAN_STAG_GT = 121;
    private static final byte STATE_SCAN_ATTR_NAME = 122;
    private static final byte STATE_SCAN_ATTR_EQ = 123;
    private static final byte STATE_SCAN_ATTR_VALUE = 124;
    private static final byte STATE_SCAN_ATTR_VALUE_CONTINUE = 125;
    private static final byte STATE_SCAN_ATTR_VALUE_END = 126;
    private static final byte STATE_ATTR_VALUE_CONTENT = 127;

    public void reset() {
        if (!this.reading) {
            if (this.softLimit != -1) {
                this.resize(this.softLimit);
            } else {
                this.resize(1024);
            }
        }
        this.resetState();
    }

    private void resetState() {
        this.reading = true;
        this.bufSize = this.buf.length;
        this.bufEnd = 0;
        this.bufStart = 0;
        this.pos = 0;
        this.posStart = 0;
        this.posEnd = 0;
        this.posNsColon = -1;
        this.state = 1;
        this.prevCh = '\u0000';
        this.posRow = 1;
        this.posCol = 1;
        this.reachedEnd = false;
        this.pcStart = 0;
        this.pcEnd = 0;
        if (this.pc.length > 2048) {
            this.pc = new char[1024];
        }
        this.previousState = (byte)-1;
        this.backtracking = false;
        this.seenContent = false;
        this.shrinkOffset = 0;
    }

    public void setInput(Reader reader) {
        this.reset();
        this.reading = true;
        this.reader = reader;
        this.bufEnd = 0;
        this.bufStart = 0;
    }

    public void setInput(char[] cArray) {
        this.setInput(cArray, 0, cArray.length);
    }

    public void setInput(char[] cArray, int n, int n2) {
        this.resetState();
        this.reading = false;
        this.buf = cArray;
        this.bufStart = this.pos = n;
        this.bufSize = this.bufEnd = n + n2;
    }

    public void setNotifyAll(boolean bl) {
        this.paramNotifyCharacters = bl;
        this.paramNotifyComment = bl;
        this.paramNotifyCDSect = bl;
        this.paramNotifyDoctype = bl;
        this.paramNotifyPI = bl;
        this.paramNotifyEntityRef = bl;
        this.paramNotifyCharRef = bl;
        this.paramNotifyAttValue = bl;
    }

    public void setParseContent(boolean bl) {
        this.paramPC = bl;
    }

    public boolean isAllowedMixedContent() {
        return !this.paramNoMixContent;
    }

    public void setAllowedMixedContent(boolean bl) {
        this.paramNoMixContent = !bl;
    }

    public int getSoftLimit() {
        return this.softLimit;
    }

    public void setSoftLimit(int n) throws TokenizerException {
        if (!this.reading) {
            throw new TokenizerException("hard limit can not be set for char array input");
        }
        if (n != -1 && this.hardLimit != -1 && 2 * n > this.hardLimit) {
            throw new TokenizerException("soft limit can no tbe bigger than half of hard limitcurrent hard limit " + this.hardLimit);
        }
        this.softLimit = n;
        this.posSafe = this.softLimit != -1 ? this.softLimit : (this.hardLimit != -1 ? this.hardLimit / 2 : this.loadFactor * this.bufSize / 100);
    }

    public int getHardLimit() {
        return this.hardLimit;
    }

    public void setHardLimit(int n) throws TokenizerException {
        if (!this.reading) {
            throw new TokenizerException("hard limit can not be set for char array input");
        }
        if (this.state != 1 && n < this.hardLimit) {
            throw new TokenizerException("hard limit on buffer size can not be shrunk during parsing");
        }
        if (this.softLimit == -1 && n != -1) {
            throw new TokenizerException("soft limit must be set to non -1 before setting hard limit" + this.getPosDesc(), this.posRow, this.posCol - 1);
        }
        if (n != -1 && 2 * this.softLimit >= n) {
            throw new TokenizerException("hard limit must be at least twice the size of soft limitcurrent soft limit " + this.softLimit + " and hard limit " + n + this.getPosDesc(), this.posRow, this.posCol - 1);
        }
        this.hardLimit = n;
        if (this.shrinkable && this.softLimit != -1 && this.softLimit < this.bufSize) {
            this.resize(this.softLimit);
        }
    }

    public int getBufferShrinkOffset() {
        return this.shrinkOffset;
    }

    public void setBufferShrinkable(boolean bl) throws TokenizerException {
        this.shrinkable = bl;
    }

    public boolean isBufferShrinkable() {
        return this.shrinkable;
    }

    private static int findFragment(int n, char[] cArray, int n2, int n3) {
        if (n2 < n) {
            n2 = n;
            if (n2 > n3) {
                n2 = n3;
            }
            return n2;
        }
        if (n3 - n2 > 55) {
            n2 = n3 - 10;
        }
        int n4 = n2 + 1;
        while (--n4 > n) {
            char c;
            if (n3 - n4 > 55 || (c = cArray[n4]) == '<' && n2 - n4 > 10) break;
        }
        return n4;
    }

    public String getPosDesc() {
        int n;
        String string = null;
        if (this.posStart <= this.posEnd && (n = Tokenizer.findFragment(this.bufStart, this.buf, this.posStart, this.posEnd)) < this.posEnd) {
            string = new String(this.buf, n, this.posEnd - n);
            if (n > this.bufStart) {
                string = "..." + string;
            }
        }
        return " at line " + this.posRow + " and column " + (this.posCol - 1) + (string != null ? " seen " + Tokenizer.printable(string) + "..." : "");
    }

    public int getLineNumber() {
        return this.posRow;
    }

    public int getColumnNumber() {
        return this.posCol - 1;
    }

    private static boolean compareCharArr(char[] cArray, char[] cArray2, int n, int n2) {
        if (n2 - n != cArray.length) {
            return false;
        }
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            if (cArray[n4] != cArray2[n3]) {
                return false;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    private static String printableChar(char c) {
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c < ' ') {
            return "\\u" + Character.digit(c, 16) + "";
        }
        return "" + c;
    }

    private static String printable(char c) {
        return "'" + Tokenizer.printableChar(c) + "'";
    }

    private static String printable(String string) {
        int n = string.indexOf(10);
        int n2 = string.indexOf(13);
        int n3 = string.indexOf(9);
        if (n != -1 || n2 != -1 || n3 != -1) {
            StringBuffer stringBuffer = new StringBuffer("\"");
            int n4 = 0;
            while (n4 < string.length()) {
                stringBuffer.append(Tokenizer.printableChar(string.charAt(n4)));
                ++n4;
            }
            stringBuffer.append("\"");
            string = stringBuffer.toString();
        }
        return string;
    }

    private char readName(char c) throws IOException, TokenizerException {
        this.posNsColon = -1;
        this.nsColonCount = 0;
        if (!Character.isLowerCase(c) && !Character.isUpperCase(c) && c != ':' && c != '_') {
            throw new TokenizerException("expected name start not " + Tokenizer.printable(c) + this.getPosDesc(), this.posRow, this.posCol - 1);
        }
        do {
            if ((c = this.more()) != ':') continue;
            this.posNsColon = this.pos - 1;
            ++this.nsColonCount;
        } while (Character.isLowerCase(c) || Character.isUpperCase(c) || Character.isDigit(c) || c == '.' || c == '-' || c == '_' || c == ':');
        return c;
    }

    private boolean isS(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private char skipS(char c) throws IOException, TokenizerException {
        while (c == ' ' || c == '\n' || c == '\t' || c == '\r') {
            c = this.more();
        }
        return c;
    }

    /*
     * Unable to fully structure code
     */
    private char readS(char var1_1) throws IOException, TokenizerException {
        if (this.isS(var1_1)) ** GOTO lbl4
        throw new TokenizerException("expected white space not " + var1_1 + this.getPosDesc(), this.posRow, this.posCol - 1);
lbl-1000:
        // 1 sources

        {
            var1_1 = this.more();
lbl4:
            // 2 sources

            ** while (var1_1 == ' ' || var1_1 == '\n' || var1_1 == '\t' || var1_1 == '\r')
        }
lbl5:
        // 1 sources

        return var1_1;
    }

    private char more() throws IOException, TokenizerException {
        char c;
        if (this.backtracking) {
            this.backtracking = false;
            ++this.pos;
            ++this.posCol;
            return this.prevCh;
        }
        if (!this.reading) {
            if (this.pos == this.bufEnd - 1) {
                this.reachedEnd = true;
            }
            if (this.pos >= this.bufEnd) {
                throw new EOFException("no more data available");
            }
        } else {
            if (this.hardLimit != -1 && this.pos >= this.hardLimit - 1) {
                throw new TokenizerBufferOverflowException("reached hard limit on buffer size" + this.getPosDesc(), this.posRow, this.posCol - 1);
            }
            if (this.pos >= this.bufEnd - 1) {
                int n;
                if (this.hardLimit != -1 && this.bufSize > this.hardLimit) {
                    throw new TokenizerBufferOverflowException("buffer size should never exceed hard limit" + this.getPosDesc(), this.posRow, this.posCol - 1);
                }
                c = this.bufSize - this.bufEnd;
                if (c <= this.readChunkSize) {
                    n = 2 * this.bufSize;
                    if (this.hardLimit == -1) {
                        if (n < this.softLimit) {
                            n = 2 * this.softLimit;
                        }
                        if (n < 4 * this.readChunkSize) {
                            n = 12 * this.readChunkSize;
                        }
                    } else if (n > this.hardLimit) {
                        if (this.bufEnd >= this.hardLimit) {
                            throw new TokenizerBufferOverflowException("buffer can not grow beyond hard limit" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        n = this.hardLimit;
                    }
                    if (n - this.bufSize > 0) {
                        this.resize(n);
                    }
                }
                if (this.bufSize - this.bufEnd < (n = this.readChunkSize)) {
                    n = this.bufSize - this.bufEnd;
                }
                if (this.reader == null) {
                    throw new TokenizerException("to start parsing setInput() must be called!");
                }
                int n2 = this.reader.read(this.buf, this.bufEnd, n);
                if (n2 == -1) {
                    if (this.reachedEnd) {
                        throw new TokenizerException("can't read more - reached end of stream (state=" + this.state + ")" + this.getPosDesc());
                    }
                    this.reachedEnd = true;
                }
                if (n2 == 0) {
                    throw new TokenizerBufferOverflowException("can't read more data in buffer (read() returns 0 chars)" + this.getPosDesc());
                }
                this.bufEnd += n2;
            }
        }
        if ((c = this.buf[this.pos++]) == '\n' || c == '\r') {
            if (this.prevCh != '\r' || c != '\n') {
                this.posCol = 2;
                ++this.posRow;
            }
        } else {
            ++this.posCol;
        }
        this.prevPrevCh = this.prevCh;
        char c2 = c;
        this.prevCh = c2;
        return c2;
    }

    private void resize(int n) {
        char[] cArray = new char[n];
        int n2 = this.bufEnd;
        if (n2 > n) {
            n2 = n;
            if (this.state != 1) {
                throw new PullParserRuntimeException("internal buffer may not be shrank during parsing" + this.getPosDesc());
            }
        }
        System.arraycopy(this.buf, 0, cArray, 0, n2);
        this.buf = cArray;
        this.bufSize = n;
        if (this.softLimit == -1) {
            this.posSafe = this.loadFactor * this.bufSize / 100;
        }
    }

    private void ensurePC() {
        if (this.paramPC && this.pcEnd >= this.pc.length) {
            int n = 2 * this.pcEnd + 1;
            char[] cArray = new char[n];
            System.arraycopy(this.pc, 0, cArray, 0, this.pc.length);
            this.pc = cArray;
        }
    }

    private char less() {
        --this.pos;
        --this.posCol;
        this.backtracking = true;
        return this.prevPrevCh;
    }

    private void shrink(int n) {
        System.arraycopy(this.buf, n, this.buf, 0, this.bufEnd - n);
        this.shrinkOffset += n;
        this.bufEnd -= n;
        this.pos -= n;
        this.posStart -= n;
        this.posEnd -= n;
        this.posNsColon -= n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte next() throws TokenizerException, IOException {
        if (this.state == 7) {
            throw new TokenizerException("attempt to read beyond end of input");
        }
        this.parsedContent = false;
        block32: while (true) {
            int n;
            if (this.reachedEnd) {
                if (this.state != 6) {
                    if (this.state != 12 && this.state != 10 && this.state != 11) {
                        throw new TokenizerException("unexpected end of stream (state=" + this.state + ")" + this.getPosDesc());
                    }
                    if (this.state == 10 || this.state == 11) {
                        if (this.state == 10) {
                            this.pcStart = 0;
                            this.pcEnd = 0;
                        }
                        this.posEnd = this.posStart = this.pos - 1;
                    }
                    this.state = (byte)6;
                    if (this.paramPC && (this.pcStart != this.pcEnd || this.posEnd != this.posStart)) {
                        boolean bl = this.parsedContent = this.pcEnd != this.pcStart;
                        if (!this.paramNoMixContent || !this.seenContent) {
                            return 10;
                        }
                        if (this.parsedContent) {
                            throw new TokenizerException("no element content allowed before end of stream" + this.getPosDesc());
                        }
                    }
                }
                this.state = (byte)7;
                return 2;
            }
            char c = this.more();
            if (c == '\r') {
                if (this.pcStart == this.pcEnd && this.posEnd > this.posStart) {
                    n = this.posEnd - this.posStart;
                    System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, n);
                    this.pcEnd += n;
                }
            } else if (this.prevPrevCh == '\r' && c == '\n') continue;
            switch (this.state) {
                case 1: {
                    if (c == '\ufffe') {
                        throw new TokenizerException("first character in input was UNICODE noncharacter (0xFFFE)- input requires byte swapping");
                    }
                    if (c == '\ufeff') {
                        this.state = (byte)10;
                        continue block32;
                    }
                }
                case 10: {
                    this.pcStart = 0;
                    this.pcEnd = 0;
                }
                case 11: {
                    this.posEnd = this.posStart = this.pos - 1;
                    this.state = (byte)12;
                }
                case 12: {
                    if (c == '<') {
                        this.state = (byte)13;
                        if (!this.paramNotifyCharacters || this.posStart == this.posEnd) continue block32;
                        return 20;
                    }
                    if (c == '&') {
                        if (this.paramPC && this.pcStart == this.pcEnd && this.posEnd > this.posStart) {
                            n = this.posEnd - this.posStart;
                            System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, n);
                            this.pcEnd += n;
                        }
                        if (!this.seenContent) {
                            this.seenContent = true;
                            if (this.paramNoMixContent && !this.mixInElement) {
                                throw new TokenizerException("mixed content disallowed outside element" + this.getPosDesc(), this.posRow, this.posCol - 1);
                            }
                        }
                        this.state = (byte)70;
                        this.previousState = (byte)11;
                        this.posStart = this.pos - 1;
                        continue block32;
                    }
                    if (!this.seenContent && !this.isS(c)) {
                        this.seenContent = true;
                        if (this.paramNoMixContent && !this.mixInElement) {
                            throw new TokenizerException("mixed content disallowed outside element, character " + Tokenizer.printable(c) + " (" + c + ")" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                    }
                    this.posEnd = this.pos;
                    if (this.paramPC && (this.pcStart != this.pcEnd || c == '\r')) {
                        if (c == '\r') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 10;
                        } else {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = c;
                        }
                    }
                    if (!this.paramNotifyCharacters || !this.reachedEnd) continue block32;
                    return 20;
                }
                case 13: {
                    if (c == '!') {
                        this.state = (byte)14;
                    } else if (c == '?') {
                        this.state = (byte)60;
                    } else {
                        n = this.seenContent ? 1 : 0;
                        boolean bl = this.mixInElement;
                        if (c == '/') {
                            this.state = (byte)110;
                            this.mixInElement = false;
                        } else {
                            this.state = (byte)120;
                            if (this.paramNoMixContent && this.seenContent) {
                                throw new TokenizerException("mixed content disallowed inside element and before start tag" + this.getPosDesc(), this.posRow, this.posCol - 1);
                            }
                            this.mixInElement = true;
                        }
                        if (this.paramPC && (this.pcStart != this.pcEnd || this.posEnd != this.posStart || this.state == 110 && this.seenStartTag) && (!this.paramNoMixContent || n != 0 || this.paramNoMixContent && this.state == 110 && this.seenStartTag)) {
                            boolean bl2 = this.parsedContent = this.pcEnd != this.pcStart;
                            if (!this.parsedContent && this.posEnd == this.posStart) continue block32;
                            return 10;
                        }
                    }
                    if (this.paramPC && this.state != 120 && this.state != 110 && this.pcStart == this.pcEnd && this.posEnd > this.posStart) {
                        n = this.posEnd - this.posStart;
                        System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, n);
                        this.pcEnd += n;
                    }
                    this.posStart = this.pos;
                    continue block32;
                }
                case 14: {
                    if (c == '-') {
                        c = this.more();
                        if (c != '-') {
                            throw new TokenizerException("expected - for start of comment <!-- not " + c + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        this.state = (byte)40;
                        this.posStart = this.pos;
                        continue block32;
                    }
                    if (c == '[') {
                        c = this.more();
                        if (c != 'C') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        c = this.more();
                        if (c != 'D') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        c = this.more();
                        if (c != 'A') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        c = this.more();
                        if (c != 'T') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        c = this.more();
                        if (c != 'A') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        c = this.more();
                        if (c != '[') {
                            throw new TokenizerException("expected <![CDATA" + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                        this.posStart = this.pos;
                        if (!this.seenContent) {
                            this.seenContent = true;
                            if (this.paramNoMixContent && !this.mixInElement) {
                                throw new TokenizerException("mixed content disallowed outside element" + this.getPosDesc(), this.posRow, this.posCol - 1);
                            }
                        }
                        this.state = (byte)30;
                        continue block32;
                    }
                    if (c != 'D') throw new TokenizerException("unknown markup after <! " + Tokenizer.printableChar(c) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    c = this.more();
                    if (c != 'O') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    c = this.more();
                    if (c != 'C') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    c = this.more();
                    if (c != 'T') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    c = this.more();
                    if (c != 'Y') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    c = this.more();
                    if (c != 'P') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    c = this.more();
                    if (c != 'E') {
                        throw new TokenizerException("expected <![DOCTYPE" + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    this.posStart = this.pos;
                    this.state = (byte)50;
                    continue block32;
                }
                case 70: {
                    this.posStart = this.pos - 2;
                    if (c == '#') {
                        this.state = (byte)75;
                        continue block32;
                    }
                    this.state = (byte)71;
                }
                case 71: {
                    if (c != ';') continue block32;
                    this.state = this.previousState;
                    this.posEnd = this.pos;
                    if (this.paramPC) {
                        int n2 = this.pos - 1;
                        n = this.posStart + 1;
                        int n3 = n2 - n;
                        if (n3 == 2 && this.buf[n] == 'l' && this.buf[n + 1] == 't') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 60;
                        } else if (n3 == 3 && this.buf[n] == 'a' && this.buf[n + 1] == 'm' && this.buf[n + 2] == 'p') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 38;
                        } else if (n3 == 2 && this.buf[n] == 'g' && this.buf[n + 1] == 't') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 62;
                        } else if (n3 == 4 && this.buf[n] == 'a' && this.buf[n + 1] == 'p' && this.buf[n + 2] == 'o' && this.buf[n + 3] == 's') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 39;
                        } else if (n3 == 4 && this.buf[n] == 'q' && this.buf[n + 1] == 'u' && this.buf[n + 2] == 'o' && this.buf[n + 3] == 't') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 34;
                        } else {
                            String string = new String(this.buf, n, n2 - n);
                            throw new TokenizerException("undefined entity " + string + this.getPosDesc(), this.posRow, this.posCol - 1);
                        }
                    }
                    if (!this.paramNotifyEntityRef) continue block32;
                    return 70;
                }
                case 75: {
                    this.charRefValue = '\u0000';
                    this.state = (byte)76;
                    if (c == 'x') {
                        this.charRefHex = true;
                        continue block32;
                    }
                    this.charRefHex = false;
                }
                case 76: {
                    if (c == ';') {
                        if (this.paramPC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = this.charRefValue;
                        }
                        this.state = this.previousState;
                        this.posEnd = this.pos;
                        if (!this.paramNotifyCharRef) continue block32;
                        return 75;
                    }
                    if (c >= '0' && c <= '9') {
                        if (this.charRefHex) {
                            this.charRefValue = (char)(this.charRefValue * 16 + (c - 48));
                            continue block32;
                        }
                        this.charRefValue = (char)(this.charRefValue * 10 + (c - 48));
                        continue block32;
                    }
                    if (this.charRefHex && c >= 'A' && c <= 'F') {
                        this.charRefValue = (char)(this.charRefValue * 16 + (c - 65 + 10));
                        continue block32;
                    }
                    if (!this.charRefHex || c < 'a' || c > 'f') throw new TokenizerException("character reference may not contain " + Tokenizer.printable(c) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    this.charRefValue = (char)(this.charRefValue * 16 + (c - 97 + 10));
                    continue block32;
                }
                case 110: {
                    this.seenStartTag = false;
                    this.seenContent = false;
                    this.posStart = this.pos - 1;
                    c = this.readName(c);
                    this.posEnd = this.pos - 1;
                    c = this.skipS(c);
                    if (c != '>') {
                        throw new TokenizerException("expected > for end tag not " + Tokenizer.printable(c) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    this.state = (byte)10;
                    return 110;
                }
                case 120: {
                    if (this.shrinkable && this.reading && this.pos > 2 && this.pos > this.posSafe) {
                        this.shrink(this.pos - 2);
                    }
                    this.seenStartTag = true;
                    this.seenContent = false;
                    c = this.less();
                    this.posStart = this.pos - 1;
                    c = this.readName(c);
                    this.posEnd = this.pos - 1;
                    c = this.less();
                    this.state = (byte)122;
                    this.pcStart = 0;
                    this.pcEnd = 0;
                    return 120;
                }
                case 121: {
                    if (c != '>') throw new TokenizerException("expected > for end of start tag not " + Tokenizer.printable(c) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    this.state = (byte)10;
                    this.posStart = this.pos - 1;
                    this.posEnd = this.pos;
                    return 112;
                }
                case 122: {
                    this.pcStart = this.pcEnd;
                    n = this.isS(c);
                    c = this.skipS(c);
                    if (c == '/') {
                        this.state = (byte)121;
                        this.posStart = this.pos - 1;
                        this.posEnd = this.pos;
                        this.mixInElement = false;
                        this.seenStartTag = false;
                        return 111;
                    }
                    if (c == '>') {
                        this.state = (byte)10;
                        this.posStart = this.pos - 1;
                        this.posEnd = this.pos;
                        return 112;
                    }
                    if (0 == n) {
                        throw new TokenizerException("white space expected before attribute name and not " + Tokenizer.printable(c) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    this.posStart = this.pos - 1;
                    c = this.readName(c);
                    this.posEnd = this.pos - 1;
                    c = this.less();
                    this.state = (byte)123;
                    return 122;
                }
                case 123: {
                    c = this.skipS(c);
                    if (c != '=') {
                        throw new TokenizerException("expected = after attribute name not " + Tokenizer.printable(c) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    this.state = (byte)124;
                    continue block32;
                }
                case 124: {
                    c = this.skipS(c);
                    if (c != '\'' && c != '\"') {
                        throw new TokenizerException("attribute value must start with double quote or apostrophe not " + Tokenizer.printable(c) + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    this.attrMarker = c;
                    this.state = (byte)125;
                    this.posEnd = this.posStart = this.pos;
                    this.pcEnd = this.pcStart;
                    continue block32;
                }
                case 125: {
                    this.state = (byte)126;
                }
                case 126: {
                    if (c == this.attrMarker) {
                        this.state = this.paramPC ? (byte)127 : (byte)122;
                        if (!this.paramNotifyAttValue) continue block32;
                        return 124;
                    }
                    if (c == '&') {
                        if (this.paramPC && this.pcEnd == this.pcStart && this.posEnd > this.posStart) {
                            n = this.posEnd - this.posStart;
                            System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, n);
                            this.pcEnd += n;
                        }
                        this.state = (byte)70;
                        this.previousState = (byte)125;
                        if (!this.paramNotifyAttValue) continue block32;
                        return 124;
                    }
                    if (c == '<') {
                        throw new TokenizerException("attribute value can not contain " + c + this.getPosDesc(), this.posRow, this.posCol - 1);
                    }
                    if (this.paramPC && (this.pcStart != this.pcEnd || c == '\t' || c == '\n' || c == '\r')) {
                        if (this.pcStart == this.pcEnd && this.posEnd > this.posStart) {
                            n = this.posEnd - this.posStart;
                            System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, n);
                            this.pcEnd += n;
                        }
                        if (c == '\t' || c == '\n' || c == '\r') {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC();
                            }
                            this.pc[this.pcEnd++] = 32;
                            continue block32;
                        }
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC();
                        }
                        this.pc[this.pcEnd++] = c;
                        continue block32;
                    }
                    this.posEnd = this.pos;
                    continue block32;
                }
                case 127: {
                    c = this.less();
                    this.parsedContent = this.pcEnd != this.pcStart;
                    this.state = (byte)122;
                    return 127;
                }
                case 30: {
                    if (c != ']') continue block32;
                    this.state = (byte)31;
                    continue block32;
                }
                case 31: {
                    if (c == ']') {
                        this.state = (byte)32;
                        continue block32;
                    }
                    this.state = (byte)30;
                    continue block32;
                }
                case 32: {
                    if (c == '>') {
                        this.state = (byte)11;
                        this.posEnd = this.pos - 3;
                        if (this.paramPC && this.posEnd > this.posStart) {
                            n = this.posEnd - this.posStart;
                            if (n + this.pcEnd > this.pc.length) {
                                char[] cArray = new char[n + this.pcEnd];
                                System.arraycopy(this.pc, 0, cArray, 0, this.pcEnd);
                                this.pc = cArray;
                            }
                            System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, n);
                            this.pcEnd += n;
                        }
                        if (!this.paramNotifyCDSect) continue block32;
                        return 30;
                    }
                    this.state = (byte)30;
                    continue block32;
                }
                case 40: {
                    if (c != '-') continue block32;
                    this.state = (byte)41;
                    continue block32;
                }
                case 41: {
                    if (c == '-') {
                        this.state = (byte)42;
                        continue block32;
                    }
                    this.state = (byte)40;
                    continue block32;
                }
                case 42: {
                    if (c == '>') {
                        this.state = (byte)11;
                        this.posEnd = this.pos - 3;
                        if (!this.paramNotifyComment) continue block32;
                        return 40;
                    }
                    this.state = (byte)40;
                    continue block32;
                }
                case 50: {
                    if (c == '[') {
                        this.state = (byte)51;
                        continue block32;
                    }
                    if (c != '>') continue block32;
                    this.state = (byte)11;
                    this.posEnd = this.pos - 1;
                    if (!this.paramNotifyDoctype) continue block32;
                    return 50;
                }
                case 51: {
                    if (c != ']') continue block32;
                    this.state = (byte)52;
                    continue block32;
                }
                case 52: {
                    c = this.skipS(c);
                    if (c != '>') throw new TokenizerException("expected > for DOCTYPE end not " + c + this.getPosDesc(), this.posRow, this.posCol - 1);
                    this.state = (byte)11;
                    this.posEnd = this.pos - 1;
                    if (!this.paramNotifyDoctype) continue block32;
                    return 50;
                }
                case 60: {
                    if (c != '?') continue block32;
                    this.state = (byte)61;
                    continue block32;
                }
                case 61: {
                    if (c != '>') continue block32;
                    this.state = (byte)11;
                    this.posEnd = this.pos - 2;
                    if (this.paramNotifyPI) return 60;
                    continue block32;
                }
            }
            break;
        }
        throw new TokenizerException("invalid internal state " + this.state + this.getPosDesc(), this.posRow, this.posCol - 1);
    }
}

