/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.skeleton;

import com.novell.nds.dirxml.driver.Trace;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.xml.dom.DocumentFactory;
import com.novell.xsl.util.Util;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class CommonImpl {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FATAL = 1;
    public static final int STATUS_ERROR = 2;
    public static final int STATUS_WARNING = 3;
    public static final int STATUS_RETRY = 4;
    protected Trace tracer;
    protected static final String[] STATUS_LEVELS = new String[]{"success", "fatal", "error", "warning", "retry"};

    protected CommonImpl(String string) {
        this.tracer = new Trace(string);
    }

    protected Element addState(Element element, String string, String string2, String string3) {
        Element element2;
        Document document = element.getOwnerDocument();
        Element element3 = (Element)element.getElementsByTagName("init-params").item(0);
        if (element3 == null) {
            element3 = document.createElement("init-params");
            element.appendChild(element3);
            element2 = document.createElement(string);
            element3.appendChild(element2);
        } else {
            element2 = (Element)element3.getElementsByTagName(string).item(0);
            if (element2 == null) {
                element2 = document.createElement(string);
                element3.appendChild(element2);
            }
        }
        Element element4 = document.createElement(string2);
        element2.appendChild(element4);
        if (string3 != null && string3.length() > 0) {
            Text text = document.createTextNode(string3);
            element4.appendChild(text);
        }
        return element4;
    }

    protected Element addStatusElement(Element element, int n, String string, String string2) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("status");
        element.appendChild(element2);
        element2.setAttribute("level", STATUS_LEVELS[n]);
        if (string2 != null && string2.length() > 0) {
            element2.setAttribute("event-id", string2);
        }
        if (string != null && string.length() > 0) {
            Text text = document.createTextNode(string);
            element2.appendChild(text);
        }
        return element2;
    }

    protected Element createInputDocument() {
        Element element = this.createXdsDocument();
        Element element2 = element.getOwnerDocument().createElement("input");
        element.appendChild(element2);
        return element2;
    }

    protected Element createOutputDocument() {
        Element element = this.createXdsDocument();
        Element element2 = element.getOwnerDocument().createElement("output");
        element.appendChild(element2);
        return element2;
    }

    protected XmlDocument createStatusDocument(int n, String string) {
        Element element = this.createOutputDocument();
        this.addStatusElement(element, n, string, null);
        return new XmlDocument(element.getOwnerDocument());
    }

    protected XmlDocument createSuccessDocument() {
        return this.createStatusDocument(0, null);
    }

    protected Element createXdsDocument() {
        Document document = DocumentFactory.newDocument();
        Element element = document.createElement("nds");
        document.appendChild(element);
        element.setAttribute("ndsversion", "8.5");
        element.setAttribute("dtdversion", "1.0");
        return element;
    }

    private void extractValues(Element element, ShimParams shimParams, ShimParamDesc[] shimParamDescArray) {
        if (element != null) {
            int n = 0;
            while (n < shimParamDescArray.length) {
                String string;
                Element element2 = (Element)element.getElementsByTagName(shimParamDescArray[n].paramName).item(0);
                if (element2 != null && (string = Util.getXSLStringValue((Node)element2)) != null && string.length() != 0) {
                    if (shimParamDescArray[n].paramType == 0) {
                        shimParams.putStringParam(shimParamDescArray[n].paramName, string);
                    } else {
                        try {
                            int n2 = Integer.parseInt(string);
                            shimParams.putIntParam(shimParamDescArray[n].paramName, n2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException("option '" + shimParamDescArray[n].paramName + "' must be integer type");
                        }
                    }
                }
                ++n;
            }
        }
    }

    protected AuthenticationParams getAuthenticationParams(Document document) {
        Element element;
        Element element2;
        AuthenticationParams authenticationParams = new AuthenticationParams();
        Element element3 = (Element)document.getElementsByTagName("init-params").item(0);
        if (element3 == null) {
            return authenticationParams;
        }
        Element element4 = (Element)document.getElementsByTagName("authentication-info").item(0);
        if (element4 == null) {
            return authenticationParams;
        }
        Element element5 = (Element)element4.getElementsByTagName("server").item(0);
        if (element5 != null) {
            authenticationParams.authenticationContext = Util.getXSLStringValue((Node)element5);
        }
        if ((element2 = (Element)element4.getElementsByTagName("user").item(0)) != null) {
            authenticationParams.authenticationId = Util.getXSLStringValue((Node)element2);
        }
        if ((element = (Element)element4.getElementsByTagName("password").item(0)) != null) {
            authenticationParams.applicationPassword = Util.getXSLStringValue((Node)element);
        }
        return authenticationParams;
    }

    protected ShimParams getShimParams(Document document, String string, ShimParamDesc[] shimParamDescArray) throws IllegalArgumentException {
        ShimParams shimParams = new ShimParams();
        String string2 = String.valueOf(string) + "-options";
        Element element = (Element)document.getElementsByTagName(string2).item(0);
        this.extractValues(element, shimParams, shimParamDescArray);
        String string3 = String.valueOf(string) + "-state";
        Element element2 = (Element)document.getElementsByTagName(string3).item(0);
        this.extractValues(element2, shimParams, shimParamDescArray);
        StringBuffer stringBuffer = new StringBuffer(128);
        int n = 0;
        int n2 = 0;
        while (n2 < shimParamDescArray.length) {
            if (shimParamDescArray[n2].required && !shimParams.haveParam(shimParamDescArray[n2].paramName)) {
                ++n;
                stringBuffer.append('\n');
                stringBuffer.append("missing required option: '" + shimParamDescArray[n2].paramName + "'");
            }
            ++n2;
        }
        if (n > 0) {
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        return shimParams;
    }

    static class AuthenticationParams {
        public String authenticationId;
        public String authenticationContext;
        public String applicationPassword;

        AuthenticationParams() {
        }
    }

    static class ShimParamDesc {
        public static final int STRING_TYPE = 0;
        public static final int INT_TYPE = 1;
        public String paramName;
        public int paramType;
        public boolean required;

        public ShimParamDesc(String string, int n, boolean bl) {
            this.paramName = string;
            this.paramType = n;
            this.required = bl;
        }
    }

    static class ShimParams {
        private Map paramMap = new HashMap();

        ShimParams() {
        }

        public int getIntParam(String string) {
            int n = -1;
            Integer n2 = (Integer)this.paramMap.get((Object)string);
            if (n2 != null) {
                n = n2;
            }
            return n;
        }

        public String getStringParam(String string) {
            return (String)this.paramMap.get((Object)string);
        }

        public boolean haveParam(String string) {
            return this.paramMap.containsKey((Object)string);
        }

        public void putIntParam(String string, int n) {
            this.paramMap.put((Object)string, (Object)new Integer(n));
        }

        public void putStringParam(String string, String string2) {
            this.paramMap.put((Object)string, (Object)string2);
        }
    }
}

