/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.skeleton;

import com.novell.nds.dirxml.driver.DriverShim;
import com.novell.nds.dirxml.driver.PublicationShim;
import com.novell.nds.dirxml.driver.SubscriptionShim;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.skeleton.CommonImpl;
import com.novell.nds.dirxml.driver.skeleton.SkeletonPublicationShim;
import com.novell.nds.dirxml.driver.skeleton.SkeletonSubscriptionShim;
import org.w3c.dom.Element;

public class SkeletonDriverShim
extends CommonImpl
implements DriverShim {
    SkeletonSubscriptionShim subscriptionShim;
    SkeletonPublicationShim publicationShim;
    CommonImpl.ShimParams params;
    CommonImpl.AuthenticationParams authParams;
    private static final CommonImpl.ShimParamDesc[] DRIVER_PARAMS = new CommonImpl.ShimParamDesc[]{new CommonImpl.ShimParamDesc("option-1", 0, false), new CommonImpl.ShimParamDesc("option-2", 1, false)};

    public SkeletonDriverShim() {
        super("SkeletonDriverShim");
    }

    public PublicationShim getPublicationShim() {
        this.tracer.trace("getPublicationShim");
        return this.publicationShim;
    }

    public XmlDocument getSchema(XmlDocument xmlDocument) {
        this.authParams = this.getAuthenticationParams(xmlDocument.getDocument());
        return this.createStatusDocument(2, "Skeleton driver doesn't support the getSchema operation");
    }

    public SubscriptionShim getSubscriptionShim() {
        this.tracer.trace("getSubscriptionShim");
        return this.subscriptionShim;
    }

    public XmlDocument init(XmlDocument xmlDocument) {
        try {
            this.tracer.trace("init");
            Element element = this.createOutputDocument();
            this.authParams = this.getAuthenticationParams(xmlDocument.getDocument());
            if (this.authParams.authenticationId == null && this.authParams.authenticationContext == null && this.authParams.applicationPassword == null) {
                this.addStatusElement(element, 3, "No authentication information", null);
            }
            this.params = this.getShimParams(xmlDocument.getDocument(), "driver", DRIVER_PARAMS);
            this.subscriptionShim = new SkeletonSubscriptionShim(this.authParams);
            this.publicationShim = new SkeletonPublicationShim(this.authParams);
            if (element.getElementsByTagName("status").item(0) == null) {
                this.addStatusElement(element, 0, null, null);
            }
            return new XmlDocument(element.getOwnerDocument());
        }
        catch (Throwable throwable) {
            return this.createStatusDocument(1, throwable.getMessage());
        }
    }

    public XmlDocument shutdown(XmlDocument xmlDocument) {
        this.tracer.trace("shutdown");
        Element element = this.createOutputDocument();
        this.subscriptionShim.setState(element);
        this.publicationShim.stop();
        this.addStatusElement(element, 0, null, null);
        return new XmlDocument(element.getOwnerDocument());
    }
}

