/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.skeleton;

import com.novell.nds.dirxml.driver.DriverFilter;
import com.novell.nds.dirxml.driver.PublicationShim;
import com.novell.nds.dirxml.driver.XmlCommandProcessor;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.nds.dirxml.driver.skeleton.CommonImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SkeletonPublicationShim
extends CommonImpl
implements PublicationShim,
XmlQueryProcessor {
    boolean shutdown = false;
    int pollingInterval = 2;
    Object semaphore = new Object();
    DriverFilter filter;
    private CommonImpl.AuthenticationParams authParams;
    private static final CommonImpl.ShimParamDesc[] PUBLISHER_PARAMS = new CommonImpl.ShimParamDesc[]{new CommonImpl.ShimParamDesc("pub-1", 0, false), new CommonImpl.ShimParamDesc("polling-interval", 1, false)};

    SkeletonPublicationShim(CommonImpl.AuthenticationParams authenticationParams) {
        super("SkeletonPublicationShim");
        this.authParams = authenticationParams;
    }

    public XmlDocument init(XmlDocument xmlDocument) {
        Element element;
        this.tracer.trace("init");
        Document document = xmlDocument.getDocument();
        CommonImpl.ShimParams shimParams = this.getShimParams(document, "publisher", PUBLISHER_PARAMS);
        int n = shimParams.getIntParam("polling-interval");
        if (n != -1) {
            this.pollingInterval = n;
        }
        NodeList nodeList = document.getElementsByTagName("driver-filter");
        int n2 = 0;
        while ((element = (Element)nodeList.item(n2++)) != null) {
            String string = element.getAttribute("type");
            if (string.length() != 0 && !string.equals("publisher")) continue;
            this.filter = new DriverFilter(element);
            break;
        }
        if (this.filter == null) {
            this.filter = new DriverFilter();
        }
        return this.createSuccessDocument();
    }

    public XmlDocument query(XmlDocument xmlDocument) {
        this.tracer.trace("query");
        return this.createSuccessDocument();
    }

    public XmlDocument start(XmlCommandProcessor xmlCommandProcessor) {
        this.tracer.trace("start");
        while (!this.shutdown) {
            try {
                this.tracer.trace("polling...");
                Object object = this.semaphore;
                synchronized (object) {
                    this.semaphore.wait(this.pollingInterval * 1000);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        this.tracer.trace("stopping");
        return this.createSuccessDocument();
    }

    void stop() {
        this.shutdown = true;
        Object object = this.semaphore;
        synchronized (object) {
            this.semaphore.notifyAll();
            return;
        }
    }
}

