/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.skeleton;

import com.novell.nds.dirxml.driver.SubscriptionShim;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.nds.dirxml.driver.skeleton.CommonImpl;
import com.novell.xsl.util.Util;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SkeletonSubscriptionShim
extends CommonImpl
implements SubscriptionShim {
    private static final String DRIVER_ID_VALUE = "JSKEL";
    private static final String DRIVER_VERSION_VALUE = "1.1";
    private static final String DRIVER_MIN_ACTIVATION_VERSION = "0";
    CommonImpl.ShimParams params;
    private boolean connected = false;
    private Element outputElement;
    private int currentAssociation = 1;
    private CommonImpl.AuthenticationParams authParams;
    private static final CommonImpl.ShimParamDesc[] SUBSCRIBER_PARAMS = new CommonImpl.ShimParamDesc[]{new CommonImpl.ShimParamDesc("sub-1", 0, false), new CommonImpl.ShimParamDesc("current-association", 1, false)};

    SkeletonSubscriptionShim(CommonImpl.AuthenticationParams authenticationParams) {
        super("SkeletonSubscriptionShim");
        this.authParams = authenticationParams;
    }

    void addDriverIdentification(Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("instance");
        element.appendChild(element2);
        element2.setAttribute("class-name", "__driver_identification_class__");
        Element element3 = document.createElement("attr");
        element2.appendChild(element3);
        element3.setAttribute("attr-name", "driver-id");
        Element element4 = document.createElement("value");
        element3.appendChild(element4);
        element4.setAttribute("type", "string");
        Text text = document.createTextNode(DRIVER_ID_VALUE);
        element4.appendChild(text);
        element3 = document.createElement("attr");
        element2.appendChild(element3);
        element3.setAttribute("attr-name", "driver-version");
        element4 = document.createElement("value");
        element3.appendChild(element4);
        element4.setAttribute("type", "string");
        text = document.createTextNode(DRIVER_VERSION_VALUE);
        element4.appendChild(text);
        element3 = document.createElement("attr");
        element2.appendChild(element3);
        element3.setAttribute("attr-name", "min-activation-version");
        element4 = document.createElement("value");
        element3.appendChild(element4);
        element4.setAttribute("type", "int");
        text = document.createTextNode(DRIVER_MIN_ACTIVATION_VERSION);
        element4.appendChild(text);
    }

    private void addHandler(Element element) throws Exception {
        String string = element.getAttribute("class-name");
        String string2 = element.getAttribute("event-id");
        String string3 = element.getAttribute("src-dn");
        if (this.tracer.getTraceLevel() >= 1) {
            this.tracer.trace("addHandler: class == '" + string + "'");
        }
        Document document = this.outputElement.getOwnerDocument();
        Element element2 = document.createElement("add-association");
        this.outputElement.appendChild(element2);
        element2.setAttribute("dest-dn", string3);
        element2.setAttribute("event-id", string2);
        Text text = document.createTextNode(Integer.toString(this.currentAssociation));
        element2.appendChild(text);
        ++this.currentAssociation;
    }

    private void connect() throws IOException {
        if (!this.connected) {
            this.connected = true;
        }
    }

    private void deleteHandler(Element element) throws Exception {
        String string = element.getAttribute("class-name");
        String string2 = element.getAttribute("event-id");
        this.getAssociation(element);
        if (this.tracer.getTraceLevel() >= 1) {
            this.tracer.trace("deleteHandler: class == '" + string + "'");
        }
        this.addStatusElement(this.outputElement, 0, null, string2);
    }

    private void dispatch(Element element) throws Exception {
        String string = element.getNodeName();
        if (string.equals("add")) {
            this.addHandler(element);
            return;
        }
        if (string.equals("modify")) {
            this.modifyHandler(element);
            return;
        }
        if (string.equals("delete")) {
            this.deleteHandler(element);
            return;
        }
        if (string.equals("rename")) {
            this.renameHandler(element);
            return;
        }
        if (string.equals("move")) {
            this.moveHandler(element);
            return;
        }
        if (string.equals("query")) {
            this.queryHandler(element);
            return;
        }
        this.addStatusElement(this.outputElement, 2, "Unsupported command: '" + string + "'", element.getAttribute("event-id"));
    }

    public XmlDocument execute(XmlDocument xmlDocument, XmlQueryProcessor xmlQueryProcessor) {
        int n = 2;
        this.tracer.trace("execute");
        try {
            this.outputElement = this.createOutputDocument();
            while (n-- > 0) {
                try {
                    if (!this.connected) {
                        this.connected = true;
                    }
                    Document document = xmlDocument.getDocument();
                    Element element = (Element)document.getElementsByTagName("input").item(0);
                    Node node = element.getFirstChild();
                    while (node != null) {
                        if (node.getNodeType() == 1) {
                            this.dispatch((Element)node);
                        }
                        node = node.getNextSibling();
                    }
                    return new XmlDocument(this.outputElement.getOwnerDocument());
                }
                catch (IOException iOException) {
                    if (n > 0) continue;
                    throw iOException;
                }
            }
            throw new IOException("failed to connect");
        }
        catch (IOException iOException) {
            return this.createStatusDocument(4, iOException.toString());
        }
        catch (Throwable throwable) {
            return this.createStatusDocument(2, throwable.getMessage());
        }
    }

    private String getAssociation(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && node.getNodeName().equals("association")) {
                return Util.getXSLStringValue((Node)node);
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public XmlDocument init(XmlDocument xmlDocument) {
        try {
            this.tracer.trace("init");
            this.params = this.getShimParams(xmlDocument.getDocument(), "subscriber", SUBSCRIBER_PARAMS);
            int n = this.params.getIntParam("current-association");
            if (n != -1) {
                this.currentAssociation = n;
            }
            return this.createSuccessDocument();
        }
        catch (Throwable throwable) {
            return this.createStatusDocument(1, throwable.getMessage());
        }
    }

    private void modifyHandler(Element element) throws Exception {
        String string = element.getAttribute("class-name");
        String string2 = element.getAttribute("event-id");
        this.getAssociation(element);
        if (this.tracer.getTraceLevel() >= 1) {
            this.tracer.trace("modifyHandler: class == '" + string + "'");
        }
        this.addStatusElement(this.outputElement, 0, null, string2);
    }

    private void moveHandler(Element element) throws Exception {
        String string = element.getAttribute("class-name");
        String string2 = element.getAttribute("event-id");
        this.getAssociation(element);
        if (this.tracer.getTraceLevel() >= 1) {
            this.tracer.trace("moveHandler: class == '" + string + "'");
        }
        this.addStatusElement(this.outputElement, 0, null, string2);
    }

    private void queryHandler(Element element) {
        String string;
        String string2 = element.getAttribute("event-id");
        this.tracer.trace("queryHandler");
        Element element2 = (Element)element.getElementsByTagName("search-class").item(0);
        if (element2 != null && (string = element2.getAttribute("class-name")) != null && string.equals("__driver_identification_class__")) {
            this.addDriverIdentification(this.outputElement);
            return;
        }
        this.addStatusElement(this.outputElement, 0, null, string2);
    }

    private void renameHandler(Element element) throws Exception {
        String string = element.getAttribute("class-name");
        String string2 = element.getAttribute("event-id");
        this.getAssociation(element);
        if (this.tracer.getTraceLevel() >= 1) {
            this.tracer.trace("renameHandler: class == '" + string + "'");
        }
        this.addStatusElement(this.outputElement, 0, null, string2);
    }

    void setState(Element element) {
        this.addState(element, "subscriber-state", "current-association", Integer.toString(this.currentAssociation));
    }
}

