/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.IOException;
import java.util.Enumeration;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicy;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.RecordEntry;
import jdbm.recman.RecordCache;
import jdbm.recman.RecordManager;

public class ObjectCache
implements RecordCache {
    RecordManager _recman;
    CachePolicy _policy;
    CachePolicyListener _listener;

    public ObjectCache(RecordManager recman, CachePolicy policy) {
        this._recman = recman;
        this._recman.addCache(this);
        this._policy = policy;
        this._listener = new OwnPolicyListener();
        this._policy.addListener(this._listener);
    }

    public void dispose() {
        this._recman.removeCache(this);
        this._recman = null;
        this._policy.removeListener(this._listener);
        this._policy = null;
    }

    public Object fetchObject(long recid) throws IOException, ClassNotFoundException {
        if (recid == 0L) {
            throw new IllegalArgumentException("recid 0 is reserved.");
        }
        Long id = new Long(recid);
        RecordEntry entry = (RecordEntry)this._policy.get(id);
        if (entry == null) {
            Object obj = this._recman.fetchObject(recid);
            if (obj == null) {
                throw new Error("Persistent object cannot be null");
            }
            entry = new RecordEntry(id, obj);
            try {
                this._policy.put(entry.getRecid(), entry);
            }
            catch (CacheEvictionException cee) {
                Exception nested = cee.getNestedException();
                if (nested instanceof IOException) {
                    throw (IOException)nested;
                }
                if (nested != null) {
                    nested.printStackTrace();
                }
                cee.printStackTrace();
                throw new Error("Unhandled CacheEvictionException");
            }
        }
        return entry.getValue();
    }

    public void flush(long recid) throws IOException {
        Long id = new Long(recid);
        RecordEntry entry = (RecordEntry)this._policy.get(id);
        if (entry != null && entry.isDirty()) {
            this._recman.update(recid, entry.getValue());
            entry.setDirty(false);
        }
    }

    public void flushAll() throws IOException {
        Enumeration enumeration = this._policy.elements();
        while (enumeration.hasMoreElements()) {
            RecordEntry entry = (RecordEntry)enumeration.nextElement();
            if (!entry.isDirty()) continue;
            this._recman.update((long)entry.getRecid(), entry.getValue());
            entry.setDirty(false);
        }
    }

    public void invalidate(long recid) {
        Long id = new Long(recid);
        this._policy.remove(id);
    }

    public void invalidateAll() {
        this._policy.removeAll();
    }

    public void update(long recid, Object obj) throws IOException {
        if (recid == 0L) {
            throw new IllegalArgumentException("recid 0 is reserved.");
        }
        if (obj == null) {
            throw new IllegalArgumentException("Persistent object cannot be null");
        }
        Long id = new Long(recid);
        RecordEntry entry = (RecordEntry)this._policy.get(id);
        if (entry == null) {
            entry = new RecordEntry(new Long(recid), obj);
            try {
                this._policy.put(entry.getRecid(), entry);
            }
            catch (CacheEvictionException cee) {
                Exception nested = cee.getNestedException();
                if (nested instanceof IOException) {
                    throw (IOException)nested;
                }
                if (nested != null) {
                    nested.printStackTrace();
                }
                cee.printStackTrace();
                throw new Error("Unhandled CacheEvictionException");
            }
        }
        entry.setDirty(true);
    }

    class OwnPolicyListener
    implements CachePolicyListener {
        OwnPolicyListener() {
        }

        public void cacheObjectEvicted(Object obj) throws CacheEvictionException {
            RecordEntry entry = (RecordEntry)obj;
            if (entry.isDirty()) {
                try {
                    ObjectCache.this._recman.update((long)entry.getRecid(), entry.getValue());
                }
                catch (IOException ioe) {
                    throw new CacheEvictionException(ioe);
                }
                entry.setDirty(false);
            }
        }
    }
}

