/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;
import jdbm.recman.PageHeader;
import jdbm.recman.PhysicalRowId;

class FreeLogicalRowIdPage
extends PageHeader {
    private static final short O_COUNT = 18;
    static final short O_FREE = 20;
    static final short ELEMS_PER_PAGE = 817;
    final PhysicalRowId[] slots = new PhysicalRowId[817];

    FreeLogicalRowIdPage(BlockIo block) {
        super(block);
    }

    PhysicalRowId alloc(int slot) {
        this.setCount((short)(this.getCount() + 1));
        this.get(slot).setBlock(-1L);
        return this.get(slot);
    }

    void free(int slot) {
        this.get(slot).setBlock(0L);
        this.setCount((short)(this.getCount() - 1));
    }

    PhysicalRowId get(int slot) {
        if (this.slots[slot] == null) {
            this.slots[slot] = new PhysicalRowId(this.block, this.slotToOffset(slot));
        }
        return this.slots[slot];
    }

    short getCount() {
        return this.block.readShort(18);
    }

    int getFirstAllocated() {
        int i = 0;
        while (i < 817) {
            if (this.isAllocated(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int getFirstFree() {
        int i = 0;
        while (i < 817) {
            if (this.isFree(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static FreeLogicalRowIdPage getFreeLogicalRowIdPageView(BlockIo block) {
        BlockView view = block.getView();
        if (view != null && view instanceof FreeLogicalRowIdPage) {
            return (FreeLogicalRowIdPage)view;
        }
        return new FreeLogicalRowIdPage(block);
    }

    boolean isAllocated(int slot) {
        return this.get(slot).getBlock() > 0L;
    }

    boolean isFree(int slot) {
        return this.isAllocated(slot) ^ true;
    }

    private void setCount(short i) {
        this.block.writeShort(18, i);
    }

    private short slotToOffset(int slot) {
        return (short)(20 + slot * 10);
    }
}

