/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;
import jdbm.recman.FreePhysicalRowId;
import jdbm.recman.PageHeader;

final class FreePhysicalRowIdPage
extends PageHeader {
    private static final short O_COUNT = 18;
    static final short O_FREE = 20;
    static final short ELEMS_PER_PAGE = 583;
    FreePhysicalRowId[] slots = new FreePhysicalRowId[583];

    FreePhysicalRowIdPage(BlockIo block) {
        super(block);
    }

    FreePhysicalRowId alloc(int slot) {
        this.setCount((short)(this.getCount() + 1));
        return this.get(slot);
    }

    void free(int slot) {
        this.get(slot).setSize(0);
        this.setCount((short)(this.getCount() - 1));
    }

    FreePhysicalRowId get(int slot) {
        if (this.slots[slot] == null) {
            this.slots[slot] = new FreePhysicalRowId(this.block, this.slotToOffset(slot));
        }
        return this.slots[slot];
    }

    short getCount() {
        return this.block.readShort(18);
    }

    int getFirstFree() {
        int i = 0;
        while (i < 583) {
            if (this.isFree(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int getFirstLargerThan(int size) {
        int i = 0;
        while (i < 583) {
            if (this.isAllocated(i) && this.get(i).getSize() >= size) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static FreePhysicalRowIdPage getFreePhysicalRowIdPageView(BlockIo block) {
        BlockView view = block.getView();
        if (view != null && view instanceof FreePhysicalRowIdPage) {
            return (FreePhysicalRowIdPage)view;
        }
        return new FreePhysicalRowIdPage(block);
    }

    boolean isAllocated(int slot) {
        return this.get(slot).getSize() != 0;
    }

    boolean isFree(int slot) {
        return this.isAllocated(slot) ^ true;
    }

    private void setCount(short i) {
        this.block.writeShort(18, i);
    }

    short slotToOffset(int slot) {
        return (short)(20 + slot * 14);
    }
}

