/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.FreeLogicalRowIdPageManager;
import jdbm.recman.Location;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowId;
import jdbm.recman.RecordFile;
import jdbm.recman.TranslationPage;

final class LogicalRowIdManager {
    private RecordFile file;
    private PageManager pageman;
    private FreeLogicalRowIdPageManager freeman;

    LogicalRowIdManager(RecordFile file, PageManager pageman) throws IOException {
        this.file = file;
        this.pageman = pageman;
        this.freeman = new FreeLogicalRowIdPageManager(file, pageman);
    }

    void delete(Location rowid) throws IOException {
        this.freeman.put(rowid);
    }

    Location fetch(Location rowid) throws IOException {
        Location location;
        TranslationPage xlatPage = TranslationPage.getTranslationPageView(this.file.get(rowid.getBlock()));
        try {
            Location retval;
            location = retval = new Location(xlatPage.get(rowid.getOffset()));
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.file.release(rowid.getBlock(), false);
            throw throwable;
        }
        this.file.release(rowid.getBlock(), false);
        return location;
    }

    Location insert(Location loc) throws IOException {
        Location retval = this.freeman.get();
        if (retval == null) {
            long firstPage = this.pageman.allocate((short)2);
            short curOffset = 18;
            int i = 0;
            while (i < 817) {
                this.freeman.put(new Location(firstPage, curOffset));
                curOffset = (short)(curOffset + 10);
                ++i;
            }
            retval = this.freeman.get();
            if (retval == null) {
                throw new Error("couldn't obtain free translation");
            }
        }
        this.update(retval, loc);
        return retval;
    }

    void update(Location rowid, Location loc) throws IOException {
        TranslationPage xlatPage = TranslationPage.getTranslationPageView(this.file.get(rowid.getBlock()));
        PhysicalRowId physid = xlatPage.get(rowid.getOffset());
        physid.setBlock(loc.getBlock());
        physid.setOffset(loc.getOffset());
        this.file.release(rowid.getBlock(), true);
    }
}

