/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.EnumConstraint;
import com.novell.nds.dirxml.driver.xds.Lib_1_4;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.RangeConstraint;
import com.novell.nds.dirxml.driver.xds.util.Java;

final class BooleanConstraint
extends Constraint {
    public static final BooleanConstraint BOOLEAN;
    private static final ConstraintGroup TRUE;
    private static final ConstraintGroup FALSE;

    BooleanConstraint() {
        this.setOperator(LogicalOp.AND);
    }

    boolean isTrue(Parameter parameter, Object object, Object[] objectArray) {
        return TRUE.isValidValue(parameter, object, objectArray);
    }

    boolean isFalse(Parameter parameter, Object object, Object[] objectArray) {
        return FALSE.isValidValue(parameter, object, objectArray);
    }

    boolean isValidValue(Parameter parameter, Object object, Object[] objectArray) {
        boolean bl = true;
        if (object != null && !(object instanceof Boolean)) {
            if (this.isTrue(parameter, object, objectArray)) {
                objectArray[0] = Boolean.TRUE;
            } else if (this.isFalse(parameter, object, objectArray)) {
                objectArray[0] = Boolean.FALSE;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    String getLegalValues() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(TRUE.getLegalValues());
        stringBuffer.append(", ");
        stringBuffer.append(FALSE.getLegalValues());
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.getClass() == object.getClass();
    }

    Object cloneAsNeeded(boolean bl) {
        return this;
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return true;
    }

    public boolean canBeAppliedToMultipleParams() {
        return true;
    }

    boolean isStateful() {
        return false;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }

    static {
        boolean bl = Java.isJRE(1, 4);
        ConstraintGroup constraintGroup = new ConstraintGroup();
        EnumConstraint enumConstraint = new EnumConstraint();
        enumConstraint.addLiterals(new String[]{"y", "yes", "t", "true", "on"});
        constraintGroup.add(enumConstraint);
        RangeConstraint rangeConstraint = new RangeConstraint(1L, 1L);
        constraintGroup.add(rangeConstraint);
        if (bl) {
            constraintGroup.add(Lib_1_4.newCaseInsensitiveRegExConstraint("t.*"));
            constraintGroup.add(Lib_1_4.newCaseInsensitiveRegExConstraint("y.*"));
        }
        constraintGroup.setConstant();
        TRUE = constraintGroup;
        constraintGroup = new ConstraintGroup();
        enumConstraint = new EnumConstraint();
        enumConstraint.addLiterals(new String[]{"n", "no", "f", "false", "off"});
        constraintGroup.add(enumConstraint);
        rangeConstraint = new RangeConstraint(1L, 1L);
        rangeConstraint.setNOT();
        constraintGroup.add(rangeConstraint);
        if (bl) {
            constraintGroup.add(Lib_1_4.newCaseInsensitiveRegExConstraint("f.*"));
            constraintGroup.add(Lib_1_4.newCaseInsensitiveRegExConstraint("n.*"));
        }
        constraintGroup.setConstant();
        FALSE = constraintGroup;
        BooleanConstraint booleanConstraint = new BooleanConstraint();
        booleanConstraint.setConstant();
        BOOLEAN = booleanConstraint;
    }
}

