/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.BooleanComparator;
import com.novell.nds.dirxml.driver.xds.CharInsensitiveComparator;
import com.novell.nds.dirxml.driver.xds.CharSensitiveComparator;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.DoubleComparator;
import com.novell.nds.dirxml.driver.xds.LongComparator;
import com.novell.nds.dirxml.driver.xds.StringInsensitiveComparator;
import com.novell.nds.dirxml.driver.xds.StringSensitiveComparator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

abstract class Comparators {
    static final Comparator STRING_INSENSITIVE = new StringInsensitiveComparator();
    static final Comparator STRING_SENSITIVE = new StringSensitiveComparator();
    static final Comparator CHAR_INSENSITIVE = new CharInsensitiveComparator();
    static final Comparator CHAR_SENSITIVE = new CharSensitiveComparator();
    static final Comparator LONG;
    static final Comparator SHORT;
    static final Comparator INT;
    static final Comparator DOUBLE;
    static final Comparator FLOAT;
    static final Comparator BOOLEAN;
    static final Map ARGS;

    Comparators() {
    }

    static boolean AreNull(Object object, Object object2) {
        return object == null || object2 == null;
    }

    static int CompareNulls(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        throw new IllegalArgumentException("Both arguments cannot be non-null");
    }

    static boolean IsString(Object object) {
        return object == null ? false : object.getClass() == String.class;
    }

    static boolean IsCharacter(Object object) {
        return object == null ? false : object.getClass() == Character.class;
    }

    static boolean TestArgs(Comparator comparator, DataType dataType) {
        boolean bl;
        Object[] objectArray = (Object[])ARGS.get(dataType.getJavaClass());
        try {
            comparator.compare(objectArray[0], objectArray[1]);
            bl = true;
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        return bl;
    }

    static {
        SHORT = LONG = new LongComparator();
        INT = LONG;
        FLOAT = DOUBLE = new DoubleComparator();
        BOOLEAN = new BooleanComparator();
        ARGS = new HashMap();
        Object[] objectArray = new Object[]{new Short("0"), new Short("1")};
        ARGS.put(Short.class, objectArray);
        objectArray = new Object[]{new Integer(0), new Integer(1)};
        ARGS.put(Integer.class, objectArray);
        objectArray = new Object[]{new Long(0L), new Long(1L)};
        ARGS.put(Long.class, objectArray);
        objectArray = new Object[]{new Float(0.0), new Float(1.0)};
        ARGS.put(Float.class, objectArray);
        objectArray = new Object[]{new Double(0.0), new Double(1.0)};
        ARGS.put(Double.class, objectArray);
        objectArray = new Object[]{new Character('b'), new Character('a')};
        ARGS.put(Character.class, objectArray);
        objectArray = new Object[]{new Character('b'), new Character('a')};
        ARGS.put(Character.class, objectArray);
        objectArray = new Object[]{new String("cd"), new String("ab")};
        ARGS.put(String.class, objectArray);
        objectArray = new Object[]{new Boolean(false), new Boolean(true)};
        ARGS.put(Boolean.class, objectArray);
    }
}

