/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class ConstraintGroup
extends Constraint {
    private Set constraintSet;
    private int hashCode;
    private boolean hashCodeSet;

    public ConstraintGroup() {
        this.isGroup = true;
        this.constraintSet = Collections.EMPTY_SET;
    }

    private ConstraintGroup(ConstraintGroup constraintGroup, boolean bl) {
        this.isGroup = true;
        this.constant = constraintGroup.constant;
        this.groupOp = constraintGroup.groupOp;
        this.not = constraintGroup.not;
        this.required = constraintGroup.required;
        this.constraintSet = new HashSet(constraintGroup.constraintSet.size());
        this.constraints = new ArrayList(constraintGroup.constraints.size());
        ListIterator listIterator = constraintGroup.constraints.listIterator();
        while (listIterator.hasNext()) {
            Constraint constraint = (Constraint)listIterator.next();
            constraint = (Constraint)constraint.cloneAsNeeded(bl);
            if (constraintGroup.constant) {
                constraint.setConstant();
            }
            this.constraints.add(constraint);
            this.constraintSet.add(constraint);
        }
    }

    public void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    void setConstant() {
        this.constant = true;
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext()) {
            Constraint constraint = (Constraint)listIterator.next();
            constraint.setConstant();
        }
    }

    public boolean forStructured() {
        Constraint constraint;
        boolean bl = true;
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext() && (bl &= (constraint = (Constraint)listIterator.next()).forStructured())) {
        }
        return bl;
    }

    public boolean forScalar() {
        Constraint constraint;
        boolean bl = true;
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext() && (bl &= (constraint = (Constraint)listIterator.next()).forScalar())) {
        }
        return bl;
    }

    public void setOperator(LogicalOp logicalOp) {
        this.checkConstant();
        if (logicalOp != null) {
            this.groupOp = logicalOp;
        }
    }

    public void add(Constraint constraint) {
        if (constraint == null) {
            return;
        }
        if (constraint.isDependent()) {
            throw new IllegalArgumentException("Grouping of dependent constraints is not supported.");
        }
        if (constraint.isRequired()) {
            this.setRequired();
        }
        constraint.setConstant();
        if (!this.constraintSet.contains(constraint)) {
            this.addConstraint(constraint);
            if (this.constraintSet.isEmpty()) {
                this.constraintSet = new HashSet();
            }
            this.constraintSet.add(constraint);
        }
    }

    boolean isValidValue(Parameter parameter, Object object, Object[] objectArray) {
        if (this.groupOp == LogicalOp.AND) {
            return this.applyANDGroup(parameter, object, objectArray);
        }
        if (this.groupOp == LogicalOp.OR) {
            return this.applyORGroup(parameter, object, objectArray);
        }
        throw new RuntimeException("Broken IF-ELSE statement.");
    }

    String getLegalValues() {
        int n = this.constraints.size();
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            Constraint constraint = (Constraint)this.constraints.get(0);
            return constraint.getLegalValues();
        }
        int n2 = 1;
        StringBuffer stringBuffer = new StringBuffer(32 * n);
        stringBuffer.append("(");
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext()) {
            Constraint constraint = (Constraint)listIterator.next();
            stringBuffer.append(constraint.toString());
            if (n2 < n) {
                stringBuffer.append(" " + this.groupOp.toString() + " ");
            }
            ++n2;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private boolean applyANDGroup(Parameter parameter, Object object, Object[] objectArray) {
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext()) {
            Constraint constraint = (Constraint)listIterator.next();
            if (constraint.isValidValue(parameter, object, objectArray)) continue;
            return false;
        }
        return true;
    }

    private boolean applyORGroup(Parameter parameter, Object object, Object[] objectArray) {
        if (this.constraints.isEmpty()) {
            return true;
        }
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext()) {
            Constraint constraint = (Constraint)listIterator.next();
            if (!constraint.isValidValue(parameter, object, objectArray)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCodeSet) {
            return this.hashCode;
        }
        this.hashCode = 0;
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext()) {
            this.hashCode += listIterator.next().hashCode();
        }
        this.setConstant();
        this.hashCodeSet = true;
        return this.hashCode;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Constraint) {
            Constraint constraint = (Constraint)object;
            boolean bl2 = bl = this.constraints.size() == constraint.constraints.size();
            if (bl) {
                if (this.constraints.size() > 1) {
                    boolean bl3 = bl = this.groupOp == constraint.groupOp;
                }
                if (bl) {
                    if (this.groupOp == LogicalOp.OR) {
                        ListIterator listIterator = this.constraints.listIterator();
                        while (listIterator.hasNext()) {
                            if (constraint.constraints.contains(listIterator.next())) continue;
                            bl = false;
                            break;
                        }
                    } else if (this.groupOp == LogicalOp.AND) {
                        ListIterator listIterator = this.constraints.listIterator();
                        ListIterator listIterator2 = constraint.constraints.listIterator();
                        while (listIterator.hasNext() && listIterator2.hasNext()) {
                            Constraint constraint2;
                            Constraint constraint3 = (Constraint)listIterator.next();
                            if (constraint3.equals(constraint2 = (Constraint)listIterator2.next())) continue;
                            bl = false;
                            break;
                        }
                    } else {
                        throw new IllegalStateException("Broken IF-ELSE statement.");
                    }
                }
            }
        }
        return bl;
    }

    Object cloneAsNeeded(boolean bl) {
        return new ConstraintGroup(this, bl);
    }

    boolean isType() {
        return false;
    }

    public boolean canBeAppliedToMultipleParams() {
        Constraint constraint;
        boolean bl = false;
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext() && !(bl |= (constraint = (Constraint)listIterator.next()).canBeAppliedToMultipleParams())) {
        }
        return bl;
    }

    boolean isStateful() {
        Constraint constraint;
        boolean bl = false;
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext() && !(bl |= (constraint = (Constraint)listIterator.next()).isStateful())) {
        }
        return bl;
    }

    public List getTypes() {
        ArrayList<DataType> arrayList = new ArrayList<DataType>(this.constraints.size());
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext()) {
            Constraint constraint = (Constraint)listIterator.next();
            if (!constraint.isTyped()) continue;
            arrayList.add(constraint.getType());
        }
        if (arrayList.isEmpty()) {
            arrayList.add(DataType.ANY);
        }
        return arrayList;
    }

    boolean isTyped() {
        Constraint constraint;
        boolean bl = false;
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext() && !(bl |= (constraint = (Constraint)listIterator.next()).isTyped())) {
        }
        return bl;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }
}

