/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Lib;

public class DTDVersion
implements Comparable {
    public static final DTDVersion V1_0 = new DTDVersion("1.0", 0);
    public static final DTDVersion V1_1 = new DTDVersion("1.1", 1);
    public static final DTDVersion V2_0 = new DTDVersion("2.0", 2);
    public static final DTDVersion V3_0;
    public static final DTDVersion CURRENT;
    public static final DTDVersion UNKNOWN;
    public static final DTDVersion ILLEGAL;
    private static final int NO_OF_VERSIONS = 4;
    static final DTDVersion[] VERSIONS;
    private String version;
    private int weight;

    private DTDVersion(String string, int n) {
        this.version = string;
        this.weight = n;
    }

    static DTDVersion Lookup(String string) {
        for (int i = 0; i < VERSIONS.length; ++i) {
            if (!VERSIONS[i].equals(string)) continue;
            return VERSIONS[i];
        }
        return UNKNOWN;
    }

    String getValue() {
        return this.version;
    }

    int getWeight() {
        return this.weight;
    }

    public int compareTo(Object object) {
        Lib.CheckParam(object, "someVersion");
        DTDVersion dTDVersion = (DTDVersion)object;
        int n = dTDVersion.getWeight();
        if (this.weight < n) {
            return -1;
        }
        if (this.weight > n) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object.getClass() == String.class) {
            return this.equals((String)object);
        }
        return false;
    }

    public boolean equals(String string) {
        if (string == null) {
            return false;
        }
        return this.version.compareTo(string) == 0;
    }

    public String toString() {
        return this.version;
    }

    static {
        CURRENT = V3_0 = new DTDVersion("3.0", 3);
        UNKNOWN = new DTDVersion("unknown", Integer.MAX_VALUE);
        ILLEGAL = new DTDVersion("illegal", Integer.MAX_VALUE);
        VERSIONS = new DTDVersion[4];
        DTDVersion.VERSIONS[0] = V1_0;
        DTDVersion.VERSIONS[1] = V1_1;
        DTDVersion.VERSIONS[2] = V2_0;
        DTDVersion.VERSIONS[3] = V3_0;
    }
}

