/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Lib;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DataType {
    public static final DataType CHAR = new DataType("character");
    public static final DataType STRING;
    public static final DataType TRIMMED_STRING;
    public static final DataType SHORT;
    public static final DataType INT;
    public static final DataType LONG;
    public static final DataType FLOAT;
    public static final DataType DOUBLE;
    public static final DataType BOOLEAN;
    public static final DataType STRUCT;
    public static final DataType ANY;
    private String name;
    private String before;
    private Class type;
    private List promotableTo;

    private DataType(String string) {
        this.name = string;
        this.promotableTo = new LinkedList();
        this.promotableTo.add(this);
    }

    static boolean IsStringType(DataType dataType) {
        return dataType == STRING || dataType == CHAR;
    }

    static boolean IsEnumerativeType(DataType dataType) {
        return dataType != BOOLEAN;
    }

    private void setBeforeText(String string) {
        this.before = string;
    }

    private void addTypePromotion(DataType dataType) {
        this.promotableTo.add(dataType);
    }

    private void setJavaClass(Class clazz) {
        this.type = clazz;
    }

    public Class getJavaClass() {
        return this.type;
    }

    boolean isCompatible(List list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        return this.isCompatibleImpl(list);
    }

    boolean isCompatibleImpl(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (!this.isCompatibleImpl((DataType)iterator.next())) continue;
            return true;
        }
        return false;
    }

    boolean isCompatible(DataType dataType) {
        if (dataType == null) {
            return false;
        }
        return this.isCompatibleImpl(dataType);
    }

    boolean isCompatibleImpl(DataType dataType) {
        if (this.promotableTo.contains(dataType)) {
            return true;
        }
        Iterator iterator = this.promotableTo.iterator();
        while (iterator.hasNext()) {
            DataType dataType2 = (DataType)iterator.next();
            if (dataType2 == this || !dataType.isCompatibleImpl(dataType2)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    String toClause() {
        if (Lib.IsValue(this.before)) {
            return this.before + " " + this.name;
        }
        return this.name;
    }

    static {
        CHAR.setBeforeText("a");
        CHAR.setJavaClass(Character.class);
        STRING = new DataType("string");
        STRING.setBeforeText("a");
        STRING.setJavaClass(String.class);
        TRIMMED_STRING = new DataType("string");
        TRIMMED_STRING.setBeforeText("a");
        TRIMMED_STRING.setJavaClass(String.class);
        SHORT = new DataType("short");
        SHORT.setBeforeText("a");
        SHORT.setJavaClass(Short.class);
        INT = new DataType("integer");
        INT.setBeforeText("an");
        INT.setJavaClass(Integer.class);
        LONG = new DataType("long");
        LONG.setBeforeText("a");
        LONG.setJavaClass(Long.class);
        FLOAT = new DataType("float");
        FLOAT.setBeforeText("a");
        FLOAT.setJavaClass(Float.class);
        DOUBLE = new DataType("double");
        DOUBLE.setBeforeText("a");
        DOUBLE.setJavaClass(Double.class);
        BOOLEAN = new DataType("boolean");
        BOOLEAN.setBeforeText("a");
        BOOLEAN.setJavaClass(Boolean.class);
        STRUCT = new DataType("struct");
        ANY = new DataType("untyped");
        CHAR.addTypePromotion(STRING);
        CHAR.addTypePromotion(TRIMMED_STRING);
        SHORT.addTypePromotion(INT);
        INT.addTypePromotion(LONG);
        LONG.addTypePromotion(STRING);
        FLOAT.addTypePromotion(DOUBLE);
        DOUBLE.addTypePromotion(STRING);
        DOUBLE.addTypePromotion(TRIMMED_STRING);
    }
}

