/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.NDSVersion;
import com.novell.nds.dirxml.driver.xds.NonXDSElement;
import com.novell.nds.dirxml.driver.xds.ValidationLevel;
import com.novell.nds.dirxml.driver.xds.XDSDocument;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.DocumentFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentImpl
implements XDSDocument {
    protected static final ValidationLevel DEFAULT_WRITE_VALIDATION_LEVEL = ValidationLevel.STRICT;
    protected static final ValidationLevel DEFAULT_READ_VALIDATION_LEVEL = ValidationLevel.PERMISSIVE;
    protected XDSSourceElement source;
    Document document;
    Element ioElement;
    Element rootElement;
    int context;
    String tagName;
    ValidationLevel level;
    DTDVersion version;
    private String versionString;
    boolean validate;
    protected boolean commandContainer;
    private List children;

    DocumentImpl(String string) {
        this.init();
        this.setLevel(DEFAULT_READ_VALIDATION_LEVEL);
        this.document = new XmlDocument(string).getDocument();
        if (this.document == null) {
            if (this.validate) {
                throw new IllegalArgumentException("Document is either empty or malformed.");
            }
            return;
        }
        this.rootElement = this.document.getDocumentElement();
        this.context = 0;
    }

    DocumentImpl() {
        this.init();
        this.setLevel(DEFAULT_WRITE_VALIDATION_LEVEL);
        this.document = DocumentFactory.newDocument();
        this.context = 1;
    }

    protected DocumentImpl(Document document, String string, int n, ValidationLevel validationLevel) throws XDSParseException {
        Lib.CheckParam(validationLevel, "someLevel");
        this.init();
        this.setLevel(validationLevel);
        this.document = document;
        this.tagName = string;
        this.context = n;
        this.rootElement = this.parseElement("nds");
        this.ioElement = this.parseElement(string);
        this.parseVersion();
    }

    protected DocumentImpl(XmlDocument xmlDocument, String string, int n, ValidationLevel validationLevel) throws XDSParseException {
        Lib.CheckParam(xmlDocument, "xdsXML");
        Lib.CheckParam(validationLevel, "someLevel");
        this.init();
        this.document = xmlDocument.getDocument();
        if (this.document == null) {
            if (this.validate) {
                throw new RuntimeException("Document is either empty or malformed.");
            }
            return;
        }
        this.setLevel(validationLevel);
        this.tagName = string;
        this.context = n;
        this.rootElement = this.parseElement("nds");
        this.ioElement = this.parseElement(string);
        Element element = this.parseOptionalElement("source");
        this.source = element == null ? null : new XDSSourceElement(element, this);
        this.parseVersion();
    }

    DocumentImpl(String string, int n, NDSVersion nDSVersion, DTDVersion dTDVersion) {
        Lib.CheckParam(dTDVersion, "dtdVersion");
        this.init();
        this.setLevel(DEFAULT_WRITE_VALIDATION_LEVEL);
        this.document = DocumentFactory.newDocument();
        this.context = n;
        this.tagName = string;
        this.version = dTDVersion;
        this.rootElement = this.document.createElement("nds");
        if (this.LT(DTDVersion.V2_0)) {
            this.rootElement.setAttribute("ndsversion", nDSVersion.toString());
        }
        this.rootElement.setAttribute("dtdversion", dTDVersion.toString());
        this.document.appendChild(this.rootElement);
        this.ioElement = this.document.createElement(string);
        this.rootElement.appendChild(this.ioElement);
    }

    private void init() {
        this.children = Collections.EMPTY_LIST;
        this.commandContainer = false;
    }

    private void setValidate() {
        this.validate = this.level != ValidationLevel.NONE;
    }

    private void parseVersion() {
        this.versionString = Lib.ToNull(this.rootElement.getAttribute("dtdversion"));
        this.version = this.versionString == null ? DTDVersion.UNKNOWN : DTDVersion.Lookup(this.versionString);
    }

    protected boolean LT(DTDVersion dTDVersion) {
        return this.version.compareTo(dTDVersion) == -1;
    }

    protected boolean GTE(DTDVersion dTDVersion) {
        return this.version.compareTo(dTDVersion) != -1;
    }

    private Element parseOptionalElement(String string) {
        NodeList nodeList = this.document.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    private Element parseElement(String string) throws XDSParseException {
        NodeList nodeList = this.document.getElementsByTagName(string);
        int n = nodeList.getLength();
        if (n == 0 && this.validate) {
            throw new XDSParseException(Errors.NoElement(string));
        }
        if (n > 1 && this.validate) {
            throw new XDSParseException(Errors.DuplicateElement(string));
        }
        return (Element)nodeList.item(0);
    }

    int getContext() {
        return this.context;
    }

    ValidationLevel getLevel() {
        return this.level;
    }

    public Document domDocument() {
        return this.document;
    }

    public boolean isEmpty() {
        NodeList nodeList = this.ioElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 && node.getNodeType() != 3) continue;
            return false;
        }
        return true;
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        return null;
    }

    protected void handleUnrecognizedElement(Element element, String string, int n, int n2) throws XDSParseException {
        if (this.isStrict()) {
            throw new XDSParseException(Errors.IllegalElement(this.ioElement.getTagName(), string));
        }
        NonXDSElement nonXDSElement = this.commandContainer ? new NonXDSElement(element, this) : new NonXDSElement(element, this);
        nonXDSElement.setPosition(n);
        this.children(n2).add(nonXDSElement);
    }

    protected void parseChildNodes() throws XDSParseException {
        int n = 1;
        NodeList nodeList = this.ioElement.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            short s = nodeList.item(i).getNodeType();
            if (s == 1) {
                int n3;
                String string;
                Element element = (Element)nodeList.item(i);
                ElementImpl elementImpl = this.parseChildElement(element, string = element.getTagName(), n, n3 = n2 - i);
                if (elementImpl == null) {
                    this.handleUnrecognizedElement(element, string, n, n3);
                } else {
                    elementImpl.setPosition(n);
                    this.children(n3).add(elementImpl);
                }
                ++n;
                continue;
            }
            if (!this.isStrict()) continue;
            throw new XDSParseException(Errors.IllegalNode(this.ioElement.getTagName(), DOMUtil.describeNode((Node)nodeList.item(i))));
        }
    }

    public Element domNDSElement() {
        return this.rootElement;
    }

    public Element domIOElement() {
        return this.ioElement;
    }

    void setContext(int n) {
        this.context = n;
    }

    void setLevel(ValidationLevel validationLevel) {
        this.level = validationLevel;
        this.setValidate();
    }

    void setRootElement(Element element) {
        this.rootElement = element;
    }

    boolean isStrict() {
        return this.level == ValidationLevel.STRICT;
    }

    protected List children(int n) {
        if (this.children == Collections.EMPTY_LIST) {
            this.children = new ArrayList(n);
        }
        return this.children;
    }

    protected List childElements() {
        return Lib.GetElements(this, this.children);
    }
}

