/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public final class DynamicEnumConstraint
extends Constraint {
    Set enumParams;

    public DynamicEnumConstraint(Collection collection) {
        Lib.CheckParam(collection, "params");
        this.setEnumParams(collection);
        this.addConstraint(this);
    }

    public void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    private void setEnumParams(Collection collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("At least one parameter must be specified.");
        }
        DataType dataType = DataType.ANY;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (parameter == null) continue;
            if (parameter.isStructured()) {
                throw new IllegalArgumentException("Only scalar parameters can be specified.");
            }
            if (dataType == DataType.ANY) {
                dataType = parameter.getDataType();
            } else {
                DataType dataType2 = parameter.getDataType();
                if (!dataType.isCompatibleImpl(dataType2)) {
                    throw new IllegalArgumentException("Data type mismatch.  Parameters providing values for an enumerative constraints must be type compatible.  Parameter " + parameter.getParamInfo() + " of type '" + dataType2 + "' violates this principle.");
                }
            }
            this.enumParams.add(parameter);
        }
        this.setType(dataType);
    }

    void register(Parameter parameter) {
        if (this.registeredParams.contains(parameter)) {
            throw new IllegalArgumentException("This constraint cannot be applied to a parameter it also contains.");
        }
        super.register(parameter);
    }

    boolean isValidValue(Parameter parameter, Object object, Object[] objectArray) {
        return true;
    }

    Collection getParameters() {
        return this.enumParams;
    }

    String getLegalValues() {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.enumParams.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            Iterator iterator2 = parameter.toList().iterator();
            while (iterator2.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                boolean bl2 = DataType.IsStringType(parameter.getType());
                if (bl2) {
                    stringBuffer.append("'");
                }
                stringBuffer.append(iterator2.next());
                if (!bl2) continue;
                stringBuffer.append("'");
            }
        }
        return stringBuffer.toString();
    }

    boolean contains(Parameter parameter) {
        return this.enumParams.contains(parameter);
    }

    public int hashCode() {
        this.setConstant();
        int n = 0;
        Iterator iterator = this.enumParams.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            n += parameter.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DynamicEnumConstraint) {
            DynamicEnumConstraint dynamicEnumConstraint = (DynamicEnumConstraint)object;
            boolean bl2 = bl = this.enumParams.size() == dynamicEnumConstraint.enumParams.size();
            if (bl) {
                Iterator iterator = this.enumParams.iterator();
                while (iterator.hasNext()) {
                    Parameter parameter = (Parameter)iterator.next();
                    if (dynamicEnumConstraint.contains(parameter)) continue;
                    bl = false;
                    break;
                }
            }
        } else if (object instanceof ConstraintGroup) {
            ConstraintGroup constraintGroup = (ConstraintGroup)object;
            boolean bl3 = bl = constraintGroup.constraints.size() == 1;
            if (bl) {
                bl = this.equals(constraintGroup.constraints.get(0));
            }
        }
        return bl;
    }

    Object cloneAsNeeded(boolean bl) {
        return this;
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return false;
    }

    public boolean canBeAppliedToMultipleParams() {
        return false;
    }

    boolean isStateful() {
        return true;
    }

    boolean isIndependent() {
        return false;
    }

    boolean isSatisfied() {
        boolean bl = true;
        Parameter parameter = (Parameter)this.registeredParams.iterator().next();
        Iterator iterator = parameter.toList().iterator();
        block0: while (iterator.hasNext() && bl) {
            Object e = iterator.next();
            Iterator iterator2 = this.enumParams.iterator();
            while (iterator2.hasNext()) {
                Parameter parameter2 = (Parameter)iterator2.next();
                if (!parameter2.hasValue(e)) continue;
                continue block0;
            }
            bl = false;
            break;
        }
        return this.not ? !bl : bl;
    }
}

