/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Comparators;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class EnumConstraint
extends Constraint {
    public static final Comparator CASE_SENSITIVE = Comparators.STRING_SENSITIVE;
    public static final Comparator CASE_INSENSITIVE;
    private static final Comparator DEFAULT_COMP;
    private List values;
    private Comparator comparator;
    private boolean caseInsensitive;
    private int hashCode;
    private boolean hashCodeSet;

    public EnumConstraint() {
        this.setValues();
        this.setComparator(DEFAULT_COMP);
        this.addConstraint(this);
    }

    public EnumConstraint(Comparator comparator) {
        Lib.CheckParam(comparator, "someComparator");
        this.setValues();
        this.setComparator(comparator);
        this.addConstraint(this);
    }

    public void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    private void setCaseInsensitive() {
        this.caseInsensitive = this.comparator.compare("c", "C") == 0;
    }

    private void setValues() {
        this.values = new LinkedList();
    }

    public void setComparator(Comparator comparator) {
        this.checkConstant();
        Lib.CheckParam(comparator, "someComparator");
        Comparators.TestArgs(comparator, DataType.STRING);
        this.comparator = comparator;
        Collections.sort(this.values, this.comparator);
        this.setCaseInsensitive();
    }

    public void addLiteral(String string) {
        this.checkConstant();
        this.addValue(string);
    }

    private void addValue(String string) {
        int n;
        if (Lib.IsValue(string) && (n = Collections.binarySearch(this.values, string, this.comparator)) < 0) {
            n = -n - 1;
            this.values.add(n, string);
        }
    }

    public void addLiterals(String[] stringArray) {
        this.checkConstant();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addValue(stringArray[i]);
        }
    }

    boolean isValidValue(Parameter parameter, Object object, Object[] objectArray) {
        return object == null ? true : this.isValid(object.toString(), this.not);
    }

    private boolean isValid(String string, boolean bl) {
        return Collections.binarySearch(this.values, string) > -1 ? !bl : bl;
    }

    List getLiterals() {
        return this.values;
    }

    String getLegalValues() {
        StringBuffer stringBuffer = new StringBuffer(this.values.size() * 16);
        boolean bl = true;
        ListIterator listIterator = this.values.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" or ");
            }
            stringBuffer.append("'" + string + "'");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        if (this.hashCodeSet) {
            return this.hashCode;
        }
        String string = this.getLegalValues();
        if (this.caseInsensitive) {
            string = string.toUpperCase();
        }
        this.setConstant();
        this.hashCodeSet = true;
        this.hashCode = string.hashCode();
        return this.hashCode;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof EnumConstraint) {
            EnumConstraint enumConstraint = (EnumConstraint)object;
            if (((Object)this.comparator).equals(enumConstraint.comparator) && this.comparator.compare(this.getLegalValues(), enumConstraint.getLegalValues()) == 0) {
                bl = true;
            }
        } else if (object instanceof ConstraintGroup) {
            ConstraintGroup constraintGroup = (ConstraintGroup)object;
            boolean bl2 = bl = constraintGroup.constraints.size() == 1;
            if (bl) {
                bl = this.equals(constraintGroup.constraints.get(0));
            }
        }
        return bl;
    }

    Object cloneAsNeeded(boolean bl) {
        return this;
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return false;
    }

    public boolean canBeAppliedToMultipleParams() {
        return true;
    }

    boolean isStateful() {
        return false;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }

    static {
        DEFAULT_COMP = CASE_INSENSITIVE = Comparators.STRING_INSENSITIVE;
    }
}

