/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.Context;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib_1_4;
import com.novell.nds.dirxml.driver.xds.NonXDSElement;
import com.novell.nds.dirxml.driver.xds.ParamElement;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.TextParent;
import com.novell.nds.dirxml.driver.xds.ValueType;
import com.novell.nds.dirxml.driver.xds.XDS;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSException;
import com.novell.nds.dirxml.driver.xds.XDSInitParamsElement;
import com.novell.nds.dirxml.driver.xds.XDSInstanceElement;
import com.novell.nds.dirxml.driver.xds.XDSMethodInvocationContextException;
import com.novell.nds.dirxml.driver.xds.XDSModifyAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSPasswordElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryTokenElement;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.XDSValueElement;
import com.novell.nds.dirxml.driver.xds._Boolean;
import com.novell.nds.dirxml.driver.xds.util.Java;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class Lib {
    private static final String NO_VALUE = "_";

    Lib() {
    }

    static int NormalizeCompare(long l) {
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }

    static int NormalizeCompare(double d) {
        if (d < 0.0) {
            return -1;
        }
        if (d > 0.0) {
            return 1;
        }
        return 0;
    }

    static ElementImpl OptionsElement_parseChildElement(ElementImpl elementImpl, Element element, String string, int n, int n2, List[] listArray, List[] listArray2) throws XDSParseException {
        ElementImpl elementImpl2 = null;
        if ("instance".compareTo(string) == 0) {
            if (listArray2[0] == Collections.EMPTY_LIST) {
                listArray2[0] = new LinkedList();
            }
            elementImpl2 = new XDSInstanceElement(element, elementImpl.document);
            listArray2[0].add(elementImpl2);
        } else {
            if (listArray[0] == Collections.EMPTY_LIST) {
                listArray[0] = new ArrayList(n2);
            }
            elementImpl2 = new NonXDSElement(element, elementImpl.document);
            listArray[0].add(elementImpl2);
        }
        return elementImpl2;
    }

    static void ExtractParams(ElementImpl elementImpl, Map[] mapArray, List[] listArray, Map map) throws XDSParameterException {
        if (listArray != null) {
            Lib.ExtractParams(elementImpl, mapArray, listArray[0], map);
        }
    }

    static void ExtractParams(ElementImpl elementImpl, Map[] mapArray, List list, Map map) throws XDSParameterException {
        if (mapArray != null && list != null) {
            Lib.ParamParent_populateMap(elementImpl, mapArray, list);
            Lib.ExtractParams(mapArray[0], list, map);
        }
    }

    static void ExtractParams(Map map, List list, Map map2) throws XDSParameterException {
        Lib.CheckParam(map2, "params");
        XDSParameterException xDSParameterException = new XDSParameterException();
        if (Java.isJRE(1, 4)) {
            Lib_1_4.ExtractParams(list, map2, xDSParameterException);
        } else {
            Lib.ExtractParams_1_2(map, map2, xDSParameterException);
        }
        Lib.ApplyConstraints(map2, xDSParameterException);
        if (xDSParameterException.getNext() != null) {
            throw xDSParameterException.getNext();
        }
    }

    static XDSException ApplyConstraints(Map map, XDSException xDSException) {
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            for (Parameter parameter = (Parameter)iterator.next(); parameter != null; parameter = parameter.getNext()) {
                xDSException = parameter.applyConstraints(xDSException);
            }
        }
        return xDSException;
    }

    static void ExtractParams_1_2(Map map, Map map2, XDSException xDSException) {
        Iterator iterator = map2.values().iterator();
        while (iterator.hasNext()) {
            xDSException = Lib.ExtractParam_1_2(map, (Parameter)iterator.next(), xDSException);
        }
    }

    static XDSException ExtractParam_1_2(Map map, Parameter parameter, XDSException xDSException) {
        ParamElement paramElement = (ParamElement)map.get(parameter.tagName());
        if (paramElement != null) {
            parameter.setParamElement(paramElement);
            parameter.setDisplayName(paramElement.getDisplayName());
            parameter.setValue(paramElement.extractText());
        }
        return xDSException;
    }

    static ElementImpl StateElement_parseChildElement(ElementImpl elementImpl, Element element, String string, int n, int n2, List[] listArray) throws XDSParseException {
        NonXDSElement nonXDSElement = new NonXDSElement(element, elementImpl.document);
        if (listArray[0] == Collections.EMPTY_LIST) {
            listArray[0] = new ArrayList(n2);
        }
        listArray[0].add(nonXDSElement);
        return nonXDSElement;
    }

    private static void ParamParent_populateMap(ElementImpl elementImpl, Map[] mapArray, List list) throws XDSParameterException {
        if (mapArray[0] == XDS.EMPTY_MAP && list.size() > 0) {
            mapArray[0] = new HashMap(list.size());
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                ParamElement paramElement = (ParamElement)listIterator.next();
                ParamElement paramElement2 = mapArray[0].put(paramElement.tagName(), paramElement);
                if (paramElement2 == null) continue;
                throw new XDSParameterException(Errors.DuplicateParam(elementImpl.tagName(), paramElement.tagName()));
            }
        }
    }

    static ParamElement ParamParent_paramElement(ElementImpl elementImpl, Map[] mapArray, List[] listArray, String string) throws XDSParameterException {
        if (listArray == null) {
            return null;
        }
        return Lib.ParamParent_paramElement(elementImpl, mapArray, listArray[0], string);
    }

    static ParamElement ParamParent_paramElement(ElementImpl elementImpl, Map[] mapArray, List list, String string) throws XDSParameterException {
        ParamElement paramElement;
        if (mapArray == null) {
            paramElement = null;
        } else {
            Lib.ParamParent_populateMap(elementImpl, mapArray, list);
            paramElement = (ParamElement)mapArray[0].get(string);
        }
        return paramElement;
    }

    static String ParamParent_paramText(ElementImpl elementImpl, Map[] mapArray, List[] listArray, String string) throws XDSParameterException {
        if (listArray == null) {
            return null;
        }
        return Lib.ParamParent_paramText(elementImpl, mapArray, listArray[0], string);
    }

    static String ParamParent_paramText(ElementImpl elementImpl, Map[] mapArray, List list, String string) throws XDSParameterException {
        ParamElement paramElement = Lib.ParamParent_paramElement(elementImpl, mapArray, list, string);
        return paramElement == null ? null : paramElement.extractText();
    }

    static String GetText(ElementImpl elementImpl, TextParent textParent) {
        if (textParent == null) {
            return null;
        }
        return textParent.extractText();
    }

    static boolean GetValue(ElementImpl elementImpl, _Boolean _Boolean2) {
        if (_Boolean2 == null) {
            return false;
        }
        return _Boolean2.toPrimitive();
    }

    static String GetValue(ElementImpl elementImpl, String string) {
        return string;
    }

    static String GetAttributeValue(ElementImpl elementImpl, String string) {
        return elementImpl.attributeValueGet(string);
    }

    static void CheckParam(String string, String string2) {
        if (string == null || "".compareTo(string) == 0) {
            throw new IllegalArgumentException(Errors.NoParamValue(string2));
        }
    }

    public static String ToNull(String string) {
        if (Lib.NoValue(string)) {
            return null;
        }
        return string;
    }

    static boolean IsParamValue(String string) {
        return Lib.IsValue(string) && NO_VALUE.compareTo(string) != 0;
    }

    static boolean NoParamValue(String string) {
        return Lib.NoValue(string) || NO_VALUE.compareTo(string) == 0;
    }

    static boolean IsValue(String string) {
        return string != null && "".compareTo(string) != 0;
    }

    static boolean NoValue(String string) {
        return string == null || "".compareTo(string) == 0;
    }

    static void CheckParam(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(Errors.NoParamValue(string));
        }
    }

    static void AssociationElementParent_validate(ElementImpl elementImpl, XDSAssociationElement xDSAssociationElement, int n, boolean bl) throws XDSParseException {
        if (xDSAssociationElement != null) {
            if (n > 1) {
                throw new XDSParseException(Errors.DuplicateElement("association"));
            }
            if (elementImpl.document.isStrict() && xDSAssociationElement.position() != 1) {
                throw new XDSParseException(Errors.MisplacedElement(elementImpl.tagName(), "association", 1));
            }
        }
    }

    static XDSAssociationElement AssociationElementParent_appendAssociationElement(ElementImpl elementImpl, String string) {
        XDSAssociationElement xDSAssociationElement = new XDSAssociationElement(elementImpl.document, elementImpl.element);
        xDSAssociationElement.appendText(string);
        return xDSAssociationElement;
    }

    static XDSAssociationElement AssociationElementParent_associationElement(ElementImpl elementImpl, XDSAssociationElement xDSAssociationElement) {
        return xDSAssociationElement;
    }

    static String TextParent_extractText(ElementImpl elementImpl, TextParent textParent) {
        if (textParent == null) {
            return null;
        }
        return textParent.extractText();
    }

    static void CheckVersion(DTDVersion dTDVersion, DTDVersion dTDVersion2) {
        if (dTDVersion.compareTo(dTDVersion2) == -1) {
            throw new XDSMethodInvocationContextException(Errors.WrongDTDVersion(dTDVersion2.toString()));
        }
    }

    static void CheckContext(int n, int n2) {
        if (n != n2) {
            throw new XDSMethodInvocationContextException(Errors.WrongContext(Context.ToString(n2)));
        }
    }

    static List GetElements(DocumentImpl documentImpl, List list) {
        return list;
    }

    static List GetElements(DocumentImpl documentImpl, List[] listArray) {
        if (listArray == null) {
            return Collections.EMPTY_LIST;
        }
        return Lib.GetElements(documentImpl, listArray[0]);
    }

    static List GetElements(ElementImpl elementImpl, List list) {
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    static List GetElements(ElementImpl elementImpl, List[] listArray) {
        if (listArray == null) {
            return Collections.EMPTY_LIST;
        }
        return Lib.GetElements(elementImpl, listArray[0]);
    }

    static List ValueElementParent_extractValueElements(ElementImpl elementImpl, List[] listArray) {
        if (listArray == null) {
            return Collections.EMPTY_LIST;
        }
        return listArray[0];
    }

    static XDSValueElement ValueElementParent_appendValueElement(ElementImpl elementImpl, ValueType valueType, String string) {
        XDSValueElement xDSValueElement = new XDSValueElement(elementImpl.document, elementImpl.element, valueType);
        if (string != null) {
            xDSValueElement.appendText(string);
        }
        return xDSValueElement;
    }

    static ElementImpl ValueElementParent_parseChildElement(ElementImpl elementImpl, Element element, String string, int n, List[] listArray) throws XDSParseException {
        XDSValueElement xDSValueElement = null;
        if ("value".compareTo(string) == 0) {
            xDSValueElement = new XDSValueElement(element, elementImpl.document);
            if (listArray[0] == Collections.EMPTY_LIST) {
                listArray[0] = new ArrayList(n);
            }
            listArray[0].add(xDSValueElement);
        }
        return xDSValueElement;
    }

    static void ValueElementsParent_validate(ElementImpl elementImpl) throws XDSParseException {
        if (elementImpl.children() == Collections.EMPTY_LIST) {
            throw new XDSParseException(Errors.NoElement("value"));
        }
    }

    static void TextParent_appendText(ElementImpl elementImpl, String string) {
        if (Lib.NoValue(string)) {
            return;
        }
        Text text = elementImpl.document.document.createTextNode(string);
        elementImpl.element.appendChild(text);
    }

    static String TextParent_text(ElementImpl elementImpl, String string) {
        return Lib.ToNull(string);
    }

    static String SomeAttrElement_getAttrName(ElementImpl elementImpl, String string) {
        return string;
    }

    static void SomeAttrElement_setAttrName(ElementImpl elementImpl, String string) {
        elementImpl.attributeValueSet("attr-name", string);
    }

    static void SomeAttrElement_validate(ElementImpl elementImpl, String string) throws XDSParseException {
        if (string == null) {
            elementImpl.throwMissingAttributeException("attr-name");
        }
    }

    static XmlDocument WriteableDocument_toXML(DocumentImpl documentImpl) {
        return new XmlDocument(documentImpl.document);
    }

    static XDSModifyAssociationElement WriteableDocument_appendModifyAssociationElement(DocumentImpl documentImpl) {
        return new XDSModifyAssociationElement(documentImpl, documentImpl.ioElement);
    }

    static XDSInitParamsElement StateDocument_appendInitParamsElement(DocumentImpl documentImpl, XDSInitParamsElement[] xDSInitParamsElementArray) {
        if (xDSInitParamsElementArray[0] == null) {
            xDSInitParamsElementArray[0] = new XDSInitParamsElement(documentImpl, documentImpl.ioElement);
        }
        return xDSInitParamsElementArray[0];
    }

    static XDSSourceElement WriteableDocument_appendSourceElement(DocumentImpl documentImpl, XDSSourceElement xDSSourceElement) {
        if (xDSSourceElement == null) {
            xDSSourceElement = new XDSSourceElement(documentImpl, documentImpl.rootElement);
            Element element = xDSSourceElement.domElement();
            documentImpl.rootElement.removeChild(element);
            documentImpl.rootElement.insertBefore(element, documentImpl.ioElement);
        }
        return xDSSourceElement;
    }

    static XDSStatusElement StatusDocument_appendHeartbeat(DocumentImpl documentImpl) {
        XDSStatusElement xDSStatusElement = Lib.StatusDocument_appendStatusElement(documentImpl);
        xDSStatusElement.setLevel(StatusLevel.SUCCESS);
        xDSStatusElement.setType(StatusType.HEARTBEAT);
        return xDSStatusElement;
    }

    static XDSStatusElement StatusDocument_appendStatusElement(DocumentImpl documentImpl) {
        return new XDSStatusElement(documentImpl, documentImpl.ioElement);
    }

    static void WriteableDocument_setEmpty(DocumentImpl documentImpl) {
        Element element = documentImpl.document.createElement(documentImpl.tagName);
        documentImpl.rootElement.replaceChild(element, documentImpl.ioElement);
        documentImpl.ioElement = element;
    }

    static void CommandElement_setEventID(ElementImpl elementImpl, String string) {
        elementImpl.attributeValueSet("event-id", string);
    }

    static String CommandElement_getEventID(ElementImpl elementImpl) {
        return elementImpl.attributeValueGet("event-id");
    }

    static String CommandElement_getSrcDN(ElementImpl elementImpl) {
        return elementImpl.attributeValueGet("src-dn");
    }

    static String CommandElement_getQualifiedSrcDN(ElementImpl elementImpl) {
        return elementImpl.attributeValueGet("qualified-src-dn");
    }

    static String CommandElement_getSrcEntryID(ElementImpl elementImpl) {
        return elementImpl.attributeValueGet("src-entry-id");
    }

    static String CommandElement_getClassName(ElementImpl elementImpl) {
        return elementImpl.attributeValueGet("class-name");
    }

    static XDSPasswordElement PasswordElementParent_passwordElement(ElementImpl elementImpl, XDSPasswordElement xDSPasswordElement) {
        return xDSPasswordElement;
    }

    static String PasswordElementParent_passwordText(ElementImpl elementImpl, XDSPasswordElement xDSPasswordElement) {
        return Lib.GetText(elementImpl, xDSPasswordElement);
    }

    static DTDVersion ReadableDocument_dtdVersion(DocumentImpl documentImpl) {
        return documentImpl.version;
    }

    static XDSSourceElement ReadableDocument_sourceElement(DocumentImpl documentImpl) {
        return documentImpl.source;
    }

    static void QueryResultDocument_Sort(Map map) {
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Collections.sort(list);
        }
    }

    private static void QueryResultDocument_PopulateMap(Map[] mapArray, List list) {
        if (mapArray[0] == XDS.EMPTY_MAP) {
            mapArray[0] = new HashMap(list.size());
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                XDSStatusElement xDSStatusElement = (XDSStatusElement)listIterator.next();
                String string = xDSStatusElement.getEventID();
                if (string == null) continue;
                LinkedList<XDSStatusElement> linkedList = (LinkedList<XDSStatusElement>)mapArray[0].get(string);
                if (linkedList == null) {
                    linkedList = new LinkedList<XDSStatusElement>();
                    linkedList.add(xDSStatusElement);
                    mapArray[0].put(string, linkedList);
                    continue;
                }
                linkedList.add(xDSStatusElement);
            }
            Lib.QueryResultDocument_Sort(mapArray[0]);
        }
    }

    public static StatusLevel ResultDocument_mostSevereStatusLevel(DocumentImpl documentImpl, String string, Map[] mapArray, List[] listArray, XDSStatusElement[] xDSStatusElementArray) {
        XDSStatusElement xDSStatusElement = Lib.ResultDocument_mostSevereStatusElement(documentImpl, string, mapArray, listArray, xDSStatusElementArray);
        return xDSStatusElement == null ? StatusLevel.SUCCESS : xDSStatusElement.getLevel();
    }

    static List QueryResultDocument_extractQueryTokenElements(DocumentImpl documentImpl, List[] listArray) {
        if (listArray != null && listArray[0] != null && !listArray[0].isEmpty()) {
            return listArray[0];
        }
        return Collections.EMPTY_LIST;
    }

    static boolean QueryResultDocument_containsQueryTokenElements(DocumentImpl documentImpl, List[] listArray) {
        if (listArray == null || listArray[0] == null) {
            return false;
        }
        return !listArray[0].isEmpty();
    }

    static boolean QueryResultDocument_containsQueryToken(DocumentImpl documentImpl, List[] listArray, String string) {
        boolean bl = false;
        if (listArray != null && listArray[0] != null && string != null) {
            Iterator iterator = listArray[0].iterator();
            while (iterator.hasNext()) {
                XDSQueryTokenElement xDSQueryTokenElement = (XDSQueryTokenElement)iterator.next();
                String string2 = xDSQueryTokenElement.extractText();
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    static XDSStatusElement ResultDocument_mostSevereStatusElement(DocumentImpl documentImpl, String string, Map[] mapArray, List[] listArray, XDSStatusElement[] xDSStatusElementArray) {
        XDSStatusElement xDSStatusElement = null;
        if (mapArray != null && listArray != null && xDSStatusElementArray != null && listArray[0] != null) {
            Lib.QueryResultDocument_PopulateMap(mapArray, listArray[0]);
            List list = (List)mapArray[0].get(string);
            xDSStatusElement = list != null && !list.isEmpty() ? (XDSStatusElement)list.get(0) : xDSStatusElementArray[0];
        }
        return xDSStatusElement;
    }

    static List QueryResultDocument_extractStatusElements(DocumentImpl documentImpl, Map[] mapArray, List[] listArray, String string) {
        List list = Collections.EMPTY_LIST;
        if (mapArray != null && listArray != null && listArray[0] != null) {
            Lib.QueryResultDocument_PopulateMap(mapArray, listArray[0]);
            List list2 = (List)mapArray[0].get(string);
            if (list2 != null) {
                list = list2;
            }
        }
        return list;
    }

    static ElementImpl QueryResultDocument_parseChildElement(DocumentImpl documentImpl, Element element, String string, int n, int n2, List[] listArray, List[] listArray2, XDSStatusElement[] xDSStatusElementArray, List[] listArray3) throws XDSParseException {
        ElementImpl elementImpl = null;
        if ("status".compareTo(string) == 0) {
            elementImpl = new XDSStatusElement(element, documentImpl);
            if (xDSStatusElementArray[0] == null) {
                xDSStatusElementArray[0] = elementImpl;
            } else {
                ElementImpl elementImpl2 = xDSStatusElementArray[0] = xDSStatusElementArray[0].compareTo(elementImpl) == 1 ? elementImpl : xDSStatusElementArray[0];
            }
            if (listArray[0] == Collections.EMPTY_LIST) {
                listArray[0] = new LinkedList();
            }
            listArray[0].add(elementImpl);
        } else if ("instance".compareTo(string) == 0) {
            if (listArray2[0] == Collections.EMPTY_LIST) {
                listArray2[0] = new LinkedList();
            }
            elementImpl = new XDSInstanceElement(element, documentImpl);
            listArray2[0].add(elementImpl);
        } else if ("query-token".compareTo(string) == 0) {
            if (listArray3[0] == Collections.EMPTY_LIST) {
                listArray3[0] = new LinkedList();
            }
            elementImpl = new XDSQueryTokenElement(element, documentImpl);
            listArray3[0].add(elementImpl);
        }
        return elementImpl;
    }

    static Node CloneSubtree(Document document, Node node) {
        try {
            switch (node.getNodeType()) {
                case 1: {
                    Element element = (Element)node;
                    Element element2 = document.createElement(element.getNodeName());
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        Attr attr = (Attr)namedNodeMap.item(i);
                        element2.setAttribute(attr.getName(), attr.getValue());
                    }
                    NodeList nodeList = element.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        element2.appendChild(Lib.CloneSubtree(document, nodeList.item(i)));
                    }
                    return element2;
                }
                case 2: {
                    Attr attr = document.createAttribute(((Attr)node).getName());
                    attr.setValue(((Attr)node).getValue());
                    return attr;
                }
                case 3: {
                    return document.createTextNode(((Text)node).getData());
                }
                case 4: {
                    return document.createCDATASection(((CDATASection)node).getData());
                }
                case 5: {
                    return document.createEntityReference(node.getNodeName());
                }
                case 7: {
                    return document.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                }
                case 8: {
                    return document.createComment(node.getNodeValue());
                }
                case 11: {
                    DocumentFragment documentFragment = document.createDocumentFragment();
                    NodeList nodeList = node.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        documentFragment.appendChild(Lib.CloneSubtree(document, nodeList.item(i)));
                    }
                    return documentFragment;
                }
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return null;
    }

    static XDSInstanceElement QueryResultDocument_appendInstanceElement(DocumentImpl documentImpl) {
        return new XDSInstanceElement(documentImpl, documentImpl.ioElement);
    }

    static XDSQueryTokenElement QueryTokenParent_appendQueryTokenElement(DocumentImpl documentImpl, Element element, String string) {
        XDSQueryTokenElement xDSQueryTokenElement = new XDSQueryTokenElement(documentImpl, element);
        xDSQueryTokenElement.appendText(string);
        return xDSQueryTokenElement;
    }

    static String ParamElement_getDisplayName(ElementImpl elementImpl) {
        return elementImpl.attributeValueGet("display-name");
    }

    static boolean ParamElement_isContentSensitive(ElementImpl elementImpl) {
        return "true".equals(elementImpl.attributeValueGet("is-sensitive"));
    }

    static boolean ParamElement_isPasswordRef(ElementImpl elementImpl) {
        return "password-ref".equals(elementImpl.attributeValueGet("type"));
    }

    static boolean ParamElement_hasContent(ElementImpl elementImpl) {
        return elementImpl.element.getChildNodes().getLength() > 0;
    }

    static boolean AreEquivalent(Parameter parameter, Parameter parameter2, boolean bl) {
        boolean bl2 = false;
        if (parameter != null && parameter2 != null) {
            boolean bl3 = bl2 = parameter.getType() == parameter2.getType();
            if (bl2 && bl) {
                boolean bl4 = bl2 = parameter.getNumConstraints() == parameter2.getNumConstraints();
                if (bl2) {
                    Iterator iterator = parameter.getConstraints().iterator();
                    while (iterator.hasNext()) {
                        Constraint constraint = (Constraint)iterator.next();
                        if (parameter2.hasConstraint(constraint)) continue;
                        bl2 = false;
                        break;
                    }
                }
            }
        }
        return bl2;
    }
}

