/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ParamElement;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.RegExConstraint;
import com.novell.nds.dirxml.driver.xds.XDSException;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

class Lib_1_4 {
    Lib_1_4() {
    }

    static XDSException ExtractParams(List list, Map map, XDSException xDSException) {
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            xDSException = Lib_1_4.ExtractParam(list, (Parameter)iterator.next(), xDSException);
        }
        return xDSException;
    }

    private static XDSException ExtractParam(List list, Parameter parameter, XDSException xDSException) {
        ParamElement paramElement;
        Pattern pattern = parameter.isStructured() ? Pattern.compile(parameter.matchRegEx() + ".*") : Pattern.compile(parameter.matchRegEx());
        ArrayList<ParamElement> arrayList = new ArrayList<ParamElement>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            paramElement = (ParamElement)iterator.next();
            if (!pattern.matcher(paramElement.tagName()).matches()) continue;
            arrayList.add(paramElement);
        }
        if (arrayList.isEmpty()) {
            return xDSException;
        }
        if (parameter.isStructured() || parameter.isMultiValued()) {
            if (parameter.isStructured()) {
                if (parameter.isSingleValued()) {
                    xDSException = Lib_1_4.FilterMatches(arrayList, parameter, xDSException);
                    xDSException = Lib_1_4.ExtractParams(arrayList, parameter.getParameterMap(), xDSException);
                } else {
                    int n = Integer.MIN_VALUE;
                    ArrayList<ParamElement> arrayList2 = null;
                    iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        paramElement = (ParamElement)iterator.next();
                        if (n == Integer.MIN_VALUE) {
                            n = Lib_1_4.GetInstanceID(paramElement, Pattern.compile(parameter.instanceRegEx()));
                            if (n == Integer.MIN_VALUE) {
                                XDSParameterException xDSParameterException = new XDSParameterException("Parameter " + parameter.getParamInfo() + " has an element with an illegal instance id " + n + ".  Instance ids must be non-negative integers.");
                                xDSException.setNextException(xDSParameterException);
                                xDSException = xDSParameterException;
                            } else {
                                pattern = n > -1 ? Pattern.compile(parameter.instanceRegEx() + '_' + n + "(?!\\d).*") : Pattern.compile(parameter.instanceRegEx() + "(\\..*|$)");
                                parameter.setInstanceID(n);
                                parameter.addParamElement(paramElement);
                                arrayList2 = new ArrayList<ParamElement>(arrayList.size());
                                arrayList2.add(paramElement);
                            }
                            iterator.remove();
                        } else if (pattern.matcher(paramElement.tagName()).matches()) {
                            parameter.addParamElement(paramElement);
                            arrayList2.add(paramElement);
                            iterator.remove();
                        }
                        if (iterator.hasNext()) continue;
                        xDSException = Lib_1_4.ExtractParams(arrayList2, parameter.getParameterMap(), xDSException);
                        if (arrayList.isEmpty()) continue;
                        Parameter parameter2 = (Parameter)parameter.cloneInstance(true);
                        parameter.setNext(parameter2);
                        parameter = parameter2;
                        iterator = arrayList.iterator();
                        n = Integer.MIN_VALUE;
                    }
                }
            } else {
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    paramElement = (ParamElement)iterator.next();
                    parameter.addParamElement(paramElement);
                    if (parameter.getDisplayName() == null) {
                        parameter.setDisplayName(paramElement.getDisplayName());
                    }
                    parameter.addValue(paramElement.extractText());
                }
            }
        } else {
            XDSParameterException xDSParameterException;
            int n = Integer.MIN_VALUE;
            iterator = arrayList.iterator();
            if (arrayList.size() > 1) {
                xDSParameterException = new XDSParameterException("Single-valued, non-structured parameters should consist of at most one element.  Parameter " + parameter.getParamInfo() + " consists of " + arrayList.size() + " elements.");
                xDSException.setNextException(xDSParameterException);
                xDSException = xDSParameterException;
            }
            if ((n = Lib_1_4.GetInstanceID(paramElement = (ParamElement)iterator.next(), Pattern.compile(parameter.instanceRegEx()))) == Integer.MIN_VALUE) {
                xDSParameterException = new XDSParameterException("Parameter " + parameter.getParamInfo() + " has an element '" + paramElement.tagName() + "' with illegal instance id " + n + ".  Instance ids must be non-negative integers.");
                xDSException.setNextException(xDSParameterException);
                xDSException = xDSParameterException;
            } else {
                parameter.setInstanceID(n);
                parameter.setParamElement(paramElement);
                String string = paramElement.getDisplayName();
                if (string != null) {
                    parameter.setDisplayName(string);
                }
                parameter.setValue(paramElement.extractText());
            }
        }
        return xDSException;
    }

    private static XDSException FilterMatches(List list, Parameter parameter, XDSException xDSException) {
        Pattern pattern = Pattern.compile(parameter.instanceRegEx());
        int n = -1;
        int n2 = Integer.MIN_VALUE;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            XDSParameterException xDSParameterException;
            ParamElement paramElement = (ParamElement)iterator.next();
            n = Lib_1_4.GetInstanceID(paramElement, pattern);
            if (n == Integer.MIN_VALUE) {
                xDSParameterException = new XDSParameterException("Parameter " + parameter.getParamInfo() + " contains an element '" + paramElement.tagName() + "' with an illegal instance id.  " + "Instance ids must be non-negative integers.");
                xDSException.setNextException(xDSParameterException);
                xDSException = xDSParameterException;
                iterator.remove();
                continue;
            }
            if (n2 == Integer.MIN_VALUE) {
                n2 = n;
                continue;
            }
            if (n == n2) continue;
            xDSParameterException = n2 == -1 ? new XDSParameterException("Single-valued, structured parameter elements must have the same instance id.  Element '" + paramElement.tagName() + "' of parameter " + parameter.getParamInfo() + " should NOT have an instance id.") : new XDSParameterException("Single-valued, structured parameter elements must have the same instance id.  Element '" + paramElement.tagName() + "' of parameter " + parameter.getParamInfo() + " should have instance id " + n2 + ".");
            xDSException.setNextException(xDSParameterException);
            xDSException = xDSParameterException;
            iterator.remove();
        }
        if (n2 > -1) {
            parameter.setInstanceID(n2);
        }
        return xDSException;
    }

    private static int GetInstanceID(ParamElement paramElement, Pattern pattern) {
        int n = -1;
        String[] stringArray = pattern.split(paramElement.tagName(), 2);
        if (stringArray.length > 1) {
            n = Lib_1_4.ParseInstanceID(stringArray[1]);
        }
        return n;
    }

    private static int ParseInstanceID(String string) {
        int n = -1;
        if (string != null && string.length() > 0) {
            int n2 = string.charAt(0) == '_' ? 1 : 0;
            int n3 = string.indexOf(".");
            if (n3 == -1) {
                n3 = string.length();
            }
            if (n2 == n3) {
                if (n2 == 1) {
                    n = Integer.MIN_VALUE;
                }
            } else {
                try {
                    n = Integer.parseInt(string.substring(n2, n3));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    n = Integer.MIN_VALUE;
                }
            }
        }
        return n;
    }

    static Constraint newCaseInsensitiveRegExConstraint(String string) {
        RegExConstraint regExConstraint = new RegExConstraint(string, 66);
        return regExConstraint;
    }
}

