/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Iterator;

public class MultiRequiredConstraint
extends Constraint {
    private boolean applied;

    public MultiRequiredConstraint() {
        this.setRequired();
        this.setNOT();
        this.addConstraint(this);
        this.applied = false;
    }

    boolean isValidValue(Parameter parameter, Object object, Object[] objectArray) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isSatisfied() {
        boolean bl;
        if (this.applied) {
            return true;
        }
        if (this.groupOp == LogicalOp.OR) {
            bl = false;
        } else {
            if (this.groupOp != LogicalOp.AND) throw new RuntimeException("Broken IF-ELSE.");
            bl = true;
        }
        Iterator iterator = this.registeredParams.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (parameter.getDataType() == DataType.ANY) {
                if (this.groupOp == LogicalOp.OR) {
                    bl |= parameter.hasContent();
                } else {
                    if (this.groupOp != LogicalOp.AND) throw new RuntimeException("Broken IF-ELSE.");
                    bl &= parameter.hasContent();
                }
            } else if (parameter.isStructured()) {
                if (this.groupOp == LogicalOp.OR) {
                    bl |= parameter.isSet();
                } else {
                    if (this.groupOp != LogicalOp.AND) throw new RuntimeException("Broken IF-ELSE.");
                    bl &= parameter.isSet();
                }
            } else if (this.groupOp == LogicalOp.OR) {
                bl |= parameter.hasValues();
            } else {
                if (this.groupOp != LogicalOp.AND) throw new RuntimeException("Broken IF-ELSE.");
                bl &= parameter.hasValues();
            }
            if (this.groupOp != LogicalOp.AND || bl) continue;
        }
        this.applied = true;
        return bl;
    }

    public void setOperator(LogicalOp logicalOp) {
        this.checkConstant();
        if (logicalOp != null) {
            this.groupOp = logicalOp;
        }
    }

    String getLegalValues() {
        return "null, '' (empty string)";
    }

    public int hashCode() {
        return HASH_GLOBAL_REQUIRED;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof MultiRequiredConstraint) {
            bl = true;
        } else if (object instanceof ConstraintGroup) {
            ConstraintGroup constraintGroup = (ConstraintGroup)object;
            boolean bl2 = bl = constraintGroup.constraints.size() == 1;
            if (bl) {
                bl = this.equals(constraintGroup.constraints.get(0));
            }
        }
        return bl;
    }

    Object cloneAsNeeded(boolean bl) {
        throw new IllegalStateException("MultiRequiredConstraints constraints cannot be cloned.");
    }

    public boolean forStructured() {
        return true;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return false;
    }

    public boolean canBeAppliedToMultipleParams() {
        return true;
    }

    boolean isStateful() {
        return true;
    }

    boolean isIndependent() {
        return false;
    }
}

