/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Comparators;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Maps;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public final class MultiUniqueConstraint
extends Constraint {
    private Comparator comparator;
    private Set values;

    public MultiUniqueConstraint(DataType dataType, Comparator comparator) {
        Lib.CheckParam(dataType, "someType");
        this.setType(dataType);
        this.setComparator(comparator);
        this.setValues();
        this.setNOT();
        this.setOperator(LogicalOp.AND);
        this.addConstraint(this);
    }

    public MultiUniqueConstraint(DataType dataType) {
        this.setType(dataType);
        this.setComparator(null);
        this.setValues();
        this.setNOT();
        this.setOperator(LogicalOp.AND);
        this.addConstraint(this);
    }

    protected void setType(DataType dataType) {
        if (dataType == DataType.STRUCT) {
            throw new IllegalArgumentException("Type 'struct' is not supported.");
        }
        if (dataType == DataType.ANY) {
            throw new IllegalArgumentException("Type 'any' is not supported.");
        }
        super.setType(dataType);
    }

    private void setValues() {
        this.values = new TreeSet(this.comparator);
    }

    private void setComparator(Comparator comparator) {
        if (comparator == null) {
            comparator = Maps.GetComparator(this.getType());
        }
        if (!Comparators.TestArgs(comparator, this.getType())) {
            throw new IllegalArgumentException("Passed comparator does not accept arguments of type '" + this.getType().getJavaClass().getName() + "'.");
        }
        this.comparator = comparator;
    }

    boolean isValidValue(Parameter parameter, Object object, Object[] objectArray) {
        return object == null || this.values.add(object);
    }

    String getLegalValues() {
        StringBuffer stringBuffer = new StringBuffer(this.values.size() * 16);
        boolean bl = true;
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            if (DataType.IsStringType(this.getType())) {
                stringBuffer.append("'");
            }
            stringBuffer.append(string);
            if (!DataType.IsStringType(this.getType())) continue;
            stringBuffer.append("'");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.comparator.hashCode();
    }

    Comparator getComparator() {
        return this.comparator;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof MultiUniqueConstraint) {
            MultiUniqueConstraint multiUniqueConstraint = (MultiUniqueConstraint)object;
            bl = this.getType() == multiUniqueConstraint.getType() && ((Object)this.comparator).equals(multiUniqueConstraint.comparator);
        } else if (object instanceof ConstraintGroup) {
            ConstraintGroup constraintGroup = (ConstraintGroup)object;
            boolean bl2 = bl = constraintGroup.constraints.size() == 1;
            if (bl) {
                bl = this.equals(constraintGroup.constraints.get(0));
            }
        }
        return bl;
    }

    Object cloneAsNeeded(boolean bl) {
        throw new IllegalStateException("MultiUniqueConstraints constraints cannot be cloned.");
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return false;
    }

    public boolean canBeAppliedToMultipleParams() {
        return true;
    }

    boolean isStateful() {
        return true;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }
}

