/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.Constraints;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.EnumConstraint;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Maps;
import com.novell.nds.dirxml.driver.xds.MultiRequiredConstraint;
import com.novell.nds.dirxml.driver.xds.MultiUniqueConstraint;
import com.novell.nds.dirxml.driver.xds.MultiValueConstraint;
import com.novell.nds.dirxml.driver.xds.ParamElement;
import com.novell.nds.dirxml.driver.xds.SingleValueConstraint;
import com.novell.nds.dirxml.driver.xds.XDS;
import com.novell.nds.dirxml.driver.xds.XDSException;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import com.novell.nds.dirxml.driver.xds.util.Java;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class Parameter
implements Comparable,
Cloneable {
    private static final boolean DEFAULT_REQUIRED = false;
    private static final boolean DEFAULT_CONSTANT = false;
    private static final LogicalOp OP = LogicalOp.AND;
    public static int INSTANCE_ID_NONE = -1;
    private String tagName;
    private String displayName;
    private DataType type;
    private List values;
    private StringBuffer _buffer;
    private List constraints;
    private Set constraintSet;
    private List paramElements;
    private Parameter parent;
    private Parameter deflt;
    private Parameter next;
    private Map parameters;
    private Map isSetWhen;
    private boolean declaredSensitive;
    private boolean runtimeSensitive;
    private boolean set;
    private int instanceID;
    private boolean required;
    private boolean constant;
    private String defltValue;
    private Object[] typedValue;

    private Parameter() {
    }

    public Parameter(String string, String string2, DataType dataType) {
        Lib.CheckParam(string, "someTagName");
        Lib.CheckParam(dataType, "someType");
        this.init();
        this.tagName = string;
        this.setDelcaredSensitive();
        this.setType(dataType);
        this.add(Maps.GetConstraint(this.type));
        this.add(new SingleValueConstraint());
        this.setDefault(string2);
    }

    public Parameter(String string, Parameter parameter, boolean bl) {
        Lib.CheckParam(string, "someTagName");
        Lib.CheckParam(parameter, "defaultValue");
        this.init();
        this.tagName = string;
        this.setDelcaredSensitive();
        this.setType(parameter.getDataType());
        this.setDefault(parameter);
        this.setConstraints(bl);
    }

    private void init() {
        this.instanceID = INSTANCE_ID_NONE;
        this.set = false;
        this.next = null;
        this.displayName = null;
        this.required = false;
        this.constant = false;
        this.values = Collections.EMPTY_LIST;
        this.parameters = XDS.EMPTY_MAP;
        this.isSetWhen = XDS.EMPTY_MAP;
        this.constraints = Collections.EMPTY_LIST;
        this.constraintSet = Collections.EMPTY_SET;
        this.paramElements = Collections.EMPTY_LIST;
        this.typedValue = new Object[1];
        this._buffer = new StringBuffer();
    }

    public void addIsSetWhen(Parameter parameter) {
        if (parameter == null) {
            return;
        }
        if (this.isScalar()) {
            throw new IllegalArgumentException("Is set when parameters can only be added to structured parameters.");
        }
        if (this.parameters.get(parameter.tagName()) != parameter) {
            throw new IllegalArgumentException("Is set when parameters MUST be members of this parameter.");
        }
        if (this.isSetWhen.isEmpty()) {
            this.isSetWhen = new HashMap();
        }
        this.isSetWhen.put(parameter.tagName(), parameter);
    }

    int getNumConstraints() {
        return this.constraints.size();
    }

    boolean hasConstraint(Constraint constraint) {
        return this.constraintSet.contains(constraint);
    }

    Collection getConstraints() {
        return this.constraints;
    }

    public DataType getType() {
        return this.type;
    }

    private void setConstraints(boolean bl) {
        ListIterator listIterator = this.deflt.constraints.listIterator();
        while (listIterator.hasNext()) {
            Constraint constraint = (Constraint)listIterator.next();
            if (!constraint.isType() && !bl) continue;
            constraint = (Constraint)constraint.cloneAsNeeded(true);
            this.add(constraint);
        }
    }

    private void setDelcaredSensitive() {
        this.declaredSensitive = this.tagName.toLowerCase().indexOf("password") != -1;
    }

    public void setContentSensitive() {
        this.declaredSensitive = true;
        Iterator iterator = this.parameters.values().iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            parameter.setContentSensitive();
        }
    }

    public boolean isSet() {
        boolean bl;
        if (this.isStructured()) {
            Parameter parameter;
            Iterator iterator = this.isSetWhen.isEmpty() ? this.parameters.values().iterator() : this.isSetWhen.values().iterator();
            for (bl = false; iterator.hasNext() && !bl; bl |= parameter.isSet()) {
                parameter = (Parameter)iterator.next();
            }
        } else {
            bl = this.set && !this.values.isEmpty();
        }
        return bl;
    }

    public boolean hasContent() {
        boolean bl;
        ParamElement paramElement;
        Iterator iterator = this.paramElements().iterator();
        for (bl = false; iterator.hasNext() && !bl; bl |= paramElement.hasContent()) {
            paramElement = (ParamElement)iterator.next();
        }
        return bl;
    }

    public boolean hasValues() {
        boolean bl;
        if (this.isStructured()) {
            Parameter parameter;
            Iterator iterator = this.parameters.values().iterator();
            for (bl = false; iterator.hasNext() && !bl; bl |= parameter.hasValues()) {
                parameter = (Parameter)iterator.next();
            }
            if (!bl && this.next != null) {
                bl = this.next.hasValues();
            }
        } else {
            boolean bl2 = bl = !this.values.isEmpty();
            if (!bl && this.deflt != null) {
                bl = this.deflt.hasValues();
            }
        }
        return bl;
    }

    public boolean isStructured() {
        return this.type == DataType.STRUCT;
    }

    public boolean isScalar() {
        return this.type != DataType.STRUCT;
    }

    public boolean isSingleValued() {
        return this.constraintSet.contains(SingleValueConstraint.SINGLE_VALUE);
    }

    public boolean isMultiValued() {
        return this.constraintSet.contains(MultiValueConstraint.MULTI_VALUE);
    }

    void setInstanceID(int n) {
        this.instanceID = n;
    }

    public int getInstanceID() {
        return this.instanceID;
    }

    public Parameter getParameter(String string) {
        return (Parameter)this.parameters.get(string);
    }

    public Collection getParameters() {
        return this.parameters.values();
    }

    Map getParameterMap() {
        return this.parameters;
    }

    public void add(Parameter parameter) {
        if (parameter == null) {
            return;
        }
        if (!this.isStructured()) {
            throw new IllegalArgumentException("Parameters can only be added to structured parameters.");
        }
        if (this.isDecendantOrSelf(parameter)) {
            throw new IllegalArgumentException("It's illegal to add a parameter as a componet of itself");
        }
        if (this.parameters.isEmpty()) {
            this.parameters = new HashMap();
        }
        parameter.setParent(this);
        this.parameters.put(parameter.tagName(), parameter);
    }

    boolean isDecendantOrSelf(Parameter parameter) {
        boolean bl = false;
        if (parameter == this) {
            bl = true;
        } else {
            Iterator iterator = this.parameters.values().iterator();
            while (iterator.hasNext()) {
                Parameter parameter2 = (Parameter)iterator.next();
                if (!parameter2.isDecendantOrSelf(parameter)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    void setParent(Parameter parameter) {
        this.parent = parameter;
    }

    public boolean isContentSensitive() {
        return this.declaredSensitive || this.runtimeSensitive;
    }

    boolean isTyped() {
        return this.type != DataType.ANY && this.type != DataType.STRUCT;
    }

    boolean isUntyped() {
        return this.type == DataType.ANY;
    }

    private void checkConstraint(Constraint constraint) {
        List list;
        if (this.constraintSet.contains(constraint)) {
            return;
        }
        if (this.isStructured() && !constraint.forStructured()) {
            throw new IllegalArgumentException("Constraint type '" + constraint.getClass().getName() + "' cannot be applied to structured parameters.");
        }
        if (this.isScalar() && !constraint.forScalar()) {
            throw new IllegalArgumentException("Constraint type '" + constraint.getClass().getName() + "' cannot be applied to scalar parameters.");
        }
        if (this.isTyped() && constraint.isTyped() && !this.type.isCompatibleImpl(list = constraint.getTypes())) {
            throw new IllegalArgumentException(Errors.ParamConstraintTypeMismatch(list, this));
        }
        if (constraint.getClass() == EnumConstraint.class) {
            if (!DataType.IsEnumerativeType(this.type)) {
                throw new IllegalArgumentException("Cannot apply enumerative constraint to type 'boolean'.");
            }
            this.checkEnumValuesForType((EnumConstraint)constraint);
        } else if (constraint.getClass() == SingleValueConstraint.class) {
            this.removeConstraint(MultiValueConstraint.MULTI_VALUE);
        } else if (constraint.getClass() == MultiValueConstraint.class) {
            this.removeConstraint(SingleValueConstraint.SINGLE_VALUE);
        }
    }

    private void removeConstraint(Constraint constraint) {
        if (this.constraintSet.remove(constraint)) {
            this.constraints.remove(constraint);
        }
    }

    public boolean hasValue(Object object) {
        return this.values.contains(object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkEnumValuesForType(EnumConstraint enumConstraint) {
        ListIterator<String> listIterator = enumConstraint.getLiterals().listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            if (this.type == DataType.SHORT) {
                if (!Constraints.SHORT.isValidValue(this, string, this.typedValue)) throw new IllegalArgumentException("Short parameter " + this.tagName + "cannot be constrained by an enumerations containing non-short value '" + string + "'.");
                listIterator.set(string.trim());
            } else if (this.type == DataType.INT) {
                if (!Constraints.INT.isValidValue(this, string, this.typedValue)) throw new IllegalArgumentException("Integer parameter " + this.tagName + "cannot be constrained by an enumerations containing non-integer value '" + string + "'.");
                listIterator.set(string.trim());
            } else if (this.type == DataType.LONG) {
                if (!Constraints.LONG.isValidValue(this, string, this.typedValue)) throw new IllegalArgumentException("Long parameter " + this.tagName + "cannot be constrained by an enumerations containing non-long value '" + string + "'.");
                listIterator.set(string.trim());
            }
            if (this.type == DataType.FLOAT) {
                if (!Constraints.FLOAT.isValidValue(this, string, this.typedValue)) throw new IllegalArgumentException("Integer parameter " + this.tagName + "cannot be constrained by an enumerations containing non-float value '" + string + "'.");
                listIterator.set(string.trim());
                continue;
            }
            if (this.type != DataType.DOUBLE) continue;
            if (!Constraints.DOUBLE.isValidValue(this, string, this.typedValue)) throw new IllegalArgumentException("Long parameter " + this.tagName + "cannot be constrained by an enumerations containing non-double value '" + string + "'.");
            listIterator.set(string.trim());
        }
    }

    private void checkConstant() {
        if (this.constant) {
            throw new IllegalStateException("Parameter properties cannot be altered once values are added.");
        }
    }

    public void add(Constraint constraint) {
        this.checkConstant();
        if (constraint == null || this.isUntyped() && constraint.isTyped()) {
            return;
        }
        this.checkConstraint(constraint);
        if (constraint.isRequired()) {
            this.setRequired();
        }
        constraint.setConstant();
        if (this.constraints.isEmpty()) {
            this.constraints = new LinkedList();
        }
        if (this.constraintSet.isEmpty()) {
            this.constraintSet = new HashSet();
        }
        constraint.register(this);
        this.constraints.add(constraint);
        this.constraintSet.add(constraint);
    }

    private void setRequired() {
        this.required = true;
    }

    private void setDefault(Parameter parameter) {
        if (parameter != null) {
            if (parameter.isStructured()) {
                throw new IllegalArgumentException("Default parameters cannot be structured.");
            }
            this.checkForDefaultCycle(parameter);
            this.deflt = parameter;
        }
    }

    private void checkForDefaultCycle(Parameter parameter) {
        if (parameter != null) {
            if (this == parameter) {
                throw new IllegalArgumentException("A parameter cannot be a default value of itself.  Default parameter " + parameter.getParamInfo() + " is equivalent to contains parameter " + this.getParamInfo() + " as a default.");
            }
            this.checkForDefaultCycle(parameter.getDefault());
        }
    }

    Parameter getDefault() {
        return this.deflt;
    }

    private void setValuesTo(Object object) {
        if (this.values.isEmpty()) {
            this.values = new LinkedList();
        } else {
            this.values.clear();
        }
        this.values.add(object);
        this.applyTypeConstraint();
    }

    private void setDefault(String string) {
        if (string != null) {
            if (this.isStructured()) {
                throw new IllegalStateException("Structured parameters cannot default to a scalar value.");
            }
            this.defltValue = string;
            this.setValuesTo(string);
        }
    }

    void setType(DataType dataType) {
        if (this.isStructured() && !Java.isJRE(1, 4)) {
            throw new RuntimeException("Strucutred parameters are only supported in a Java 1.4 Runtime Environemnt (JRE) or later.");
        }
        this.type = dataType;
    }

    public ParamElement paramElement() {
        return (ParamElement)Java.getFirst(this.paramElements);
    }

    public List paramElements() {
        return this.paramElements;
    }

    DataType getDataType() {
        return this.type;
    }

    public String tagName() {
        return this.tagName;
    }

    public String qualifiedTagName() {
        StringBuffer stringBuffer = this._buffer;
        Java.clear(stringBuffer);
        if (this.parent != null) {
            stringBuffer.append(this.parent.qualifiedTagName());
            stringBuffer.append(".");
            stringBuffer.append(this.tagName);
        } else {
            stringBuffer.append(this.tagName);
        }
        return stringBuffer.toString();
    }

    void setDisplayName(String string) {
        if (string != null) {
            this.displayName = string;
        }
    }

    String getDisplayName() {
        return this.displayName;
    }

    String getParamInfo() {
        String string = this.qualifiedTagName();
        StringBuffer stringBuffer = this._buffer;
        Java.clear(stringBuffer);
        stringBuffer.append("tagName='");
        stringBuffer.append(string);
        stringBuffer.append("'");
        if (this.displayName != null) {
            stringBuffer.append(", displayName='");
            stringBuffer.append(this.displayName);
            stringBuffer.append("'");
        }
        if (this.instanceID > -1) {
            stringBuffer.append(", instanceID=");
            stringBuffer.append(this.instanceID);
        }
        return stringBuffer.toString();
    }

    void setParamElement(ParamElement paramElement) {
        if (this.paramElements == Collections.EMPTY_LIST) {
            this.paramElements = new LinkedList();
        } else {
            this.paramElements.clear();
        }
        this.addParamElementImpl(paramElement);
    }

    void addParamElement(ParamElement paramElement) {
        if (this.paramElements == Collections.EMPTY_LIST) {
            this.paramElements = new ArrayList();
        }
        this.addParamElementImpl(paramElement);
    }

    void addParamElementImpl(ParamElement paramElement) {
        if (this.isScalar() && (paramElement.isContentSensitive() || paramElement.isPasswordRef())) {
            this.runtimeSensitive = true;
        }
        this.paramElements.add(paramElement);
    }

    public void overrideValue(String string) {
        this.overrideValue((Object)string);
    }

    public void overrideValue(Object object) {
        if (object == null) {
            this.set = false;
            this.values.clear();
        } else if (!this.isStructured()) {
            this.setValuesTo(object);
        }
    }

    void overrideTagName(String string) {
        if (XDSUtil.isValue(string)) {
            this.tagName = string;
        }
    }

    public void overrideDefault(Parameter parameter, boolean bl) {
        if (this.deflt == null) {
            throw new IllegalStateException("Parameters without a parameter default cannot be overridden using this method.");
        }
        if (parameter != null) {
            if (!Lib.AreEquivalent(this, parameter, bl)) {
                throw new IllegalArgumentException("Overriding default parameters must have the same data type and constraints as the default they're overriding.  Default parameter " + this.deflt.getParamInfo() + " of parameter " + this.getParamInfo() + " cannot be overridden by parameter '" + parameter.getParamInfo() + " for this reason.");
            }
            this.setDefault(parameter);
        }
    }

    void setValue(String string) {
        this.constant = true;
        if (Lib.IsParamValue(string)) {
            if (this.values == Collections.EMPTY_LIST) {
                this.values = new LinkedList();
            }
            if (!this.set) {
                this.set = true;
            }
            this.values.clear();
            this.values.add(string);
        }
    }

    void setNext(Parameter parameter) {
        if (!this.isStructured()) {
            throw new IllegalStateException("Only structured parameters can be chained.");
        }
        if (parameter == null) {
            return;
        }
        this.next = parameter;
    }

    void addValue(String string) {
        this.constant = true;
        if (Lib.IsParamValue(string)) {
            if (this.values == Collections.EMPTY_LIST) {
                this.values = new LinkedList();
            }
            if (!this.set) {
                this.values.clear();
                this.set = true;
            }
            this.values.add(string);
        }
    }

    private void applyTypeConstraint() {
        if (this.values.isEmpty()) {
            return;
        }
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext()) {
            Constraint constraint = (Constraint)listIterator.next();
            if (!constraint.isType()) continue;
            boolean bl = false;
            for (int i = 0; i < this.values.size(); ++i) {
                this.typedValue[0] = null;
                Object e = this.values.get(i);
                bl = constraint.isValidValue(this, e, this.typedValue);
                if (!bl) {
                    throw new IllegalArgumentException("Type mismatch.  Value '" + e + "' of parameter " + this.getParamInfo() + " is not " + this.type.toClause());
                }
                if (this.typedValue[0] == null) continue;
                this.values.set(i, this.typedValue[0]);
            }
        }
    }

    XDSException applyConstraints(XDSException xDSException) {
        XDSParameterException xDSParameterException;
        Constraint constraint;
        if (this.constraints.isEmpty()) {
            return xDSException;
        }
        boolean bl = false;
        if (this.isStructured() && !this.isSet()) {
            bl = true;
        }
        boolean bl2 = this.values.isEmpty();
        LinkedList linkedList = new LinkedList();
        if (bl2) {
            if (this.values == Collections.EMPTY_LIST) {
                this.values = new LinkedList();
            }
            this.values.add(null);
        }
        XDSException xDSException2 = xDSException;
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext() && xDSException == xDSException2) {
            Object e;
            int n;
            boolean bl3;
            constraint = (Constraint)listIterator.next();
            if (constraint.isDependent() || bl && !constraint.isRequired()) continue;
            linkedList.clear();
            if (constraint.getOperator() == LogicalOp.OR) {
                bl3 = false;
                for (n = 0; n < this.values.size(); ++n) {
                    this.typedValue[0] = null;
                    e = this.values.get(n);
                    if (!(bl3 |= constraint.isValidValue(this, e, this.typedValue))) {
                        linkedList.add(e);
                        continue;
                    }
                    if (!constraint.isType() || this.typedValue[0] == null) continue;
                    this.values.set(n, this.typedValue[0]);
                }
                if (bl3) continue;
                xDSParameterException = this.newIndependentParamException(constraint, linkedList);
                xDSException.setNextException(xDSParameterException);
                xDSException = xDSParameterException;
                continue;
            }
            if (constraint.getOperator() == LogicalOp.AND) {
                for (n = 0; n < this.values.size(); ++n) {
                    this.typedValue[0] = null;
                    linkedList.clear();
                    e = this.values.get(n);
                    bl3 = constraint.isValidValue(this, e, this.typedValue);
                    if (!bl3) {
                        linkedList.add(e);
                        continue;
                    }
                    if (!constraint.isType() || this.typedValue[0] == null) continue;
                    this.values.set(n, this.typedValue[0]);
                }
                if (linkedList.isEmpty()) continue;
                xDSParameterException = this.newIndependentParamException(constraint, linkedList);
                xDSException.setNextException(xDSParameterException);
                xDSException = xDSParameterException;
                continue;
            }
            throw new RuntimeException("Broken IF-ELSE statement.");
        }
        if (bl2) {
            this.values.clear();
        }
        if (this.isStructured() && this.isSet()) {
            Iterator iterator = this.getParameters().iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                xDSException = parameter.applyConstraints(xDSException);
            }
        }
        listIterator = this.constraints.listIterator();
        while (listIterator.hasNext()) {
            constraint = (Constraint)listIterator.next();
            if (constraint.isIndependent() || constraint.isSatisfied()) continue;
            xDSParameterException = this.newDependentException(constraint);
            xDSException.setNextException(xDSParameterException);
            xDSException = xDSParameterException;
        }
        return xDSException;
    }

    private XDSParameterException newDependentException(Constraint constraint) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (constraint instanceof MultiRequiredConstraint) {
            object = (MultiRequiredConstraint)constraint;
            Collection collection = ((Constraint)object).getRegisteredParams();
            if (collection.size() == 1) {
                stringBuffer.append("Parameter ");
            } else {
                stringBuffer.append("Either parameter ");
            }
            boolean bl = true;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" or ");
                }
                stringBuffer.append(parameter.getParamInfo());
            }
            stringBuffer.append(" must have a value.");
        } else if (constraint instanceof MultiUniqueConstraint) {
            object = this.getParamInfo();
            stringBuffer.append("Parameter ");
            stringBuffer.append((String)object);
            stringBuffer.append(" is not unique.");
        }
        stringBuffer.append("  Legal values are ");
        int n = 1;
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext()) {
            constraint = (Constraint)listIterator.next();
            stringBuffer.append(constraint.toString());
            if (n < this.constraints.size()) {
                stringBuffer.append(" " + OP.toString() + " ");
            }
            ++n;
        }
        stringBuffer.append(".");
        return new XDSParameterException(stringBuffer.toString(), this);
    }

    private XDSParameterException newIndependentParamException(Constraint constraint, List list) {
        boolean bl;
        Object object;
        String string = this.getParamInfo();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Parameter ");
        stringBuffer.append(string);
        if (constraint.isRequired()) {
            stringBuffer.append(" is missing a required value");
        } else if (constraint.isCardinality()) {
            stringBuffer.append(" has too many values.  It should have at most one value");
        } else if (constraint.isType()) {
            stringBuffer.append(" is not ");
            stringBuffer.append(this.type.toClause());
            stringBuffer.append("");
        } else if (constraint.isUnique()) {
            stringBuffer.append(" is not unique");
        } else {
            boolean bl2 = true;
            stringBuffer.append(" has illegal value");
            if (list.size() > 1) {
                stringBuffer.append("s");
            }
            object = list.listIterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(" ");
                if (e == null) {
                    stringBuffer.append(e);
                    continue;
                }
                stringBuffer.append("'");
                stringBuffer.append(e);
                stringBuffer.append("'");
            }
        }
        stringBuffer.append(".  Legal values are ");
        boolean bl3 = bl = this.constraints.size() > 1 || this.constraints.size() == 1 && ((Constraint)this.constraints.get(0)).isGroup();
        if (bl) {
            stringBuffer.append("[");
        }
        int n = 1;
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext()) {
            constraint = (Constraint)listIterator.next();
            object = constraint.toString();
            if (Lib.IsValue((String)object)) {
                stringBuffer.append((String)object);
                if (n < this.constraints.size()) {
                    stringBuffer.append(" " + OP.toString() + " ");
                }
            }
            ++n;
        }
        if (bl) {
            stringBuffer.append("]");
        }
        stringBuffer.append(".");
        return new XDSParameterException(stringBuffer.toString(), this);
    }

    public Character toCharacter() {
        Object object = null;
        try {
            object = this.getValue();
            Character c = (Character)object;
            if (c == null && this.deflt != null) {
                c = this.deflt.toCharacter();
            }
            return c;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Cannot convert parameter " + this.getParamInfo() + " with value '" + object + "' to type '" + DataType.CHAR.toString() + "'.");
        }
    }

    public Short toShort() {
        Object object = null;
        try {
            object = this.getValue();
            Short s = (Short)object;
            if (s == null && this.deflt != null) {
                s = this.deflt.toShort();
            }
            return s;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Cannot convert parameter " + this.getParamInfo() + " with value '" + object + "' to type '" + DataType.SHORT.toString() + "'.");
        }
    }

    public Integer toInteger() {
        Object object = null;
        try {
            object = this.getValue();
            Integer n = (Integer)object;
            if (n == null && this.deflt != null) {
                n = this.deflt.toInteger();
            }
            return n;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Cannot convert parameter " + this.getParamInfo() + " with value '" + object + "' to type '" + DataType.INT.toString() + "'.");
        }
    }

    public Long toLong() {
        Object object = null;
        try {
            object = this.getValue();
            Long l = (Long)object;
            if (l == null && this.deflt != null) {
                l = this.deflt.toLong();
            }
            return l;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Cannot convert parameter " + this.getParamInfo() + " with value '" + object + "' to type '" + DataType.LONG.toString() + "'.");
        }
    }

    public Float toFloat() {
        Object object = null;
        try {
            object = this.getValue();
            Float f = (Float)object;
            if (f == null && this.deflt != null) {
                f = this.deflt.toFloat();
            }
            return f;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Cannot convert parameter " + this.getParamInfo() + " with value '" + object + "' to type '" + DataType.FLOAT.toString() + "'.");
        }
    }

    public Double toDouble() {
        Object object = null;
        try {
            object = this.getValue();
            Double d = (Double)object;
            if (d == null && this.deflt != null) {
                d = this.deflt.toDouble();
            }
            return d;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Cannot convert parameter " + this.getParamInfo() + " with value '" + object + "' to type '" + DataType.DOUBLE.toString() + "'.");
        }
    }

    public Number toNumber() {
        Object object = null;
        try {
            object = this.getValue();
            Number number = (Number)object;
            if (number == null && this.deflt != null) {
                number = this.deflt.toNumber();
            }
            return number;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Cannot convert parameter " + this.getParamInfo() + " with value '" + object + "' to Java type '" + Number.class.getName() + "'.");
        }
    }

    public Boolean toBoolean() {
        Object object = null;
        try {
            object = this.getValue();
            Boolean bl = (Boolean)object;
            if (bl == null && this.deflt != null) {
                bl = this.deflt.toBoolean();
            }
            return bl;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Cannot convert parameter " + this.getParamInfo() + " with value '" + object + "' to type '" + DataType.BOOLEAN.toString() + "'.");
        }
    }

    Object getValue() {
        return Java.getFirst(this.values);
    }

    public String toString() {
        Object object = this.getValue();
        if (object == null && this.deflt != null) {
            object = this.deflt.toString();
        }
        return object == null ? null : object.toString();
    }

    public List toList() {
        if (this.values.isEmpty() && this.deflt != null) {
            return this.deflt.toList();
        }
        return this.values;
    }

    public Parameter getNext() {
        return this.next;
    }

    boolean isRequired() {
        return this.required;
    }

    public int compareTo(Object object) {
        Parameter parameter = (Parameter)object;
        int n = this.qualifiedTagName().compareTo(parameter.qualifiedTagName());
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }

    String matchRegEx() {
        StringBuffer stringBuffer = this._buffer;
        Java.clear(stringBuffer);
        if (this.parent != null) {
            stringBuffer.append(this.parent.matchRegEx());
        }
        stringBuffer.append(this.tagName);
        stringBuffer.append("(_\\d*)?");
        if (this.isStructured()) {
            stringBuffer.append("\\.");
        }
        return stringBuffer.toString();
    }

    String instanceRegEx() {
        StringBuffer stringBuffer = this._buffer;
        Java.clear(stringBuffer);
        if (this.parent != null) {
            stringBuffer.append(this.parent.instanceRegEx());
            if (this.parent.instanceID > -1) {
                stringBuffer.append("_");
                stringBuffer.append(this.parent.instanceID);
                stringBuffer.append("\\.");
            }
        }
        stringBuffer.append(this.tagName);
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.qualifiedTagName().hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Parameter) {
            bl = this.compareTo(object) == 0;
        }
        return bl;
    }

    public Object clone(String string) {
        Parameter parameter = (Parameter)this.cloneInstance(false);
        parameter.overrideTagName(string);
        return parameter;
    }

    public Object clone() {
        return this.cloneInstance(false);
    }

    Object cloneInstance(boolean bl) {
        Object object;
        Iterator<Object> iterator;
        Parameter parameter = new Parameter();
        parameter.tagName = this.tagName;
        parameter.displayName = this.displayName;
        parameter.type = this.type;
        parameter.typedValue = new Object[1];
        parameter.parent = this.parent;
        parameter._buffer = new StringBuffer();
        parameter.declaredSensitive = this.declaredSensitive;
        parameter.runtimeSensitive = false;
        parameter.set = false;
        parameter.required = this.required;
        parameter.constant = this.constant;
        parameter.instanceID = -1;
        parameter.paramElements = Collections.EMPTY_LIST;
        parameter.next = null;
        parameter.deflt = this.deflt;
        if (this.constraints.isEmpty()) {
            parameter.constraints = Collections.EMPTY_LIST;
            parameter.constraintSet = Collections.EMPTY_SET;
        } else {
            parameter.constraints = new ArrayList(this.constraints.size());
            parameter.constraintSet = new HashSet();
            iterator = this.constraints.listIterator();
            while (iterator.hasNext()) {
                object = (Constraint)iterator.next();
                object = (Constraint)((Constraint)object).cloneAsNeeded(bl);
                parameter.constraints.add(object);
                parameter.constraintSet.add(object);
            }
        }
        if (this.parameters.isEmpty()) {
            parameter.parameters = XDS.EMPTY_MAP;
        } else {
            parameter.parameters = new HashMap(this.parameters.size());
            iterator = this.parameters.entrySet().iterator();
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                Parameter parameter2 = (Parameter)object.getValue();
                if (parameter2 == null) continue;
                Parameter parameter3 = (Parameter)parameter2.cloneInstance(bl);
                parameter.add(parameter3);
            }
        }
        if (this.isSetWhen.isEmpty()) {
            parameter.isSetWhen = XDS.EMPTY_MAP;
        } else {
            parameter.isSetWhen = new HashMap(this.isSetWhen.size());
            iterator = this.isSetWhen.values().iterator();
            while (iterator.hasNext()) {
                object = (Parameter)iterator.next();
                parameter.isSetWhen.put(((Parameter)object).tagName(), parameter.parameters.get(((Parameter)object).tagName()));
            }
        }
        if (this.values.isEmpty()) {
            parameter.values = Collections.EMPTY_LIST;
        } else {
            parameter.values = new LinkedList();
            if (this.defltValue != null) {
                parameter.setDefault(this.defltValue);
            }
        }
        return parameter;
    }
}

