/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Comparators;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.EqualityOp;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Comparator;

public final class RangeConstraint
extends Constraint {
    public static final RangeConstraint POSITIVE;
    public static final RangeConstraint NON_NEGATIVE;
    public static final RangeConstraint NEGATIVE;
    private static final String RANGE_SYMBOL;
    private static final boolean DEFAULT_EMPTY;
    private Comparator comparator;
    private boolean same;
    private Object first;
    private Object last;
    private boolean empty;
    private EqualityOp equalityOp;
    private int hashCode;
    private boolean hashCodeSet;
    private boolean isStringComparator;

    public RangeConstraint(char c, char c2) {
        this.init();
        this.same = c == c2;
        this.equalityOp = EqualityOp.NONE;
        this.setType(DataType.CHAR);
        this.comparator = Comparators.CHAR_SENSITIVE;
        this.isStringComparator = true;
        this.first = new Character(c);
        this.last = new Character(c2);
        this.setOperator(LogicalOp.AND);
        this.addConstraint(this);
    }

    public RangeConstraint(char c) {
        this(c, c);
    }

    public RangeConstraint(long l, long l2) {
        this.init();
        this.same = l == l2;
        this.equalityOp = EqualityOp.NONE;
        this.setType(DataType.LONG);
        this.comparator = Comparators.LONG;
        this.isStringComparator = false;
        this.first = new Long(l);
        this.last = new Long(l2);
        this.setOperator(LogicalOp.AND);
        this.addConstraint(this);
    }

    public RangeConstraint(long l) {
        this(l, l);
    }

    public RangeConstraint(double d, double d2) {
        this.init();
        this.same = d == d2;
        this.equalityOp = EqualityOp.NONE;
        this.setType(DataType.DOUBLE);
        this.comparator = Comparators.DOUBLE;
        this.isStringComparator = false;
        this.first = new Double(d);
        this.last = new Double(d2);
        this.setOperator(LogicalOp.AND);
        this.addConstraint(this);
    }

    public RangeConstraint(double d) {
        this(d, d);
    }

    public RangeConstraint(long l, EqualityOp equalityOp) {
        Lib.CheckParam(equalityOp, "someOp");
        this.init();
        if (l == Long.MIN_VALUE && equalityOp == EqualityOp.LT || l == Long.MAX_VALUE && equalityOp == EqualityOp.GT) {
            this.setEmpty();
        }
        this.same = false;
        this.equalityOp = equalityOp;
        this.first = new Long(l);
        this.setType(DataType.LONG);
        this.comparator = Comparators.LONG;
        this.isStringComparator = false;
        this.last = null;
        this.setOperator(LogicalOp.AND);
    }

    public RangeConstraint(double d, EqualityOp equalityOp) {
        Lib.CheckParam(equalityOp, "someOp");
        this.init();
        if (d == Double.MIN_VALUE && equalityOp == EqualityOp.LT || d == Double.MAX_VALUE && equalityOp == EqualityOp.GT) {
            this.setEmpty();
        }
        this.same = false;
        this.equalityOp = equalityOp;
        this.first = new Double(d);
        this.setType(DataType.DOUBLE);
        this.comparator = Comparators.DOUBLE;
        this.isStringComparator = false;
        this.last = null;
        this.setOperator(LogicalOp.AND);
    }

    private void init() {
        this.empty = DEFAULT_EMPTY;
    }

    public void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    private void setEmpty() {
        this.checkConstant();
        this.empty = true;
    }

    boolean isValidValue(Parameter parameter, Object object, Object[] objectArray) {
        boolean bl = true;
        if (object != null) {
            bl = this.empty ? false : this.compare(object);
        }
        return bl;
    }

    private boolean compare(Object object) {
        boolean bl;
        int n = this.comparator.compare(object, this.first);
        if (this.equalityOp == EqualityOp.NONE) {
            bl = n != -1 && this.comparator.compare(object, this.last) != 1;
        } else {
            switch (n) {
                case -1: {
                    bl = EqualityOp.IsLessThan(this.equalityOp);
                    break;
                }
                case 1: {
                    bl = EqualityOp.IsGreaterThan(this.equalityOp);
                    break;
                }
                case 0: {
                    bl = EqualityOp.MayBeEqual(this.equalityOp);
                    break;
                }
                default: {
                    throw new RuntimeException("Broken SWITCH statement.");
                }
            }
        }
        return this.not ? !bl : bl;
    }

    String getLegalValues() {
        StringBuffer stringBuffer = new StringBuffer(32);
        if (this.empty) {
            return "";
        }
        if (this.equalityOp == EqualityOp.NONE) {
            if (this.same) {
                if (this.isStringComparator) {
                    stringBuffer.append("'");
                }
                stringBuffer.append(this.first);
                if (this.isStringComparator) {
                    stringBuffer.append("'");
                }
            } else {
                if (this.isStringComparator) {
                    stringBuffer.append("'");
                }
                stringBuffer.append(this.first);
                if (this.isStringComparator) {
                    stringBuffer.append("'");
                }
                stringBuffer.append(RANGE_SYMBOL);
                if (this.isStringComparator) {
                    stringBuffer.append("'");
                }
                stringBuffer.append(this.last);
                if (this.isStringComparator) {
                    stringBuffer.append("'");
                }
            }
        } else {
            stringBuffer.append("n ");
            stringBuffer.append(this.equalityOp);
            stringBuffer.append(" ");
            stringBuffer.append(this.first);
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        if (this.hashCodeSet) {
            return this.hashCode;
        }
        this.hashCode = this.getLegalValues().hashCode();
        this.hashCodeSet = true;
        this.setConstant();
        return this.hashCode;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RangeConstraint) {
            RangeConstraint rangeConstraint = (RangeConstraint)object;
            if (this.getLegalValues().compareTo(rangeConstraint.getLegalValues()) == 0) {
                bl = true;
            }
        } else if (object instanceof ConstraintGroup) {
            ConstraintGroup constraintGroup = (ConstraintGroup)object;
            boolean bl2 = bl = constraintGroup.constraints.size() == 1;
            if (bl) {
                bl = this.equals(constraintGroup.constraints.get(0));
            }
        }
        return bl;
    }

    Object cloneAsNeeded(boolean bl) {
        return this;
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return false;
    }

    public boolean canBeAppliedToMultipleParams() {
        return true;
    }

    boolean isStateful() {
        return false;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }

    static {
        DEFAULT_EMPTY = false;
        RANGE_SYMBOL = "...";
        RangeConstraint rangeConstraint = new RangeConstraint(0L, EqualityOp.GT);
        rangeConstraint.setConstant();
        POSITIVE = rangeConstraint;
        POSITIVE.setConstant();
        rangeConstraint = new RangeConstraint(0L, EqualityOp.LT);
        rangeConstraint.setConstant();
        NEGATIVE = rangeConstraint;
        NEGATIVE.setConstant();
        rangeConstraint = new RangeConstraint(0L, EqualityOp.GTE);
        rangeConstraint.setConstant();
        NON_NEGATIVE = rangeConstraint;
        NON_NEGATIVE.setConstant();
    }
}

