/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.regex.Pattern;

public class RegExConstraint
extends Constraint {
    private Pattern pattern;

    public RegExConstraint(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("Null is not a valid regular expression pattern.");
        }
        this.pattern = Pattern.compile(string, n);
        this.setOperator(LogicalOp.AND);
        this.addConstraint(this);
    }

    public RegExConstraint(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null is not a valid regular expression pattern.");
        }
        this.pattern = Pattern.compile(string);
        this.setOperator(LogicalOp.AND);
        this.addConstraint(this);
    }

    boolean isValidValue(Parameter parameter, Object object, Object[] objectArray) {
        return object == null ? true : this.pattern.matcher(object.toString()).matches();
    }

    String getLegalValues() {
        return this.pattern.pattern() + " (regular expression)";
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RegExConstraint) {
            RegExConstraint regExConstraint = (RegExConstraint)object;
            bl = this.pattern == regExConstraint.pattern;
        } else if (object instanceof ConstraintGroup) {
            ConstraintGroup constraintGroup = (ConstraintGroup)object;
            boolean bl2 = bl = constraintGroup.constraints.size() == 1;
            if (bl) {
                bl = this.equals(constraintGroup.constraints.get(0));
            }
        }
        return bl;
    }

    public Object cloneAsNeeded(boolean bl) {
        return this;
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return false;
    }

    public boolean canBeAppliedToMultipleParams() {
        return true;
    }

    boolean isStateful() {
        return false;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }
}

