/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

public class StatusLevel
implements Comparable {
    public static final StatusLevel FATAL = new StatusLevel("fatal", 1);
    public static final StatusLevel ERROR = new StatusLevel("error", 2);
    public static final StatusLevel RETRY = new StatusLevel("retry", 3);
    public static final StatusLevel WARNING = new StatusLevel("warning", 4);
    public static final StatusLevel SUCCESS = new StatusLevel("success", 5);
    private String level;
    private int weight;

    private StatusLevel(String string, int n) {
        this.level = string;
        this.weight = n;
    }

    public static final StatusLevel getLevel(String string) {
        if (FATAL.equals(string)) {
            return FATAL;
        }
        if (ERROR.equals(string)) {
            return ERROR;
        }
        if (WARNING.equals(string)) {
            return WARNING;
        }
        if (SUCCESS.equals(string)) {
            return SUCCESS;
        }
        if (RETRY.equals(string)) {
            return RETRY;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() == String.class) {
            return this.equals((String)object);
        }
        return false;
    }

    public boolean equals(String string) {
        if (string == null) {
            return false;
        }
        return this.level.compareTo(string) == 0;
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        StatusLevel statusLevel = (StatusLevel)object;
        int n = statusLevel.getWeight();
        if (this.weight < n) {
            return -1;
        }
        if (this.weight > n) {
            return 1;
        }
        return 0;
    }

    int getWeight() {
        return this.weight;
    }

    public String toString() {
        return this.level;
    }
}

