/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.Parameter;

final class TrimmedStringConstraint
extends Constraint {
    TrimmedStringConstraint() {
        this.setOperator(LogicalOp.AND);
    }

    boolean isValidValue(Parameter parameter, Object object, Object[] objectArray) {
        boolean bl = true;
        if (object != null) {
            if (object.getClass() == String.class) {
                objectArray[0] = ((String)object).trim();
            } else {
                String string = object.toString();
                if (string == null) {
                    bl = false;
                    objectArray[0] = null;
                } else {
                    objectArray[0] = string.trim();
                }
            }
        }
        return bl;
    }

    String getLegalValues() {
        return "string (data type)";
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.getClass() == object.getClass();
    }

    Object cloneAsNeeded(boolean bl) {
        return this;
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return true;
    }

    public boolean canBeAppliedToMultipleParams() {
        return true;
    }

    boolean isStateful() {
        return false;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }
}

