/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Comparators;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.Maps;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public final class TypedEnumConstraint
extends Constraint {
    private Set values;
    private Comparator comparator;
    private int hashCode;
    private boolean hashCodeSet;
    private boolean caseInsensitive;

    public TypedEnumConstraint(DataType dataType, Comparator comparator) {
        Lib.CheckParam(dataType, "someType");
        this.setType(dataType);
        this.setComparator(comparator);
        this.setCaseInsensitive();
        this.setValues();
        this.addConstraint(this);
    }

    protected void setType(DataType dataType) {
        if (dataType == DataType.STRUCT) {
            throw new IllegalArgumentException("Type struct is not supported.");
        }
        if (dataType == DataType.ANY) {
            throw new IllegalArgumentException("Type any is not supported.");
        }
        super.setType(dataType);
    }

    public void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    private void setValues() {
        this.values = new TreeSet(this.comparator);
    }

    void setComparator(Comparator comparator) {
        if (comparator == null) {
            comparator = Maps.GetComparator(this.getType());
        }
        if (!Comparators.TestArgs(comparator, this.getType())) {
            throw new IllegalArgumentException("Passed comparator does not accept arguments of type '" + this.getType().getJavaClass().getName() + "'.");
        }
        this.comparator = comparator;
    }

    private void setCaseInsensitive() {
        this.caseInsensitive = DataType.IsStringType(this.getType()) ? this.comparator.compare("c", "C") == 0 : true;
    }

    public void add(Object object) {
        this.checkConstant();
        if (object == null) {
            return;
        }
        DataType dataType = Maps.GetType(object.getClass());
        if (dataType == null) {
            throw new IllegalArgumentException("Values of type '" + object.getClass().getName() + "' are not supported.");
        }
        if (!this.getType().isCompatibleImpl(dataType)) {
            throw new IllegalArgumentException("Value type mismatch.  Values of type '" + dataType + "' cannot be added to constraints of type " + this.getType() + "'.");
        }
        this.values.add(object);
    }

    public void add(Collection collection) {
        this.checkConstant();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    boolean isValidValue(Parameter parameter, Object object, Object[] objectArray) {
        return object == null ? true : this.isValid(object, this.not);
    }

    private boolean isValid(Object object, boolean bl) {
        return this.values.contains(object) ? !bl : bl;
    }

    String getLegalValues() {
        StringBuffer stringBuffer = new StringBuffer(this.values.size() * 16);
        boolean bl = true;
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            if (DataType.IsStringType(this.getType())) {
                stringBuffer.append("'");
            }
            stringBuffer.append(string);
            if (!DataType.IsStringType(this.getType())) continue;
            stringBuffer.append("'");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        if (this.hashCodeSet) {
            return this.hashCode;
        }
        String string = this.getLegalValues();
        if (this.caseInsensitive) {
            string = string.toUpperCase();
        }
        this.setConstant();
        this.hashCodeSet = true;
        this.hashCode = string.hashCode();
        return this.hashCode;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof TypedEnumConstraint) {
            TypedEnumConstraint typedEnumConstraint = (TypedEnumConstraint)object;
            if (((Object)this.comparator).equals(typedEnumConstraint.comparator) && this.comparator.compare(this.getLegalValues(), typedEnumConstraint.getLegalValues()) == 0) {
                bl = true;
            }
        } else if (object instanceof ConstraintGroup) {
            ConstraintGroup constraintGroup = (ConstraintGroup)object;
            boolean bl2 = bl = constraintGroup.constraints.size() == 1;
            if (bl) {
                bl = this.equals(constraintGroup.constraints.get(0));
            }
        }
        return bl;
    }

    Object cloneAsNeeded(boolean bl) {
        return this;
    }

    public boolean forStructured() {
        return false;
    }

    public boolean forScalar() {
        return true;
    }

    boolean isType() {
        return false;
    }

    public boolean canBeAppliedToMultipleParams() {
        return true;
    }

    boolean isStateful() {
        return false;
    }

    boolean isIndependent() {
        return true;
    }

    boolean isSatisfied() {
        return true;
    }
}

