/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.PasswordElementParent;
import com.novell.nds.dirxml.driver.xds.XDS;
import com.novell.nds.dirxml.driver.xds.XDSAddAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSPasswordElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class XDSAddElement
extends ElementImpl
implements CommandElement,
AssociationElementParent,
PasswordElementParent {
    private String className;
    private XDSAssociationElement association;
    private int noOfAssociations;
    private XDSPasswordElement password;
    private int noOfPasswords;
    private List addAttrs;

    XDSAddElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    XDSAddElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "add");
    }

    private void init() {
        this.association = null;
        this.className = null;
        this.password = null;
        this.noOfPasswords = 0;
        this.noOfAssociations = 0;
        this.addAttrs = Collections.EMPTY_LIST;
    }

    protected void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.document.context == 1) {
                Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, true);
            }
            if (this.className == null) {
                this.throwMissingAttributeException("class-name");
            }
            if (this.noOfPasswords > 1) {
                throw new XDSParseException(Errors.DuplicateElement("password"));
            }
            if (this.password != null && this.document.isStrict() && this.password.position() != this.children().size()) {
                throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "password", this.children().size()));
            }
        }
    }

    private void parseAttributes() {
        this.className = this.attributeValueGet("class-name");
    }

    public String getSrcDN() {
        return Lib.CommandElement_getSrcDN(this);
    }

    public String getQualifiedSrcDN() {
        return Lib.CommandElement_getQualifiedSrcDN(this);
    }

    public String getClassName() {
        return Lib.GetValue((ElementImpl)this, this.className);
    }

    public String extractPasswordText() {
        return Lib.PasswordElementParent_passwordText(this, this.password);
    }

    public XDSPasswordElement extractPasswordElement() {
        return Lib.PasswordElementParent_passwordElement(this, this.password);
    }

    public String getDestDN() {
        return Lib.GetAttributeValue(this, "dest-dn");
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public String getSrcEntryID() {
        return Lib.CommandElement_getSrcEntryID(this);
    }

    public String getTemplateDN() {
        return Lib.GetAttributeValue(this, "template-dn");
    }

    public List extractAddAttrElements() {
        return Lib.GetElements((ElementImpl)this, this.addAttrs);
    }

    public List childElements() {
        return super.childElements();
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.TextParent_extractText(this, this.association);
    }

    private void setAssociation(XDSAssociationElement xDSAssociationElement) {
        if (this.association == null) {
            this.association = xDSAssociationElement;
        }
        ++this.noOfAssociations;
    }

    private void setPassword(XDSPasswordElement xDSPasswordElement) {
        if (this.password == null) {
            this.password = xDSPasswordElement;
        }
        ++this.noOfPasswords;
    }

    private List addAttrs(int n) {
        if (this.addAttrs == Collections.EMPTY_LIST) {
            this.addAttrs = new ArrayList(n);
        }
        return this.addAttrs;
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        ElementImpl elementImpl = null;
        if ("add-attr".compareTo(string) == 0) {
            elementImpl = new XDSAddAttrElement(element, this.document);
            this.addAttrs(n2).add(elementImpl);
        } else if (this.document.context == 0) {
            if ("password".compareTo(string) == 0) {
                elementImpl = new XDSPasswordElement(element, this.document);
                this.setPassword((XDSPasswordElement)elementImpl);
            } else if ("association".compareTo(string) == 0 && "pending".equals(element.getAttribute("state"))) {
                elementImpl = XDS.IGNORE;
            }
        } else if (this.document.context == 1) {
            if ("password".compareTo(string) == 0) {
                elementImpl = new XDSPasswordElement(element, this.document);
                this.setPassword((XDSPasswordElement)elementImpl);
            } else if ("association".compareTo(string) == 0) {
                elementImpl = new XDSAssociationElement(element, this.document);
                this.setAssociation((XDSAssociationElement)elementImpl);
            }
        } else {
            throw new RuntimeException("Broken IF-ELSE statement.");
        }
        return elementImpl;
    }

    public void setSrcDN(String string) {
        this.attributeValueSet("src-dn", string);
    }

    public void setDestDN(String string) {
        this.attributeValueSet("dest-dn", string);
    }

    public void setDestEntryID(String string) {
        this.attributeValueSet("dest-entry-id", string);
    }

    public void setClassName(String string) {
        this.attributeValueSet("class-name", string);
    }

    public void setEventID(String string) {
        Lib.CommandElement_setEventID(this, string);
    }

    public void setTemplateDN(String string) {
        this.attributeValueSet("template-dn", string);
    }

    public XDSAddAttrElement appendAddAttrElement() {
        return new XDSAddAttrElement(this.document, this.element);
    }

    public XDSPasswordElement appendPasswordElement(String string) {
        this.password = new XDSPasswordElement(this.document, this.element);
        this.password.appendText(string);
        return this.password;
    }

    public XDSAssociationElement appendAssociationElement(String string) {
        return Lib.AssociationElementParent_appendAssociationElement(this, string);
    }
}

