/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSAllowAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class XDSAllowClassElement
extends ElementImpl {
    private String className;
    private List allowAttrs;

    XDSAllowClassElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    XDSAllowClassElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "allow-class");
    }

    private void init() {
        this.className = null;
        this.allowAttrs = Collections.EMPTY_LIST;
    }

    private void parseAttributes() {
        this.className = this.attributeValueGet("class-name");
    }

    private List allowAttrs(int n) {
        if (this.allowAttrs == Collections.EMPTY_LIST) {
            this.allowAttrs = new ArrayList(n);
        }
        return this.allowAttrs;
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        XDSAllowAttrElement xDSAllowAttrElement = null;
        if ("allow-attr".compareTo(string) == 0) {
            xDSAllowAttrElement = new XDSAllowAttrElement(element, this.document);
            this.allowAttrs(n2).add(xDSAllowAttrElement);
        }
        return xDSAllowAttrElement;
    }

    protected void validate() throws XDSParseException {
        if (this.document.validate && this.className == null) {
            this.throwMissingAttributeException("class-name");
        }
    }

    public String getClassName() {
        return Lib.GetValue((ElementImpl)this, this.className);
    }

    public List extractAllowAttrElements() {
        return Lib.GetElements((ElementImpl)this, this.allowAttrs);
    }

    public List childElements() {
        return super.childElements();
    }
}

