/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.TextParent;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import org.w3c.dom.Element;

public class XDSAssociationElement
extends ElementImpl
implements TextParent {
    private String text;

    XDSAssociationElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    XDSAssociationElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "association");
    }

    private void init() {
        this.text = "";
    }

    protected void passText(String string) throws XDSParseException {
        this.text = this.text + string;
    }

    private void validate() throws XDSParseException {
        if (this.document.validate && this.text == "") {
            throw new XDSParseException(Errors.NoText("association"));
        }
    }

    public String extractText() {
        return Lib.TextParent_text(this, this.text);
    }

    public void appendText(String string) {
        Lib.TextParent_appendText(this, string);
    }
}

