/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.PasswordElementParent;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSPasswordElement;
import java.util.List;
import org.w3c.dom.Element;

public class XDSCheckObjectPasswordElement
extends ElementImpl
implements CommandElement,
AssociationElementParent,
PasswordElementParent {
    private XDSAssociationElement association;
    private int noOfAssociations;
    private XDSPasswordElement password;
    private int noOfPasswords;

    XDSCheckObjectPasswordElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    XDSCheckObjectPasswordElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "check-object-password");
    }

    private void init() {
        this.association = null;
        this.password = null;
        this.noOfPasswords = 0;
        this.noOfAssociations = 0;
    }

    protected void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.document.context == 1) {
                Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, true);
            }
            if (this.noOfPasswords > 1) {
                throw new XDSParseException(Errors.DuplicateElement("password"));
            }
            if (this.password != null && this.document.isStrict() && this.password.position() != this.children().size()) {
                throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "password", this.children().size()));
            }
        }
    }

    public String getSrcDN() {
        return null;
    }

    public String getSrcEntryID() {
        return null;
    }

    public String getDestDN() {
        return Lib.GetAttributeValue(this, "dest-dn");
    }

    public String extractPasswordText() {
        return Lib.PasswordElementParent_passwordText(this, this.password);
    }

    public XDSPasswordElement extractPasswordElement() {
        return Lib.PasswordElementParent_passwordElement(this, this.password);
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public String getQualifiedSrcDN() {
        return Lib.CommandElement_getQualifiedSrcDN(this);
    }

    public String getClassName() {
        return null;
    }

    public List childElements() {
        return super.childElements();
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.TextParent_extractText(this, this.association);
    }

    private void setAssociation(XDSAssociationElement xDSAssociationElement) {
        if (this.association == null) {
            this.association = xDSAssociationElement;
        }
        ++this.noOfAssociations;
    }

    private void setPassword(XDSPasswordElement xDSPasswordElement) {
        if (this.password == null) {
            this.password = xDSPasswordElement;
        }
        ++this.noOfPasswords;
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        ElementImpl elementImpl = null;
        if ("password".compareTo(string) == 0) {
            elementImpl = new XDSPasswordElement(element, this.document);
            this.setPassword((XDSPasswordElement)elementImpl);
        } else if ("association".compareTo(string) == 0) {
            elementImpl = new XDSAssociationElement(element, this.document);
            this.setAssociation((XDSAssociationElement)elementImpl);
        }
        return elementImpl;
    }

    public XDSPasswordElement appendPasswordElement(String string) {
        this.doNotCall(1);
        return null;
    }

    public XDSAssociationElement appendAssociationElement(String string) {
        this.doNotCall(1);
        return null;
    }

    public void setEventID(String string) {
        this.doNotCall(1);
    }
}

