/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.NDSVersion;
import com.novell.nds.dirxml.driver.xds.QueryResultDocument;
import com.novell.nds.dirxml.driver.xds.StateDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.ValidationLevel;
import com.novell.nds.dirxml.driver.xds.XDS;
import com.novell.nds.dirxml.driver.xds.XDSAddAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSInitParamsElement;
import com.novell.nds.dirxml.driver.xds.XDSInstanceElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSQueryTokenElement;
import com.novell.nds.dirxml.driver.xds.XDSRemoveAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XDSCommandResultDocument
extends DocumentImpl
implements QueryResultDocument,
StateDocument {
    private List[] instanceElements;
    private List[] statusElements;
    private Map[] statusMap;
    private XDSInitParamsElement[] initParams;
    private XDSStatusElement[] mostSevere;
    private List[] queryTokens;

    public XDSCommandResultDocument(XmlDocument xmlDocument) throws XDSParseException {
        super(xmlDocument, "output", 0, DEFAULT_READ_VALIDATION_LEVEL);
        this.readInit();
        this.parseChildNodes();
    }

    public XDSCommandResultDocument() {
        super("output", 1, NDSVersion.CURRENT, DTDVersion.CURRENT);
        this.writeInit();
    }

    public XDSCommandResultDocument(DTDVersion dTDVersion) {
        super("output", 1, NDSVersion.CURRENT, dTDVersion);
        this.writeInit();
    }

    private XDSCommandResultDocument(Document document, ValidationLevel validationLevel) throws XDSParseException {
        super(document, "output", 1, validationLevel);
        this.readInit();
        this.parseChildNodes();
    }

    private void readInit() {
        this.initParams = null;
        this.statusMap = new Map[1];
        this.statusMap[0] = XDS.EMPTY_MAP;
        this.instanceElements = new List[1];
        this.instanceElements[0] = Collections.EMPTY_LIST;
        this.statusElements = new List[1];
        this.statusElements[0] = Collections.EMPTY_LIST;
        this.mostSevere = new XDSStatusElement[1];
        this.mostSevere[0] = null;
        this.queryTokens = new List[1];
        this.queryTokens[0] = Collections.EMPTY_LIST;
    }

    private void writeInit() {
        this.statusMap = null;
        this.initParams = new XDSInitParamsElement[1];
        this.initParams[0] = null;
        this.instanceElements = null;
        this.statusElements = null;
        this.mostSevere = null;
    }

    public DTDVersion getDTDVersion() {
        return this.version;
    }

    public XDSSourceElement extractSourceElement() {
        return this.source;
    }

    public List extractStatusElements(String string) {
        return Lib.QueryResultDocument_extractStatusElements(this, this.statusMap, this.statusElements, string);
    }

    public List extractStatusElements() {
        return Lib.GetElements((DocumentImpl)this, this.statusElements);
    }

    public XDSStatusElement mostSevereStatusElement(String string) {
        return Lib.ResultDocument_mostSevereStatusElement(this, string, this.statusMap, this.statusElements, this.mostSevere);
    }

    public StatusLevel mostSevereStatusLevel(String string) {
        return Lib.ResultDocument_mostSevereStatusLevel(this, string, this.statusMap, this.statusElements, this.mostSevere);
    }

    public List extractInstanceElements() {
        return Lib.GetElements((DocumentImpl)this, this.instanceElements);
    }

    public boolean containsQueryTokenElements() {
        return Lib.QueryResultDocument_containsQueryTokenElements(this, this.queryTokens);
    }

    public boolean containsQueryToken(String string) {
        return Lib.QueryResultDocument_containsQueryToken(this, this.queryTokens, string);
    }

    public List extractQueryTokenElements() {
        return Lib.QueryResultDocument_extractQueryTokenElements(this, this.queryTokens);
    }

    public List childElements() {
        return super.childElements();
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        return Lib.QueryResultDocument_parseChildElement(this, element, string, n, n2, this.statusElements, this.instanceElements, this.mostSevere, this.queryTokens);
    }

    public XDSAddAssociationElement appendAddAssociationElement() {
        return new XDSAddAssociationElement(this, this.ioElement);
    }

    public XDSRemoveAssociationElement appendRemoveAssociationElement() {
        return new XDSRemoveAssociationElement(this, this.ioElement);
    }

    public void validate() throws XDSParseException {
        new XDSCommandResultDocument(this.document, ValidationLevel.STRICT);
    }

    public XDSInstanceElement appendInstanceElement() {
        return Lib.QueryResultDocument_appendInstanceElement(this);
    }

    public XDSQueryTokenElement appendQueryTokenElement(String string) {
        return Lib.QueryTokenParent_appendQueryTokenElement(this, this.ioElement, string);
    }

    public XDSModifyAssociationElement appendModifyAssociationElement() {
        return Lib.WriteableDocument_appendModifyAssociationElement(this);
    }

    public XDSInitParamsElement appendInitParamsElement() {
        return Lib.StateDocument_appendInitParamsElement(this, this.initParams);
    }

    public XDSSourceElement appendSourceElement() {
        this.source = Lib.WriteableDocument_appendSourceElement(this, this.source);
        return this.source;
    }

    public XDSStatusElement appendStatusElement() {
        return Lib.StatusDocument_appendStatusElement(this);
    }

    public XmlDocument toXML() {
        return Lib.WriteableDocument_toXML(this);
    }

    public void empty() {
        Lib.WriteableDocument_setEmpty(this);
    }
}

