/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.TextParent;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import org.w3c.dom.Element;

public class XDSComponentElement
extends ElementImpl
implements TextParent {
    private String name;
    private String associationRef;
    private String text;

    XDSComponentElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    XDSComponentElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "component");
    }

    private void init() {
        this.name = null;
        this.associationRef = null;
        this.text = "";
    }

    protected void passText(String string) throws XDSParseException {
        this.text = this.text + string;
    }

    private void parseAttributes() {
        this.name = this.attributeValueGet("name");
        this.associationRef = this.attributeValueGet("association-ref");
    }

    private void validate() throws XDSParseException {
        if (this.document.validate && this.name == null) {
            this.throwMissingAttributeException("name");
        }
    }

    public String getName() {
        return Lib.GetValue((ElementImpl)this, this.name);
    }

    public String getAssociationRef() {
        return Lib.GetValue((ElementImpl)this, this.associationRef);
    }

    public String extractText() {
        return Lib.TextParent_text(this, this.text);
    }

    public void setName(String string) {
        this.attributeValueSet("name", string);
    }

    public void setAssociationRef(String string) {
        this.attributeValueSet("association-ref", string);
    }

    public void appendText(String string) {
        Lib.TextParent_appendText(this, string);
    }
}

