/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDS;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSParentElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class XDSInstanceElement
extends ElementImpl
implements AssociationElementParent {
    private XDSAssociationElement association;
    private int noOfAssociations;
    private String className;
    private XDSParentElement parent;
    private int noOfParents;
    private List attrs;

    XDSInstanceElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    XDSInstanceElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "instance");
    }

    private void init() {
        this.association = null;
        this.className = null;
        this.parent = null;
        this.noOfAssociations = 0;
        this.noOfParents = 0;
        this.attrs = Collections.EMPTY_LIST;
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.className == null) {
                this.throwMissingAttributeException("class-name");
            }
            Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, this.document.context == 1);
            if (this.document.validate && this.noOfParents > 1) {
                throw new XDSParseException(Errors.DuplicateElement("parent"));
            }
            if (this.document.isStrict()) {
                int n;
                int n2 = n = this.association == null ? 1 : 2;
                if (this.parent != null && this.parent.position() > n) {
                    throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "parent", n));
                }
            }
        }
    }

    public String getClassName() {
        return Lib.GetValue((ElementImpl)this, this.className);
    }

    public String getSrcDN() {
        return Lib.GetAttributeValue(this, "src-dn");
    }

    public String getQualifiedSrcDN() {
        return Lib.GetAttributeValue(this, "qualified-src-dn");
    }

    public String getEventID() {
        return this.attributeValueGet("event-id");
    }

    public XDSParentElement extractParentElement() {
        return this.parent;
    }

    public List childElements() {
        return super.childElements();
    }

    public List extractAttrElements() {
        return Lib.GetElements((ElementImpl)this, this.attrs);
    }

    private void parseAttributes() {
        this.className = this.attributeValueGet("class-name");
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.TextParent_extractText(this, this.association);
    }

    private void setParent(XDSParentElement xDSParentElement) {
        if (this.parent == null) {
            this.parent = xDSParentElement;
        }
        ++this.noOfParents;
    }

    private void setAssociation(XDSAssociationElement xDSAssociationElement) {
        if (this.association == null) {
            this.association = xDSAssociationElement;
        }
        ++this.noOfAssociations;
    }

    private List attrs(int n) {
        if (this.attrs == Collections.EMPTY_LIST) {
            this.attrs = new ArrayList(n);
        }
        return this.attrs;
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        ElementImpl elementImpl = null;
        if ("attr".compareTo(string) == 0) {
            elementImpl = new XDSAttrElement(element, this.document);
            this.attrs(n2).add(elementImpl);
        } else if ("parent".compareTo(string) == 0) {
            elementImpl = new XDSParentElement(element, this.document);
            this.setParent((XDSParentElement)elementImpl);
        } else if ("association".compareTo(string) == 0) {
            if (this.document.context == 0) {
                if ("pending".equals(element.getAttribute("state"))) {
                    elementImpl = XDS.IGNORE;
                } else {
                    elementImpl = new XDSAssociationElement(element, this.document);
                    this.setAssociation((XDSAssociationElement)elementImpl);
                }
            } else if (this.document.context == 1) {
                elementImpl = new XDSAssociationElement(element, this.document);
                this.setAssociation((XDSAssociationElement)elementImpl);
            } else {
                throw new RuntimeException("Broken IF-ELSE statement.");
            }
        }
        return elementImpl;
    }

    public void setClassName(String string) {
        this.attributeValueSet("class-name", string);
    }

    public void setSrcDN(String string) {
        this.attributeValueSet("src-dn", string);
    }

    public void setEventID(String string) {
        this.attributeValueSet("event-id", string);
    }

    public XDSAttrElement appendAttrElement() {
        return new XDSAttrElement(this.document, this.element);
    }

    public XDSParentElement appendParentElement() {
        return new XDSParentElement(this.document, this.element);
    }

    public XDSAssociationElement appendAssociationElement(String string) {
        return Lib.AssociationElementParent_appendAssociationElement(this, string);
    }
}

