/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementsParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public class XDSModifyAssociationElement
extends ElementImpl
implements AssociationElementsParent,
CommandElement {
    private static final int NO_OF_ASSOCIATIONS = 2;
    private int noOfAssociations;
    private List associations;

    XDSModifyAssociationElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    XDSModifyAssociationElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "modify-association");
    }

    private void init() {
        this.associations = Collections.EMPTY_LIST;
        this.noOfAssociations = 0;
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.noOfAssociations < 2) {
                throw new XDSParseException(Errors.NoElement("association"));
            }
            if (this.noOfAssociations > 2) {
                throw new XDSParseException(Errors.TooManyElement(this.element.getTagName(), "association"));
            }
        }
    }

    private List associations(int n) {
        if (this.associations == Collections.EMPTY_LIST) {
            this.associations = new ArrayList(n);
        }
        return this.associations;
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        XDSAssociationElement xDSAssociationElement = null;
        if ("association".compareTo(string) == 0) {
            xDSAssociationElement = new XDSAssociationElement(element, this.document);
            this.associations(n2).add(xDSAssociationElement);
            ++this.noOfAssociations;
        }
        return xDSAssociationElement;
    }

    public List childElements() {
        return super.childElements();
    }

    public List extractAssociationElements() {
        return Lib.GetElements((ElementImpl)this, this.associations);
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public String getSrcDN() {
        return null;
    }

    public String getQualifiedSrcDN() {
        return null;
    }

    public String getSrcEntryID() {
        return null;
    }

    public String getClassName() {
        return null;
    }

    public void setEventID(String string) {
        Lib.CommandElement_setEventID(this, string);
    }

    public XDSAssociationElement appendAssociationElement(String string) {
        XDSAssociationElement xDSAssociationElement = new XDSAssociationElement(this.document, this.element);
        xDSAssociationElement.appendText(string);
        return xDSAssociationElement;
    }
}

