/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.QueryScope;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSQueryTokenElement;
import com.novell.nds.dirxml.driver.xds.XDSReadAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSReadParentElement;
import com.novell.nds.dirxml.driver.xds.XDSSearchAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSSearchClassElement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public class XDSQueryElement
extends ElementImpl
implements CommandElement,
AssociationElementParent {
    public static final Integer UNLIMITED_RESULTS = new Integer(Integer.MAX_VALUE);
    private XDSAssociationElement association;
    private QueryScope scope;
    private XDSReadParentElement readParent;
    private boolean readAttributes;
    private List searchClasses;
    private List searchAttrs;
    private List readAttrs;
    private boolean identity;
    private int noOfReadParents;
    private String scopeString;
    private int noOfAssociations;
    private boolean ambiguousReadAttr;

    XDSQueryElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    XDSQueryElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "query");
    }

    protected XDSQueryElement(DocumentImpl documentImpl, Element element, String string) {
        super(documentImpl, element, string);
    }

    private void init() {
        this.association = null;
        this.readAttributes = true;
        this.searchClasses = Collections.EMPTY_LIST;
        this.searchAttrs = Collections.EMPTY_LIST;
        this.readAttrs = Collections.EMPTY_LIST;
        this.readParent = null;
        this.noOfAssociations = 0;
        this.noOfReadParents = 0;
        this.scope = null;
        this.scopeString = null;
        this.ambiguousReadAttr = false;
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.ambiguousReadAttr) {
                throw new XDSParseException(Errors.DuplicateElement("read-attr"));
            }
            if (this.noOfReadParents > 1) {
                throw new XDSParseException(Errors.DuplicateElement("read-parent"));
            }
            Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, false);
            if (this.scope == null) {
                if (this.scopeString == null) {
                    this.throwMissingAttributeException("scope");
                } else {
                    throw new XDSParseException(Errors.BadAttributeValue("scope", this.scopeString));
                }
            }
        }
    }

    public String getSrcDN() {
        return null;
    }

    public String getQualifiedSrcDN() {
        return null;
    }

    public String getSrcEntryID() {
        return null;
    }

    public QueryScope getScope() {
        return this.scope;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public boolean hasEntryScope() {
        return this.scope == QueryScope.ENTRY;
    }

    public boolean hasSubordinatesScope() {
        return this.scope == QueryScope.SUBORDINATES;
    }

    public boolean hasSubtreeScope() {
        return this.scope == QueryScope.SUBTREE;
    }

    private void parseAttributes() throws XDSParseException {
        this.scopeString = this.attributeValueGet("scope");
        this.scope = QueryScope.Lookup(this.scopeString);
        this.identity = "query-driver-ident".equals(this.attributeValueGet("event-id"));
    }

    private List searchClasses(int n) {
        if (this.searchClasses == Collections.EMPTY_LIST) {
            this.searchClasses = new LinkedList();
        }
        return this.searchClasses;
    }

    private List searchAttrs(int n) {
        if (this.searchAttrs == Collections.EMPTY_LIST) {
            this.searchAttrs = new LinkedList();
        }
        return this.searchAttrs;
    }

    private List readAttrs(int n) {
        if (this.readAttrs == Collections.EMPTY_LIST) {
            this.readAttrs = new LinkedList();
        }
        return this.readAttrs;
    }

    private void setReadParent(XDSReadParentElement xDSReadParentElement) {
        if (this.readParent == null) {
            this.readParent = xDSReadParentElement;
        }
        ++this.noOfReadParents;
    }

    private void setAssociation(XDSAssociationElement xDSAssociationElement) {
        if (this.association == null) {
            this.association = xDSAssociationElement;
        }
        ++this.noOfAssociations;
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        ElementImpl elementImpl = null;
        if ("search-class".equals(string)) {
            elementImpl = new XDSSearchClassElement(element, this.document);
            XDSSearchClassElement xDSSearchClassElement = elementImpl;
            if ("__driver_identification_class__".equals(xDSSearchClassElement._getClassName())) {
                this.identity = true;
            }
            this.searchClasses(n2).add(xDSSearchClassElement);
        } else if ("search-attr".equals(string)) {
            elementImpl = new XDSSearchAttrElement(element, this.document);
            this.searchAttrs(n2).add(elementImpl);
        } else if ("read-attr".equals(string)) {
            elementImpl = new XDSReadAttrElement(element, this.document);
            XDSReadAttrElement xDSReadAttrElement = (XDSReadAttrElement)elementImpl;
            if (this.readAttributes) {
                if (xDSReadAttrElement._isNameless()) {
                    if (this.readAttrs == Collections.EMPTY_LIST) {
                        this.readAttributes = false;
                    } else {
                        this.ambiguousReadAttr = true;
                    }
                } else {
                    this.readAttrs(n2).add(xDSReadAttrElement);
                }
            } else {
                if (!xDSReadAttrElement._isNameless()) {
                    this.ambiguousReadAttr = true;
                }
                this.readAttrs(n2).add(xDSReadAttrElement);
            }
        } else if ("read-parent".compareTo(string) == 0) {
            elementImpl = new XDSReadParentElement(element, this.document);
            this.setReadParent((XDSReadParentElement)elementImpl);
        } else if ("association".compareTo(string) == 0) {
            elementImpl = new XDSAssociationElement(element, this.document);
            this.setAssociation((XDSAssociationElement)elementImpl);
        }
        return elementImpl;
    }

    public List childElements() {
        return super.childElements();
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.TextParent_extractText(this, this.association);
    }

    public String getClassName() {
        return Lib.GetAttributeValue(this, "class-name");
    }

    public String getDestDN() {
        return Lib.GetAttributeValue(this, "dest-dn");
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public boolean shouldSearchAllClasses() {
        return this.searchClasses == Collections.EMPTY_LIST;
    }

    public boolean shouldReadAttributes() {
        return this.readAttributes;
    }

    public boolean hasRootBaseObject() {
        return this.association == null && this.attributeValueGet("dest-dn") == null;
    }

    public boolean containsSearchAttrElements() {
        return this.searchAttrs != Collections.EMPTY_LIST;
    }

    public boolean containsReadAttrElements() {
        return this.readAttrs != Collections.EMPTY_LIST;
    }

    public boolean containsSearchClassElements() {
        return this.searchClasses != Collections.EMPTY_LIST;
    }

    public List extractSearchClassElements() {
        return Lib.GetElements((ElementImpl)this, this.searchClasses);
    }

    public List extractSearchAttrElements() {
        return Lib.GetElements((ElementImpl)this, this.searchAttrs);
    }

    public List extractReadAttrElements() {
        return Lib.GetElements((ElementImpl)this, this.readAttrs);
    }

    public boolean shouldReadParent() {
        return this.readParent != null;
    }

    public XDSReadParentElement extractReadParentElement() {
        return this.readParent;
    }

    public int getMaxResultCount() {
        return UNLIMITED_RESULTS;
    }

    public boolean containsQueryToken() {
        return false;
    }

    public XDSQueryTokenElement extractQueryToken() {
        return null;
    }

    public String extractQueryTokenText() {
        return null;
    }

    public boolean hasUnlimitedResults() {
        return true;
    }

    public boolean hasLimitedResults() {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isExtended() {
        return false;
    }

    public boolean isInitialQuery() {
        return true;
    }

    public boolean isSubsequentQuery() {
        return false;
    }

    public void setDestDN(String string) {
        this.attributeValueSet("dest-dn", string);
    }

    public void setClassName(String string) {
        this.attributeValueSet("class-name", string);
    }

    public void setEventID(String string) {
        Lib.CommandElement_setEventID(this, string);
    }

    public void setDestEntryID(String string) {
        this.attributeValueSet("dest-entry-id", string);
    }

    public void setScope(QueryScope queryScope) {
        if (queryScope != null) {
            this.element.setAttribute("scope", queryScope.toString());
        }
    }

    public XDSAssociationElement appendAssociationElement(String string) {
        return Lib.AssociationElementParent_appendAssociationElement(this, string);
    }

    public XDSSearchClassElement appendSearchClassElement() {
        return new XDSSearchClassElement(this.document, this.element);
    }

    public XDSSearchAttrElement appendSearchAttrElement() {
        return new XDSSearchAttrElement(this.document, this.element);
    }

    public XDSReadAttrElement appendReadAttrElement() {
        return new XDSReadAttrElement(this.document, this.element);
    }

    public XDSReadParentElement appendReadParentElement() {
        if (this.readParent == null) {
            this.readParent = new XDSReadParentElement(this.document, this.element);
        }
        return this.readParent;
    }
}

