/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DTD;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryTokenElement;
import com.novell.nds.dirxml.driver.xds._Boolean;
import java.util.List;
import org.w3c.dom.Element;

public class XDSQueryExElement
extends XDSQueryElement
implements CommandElement,
AssociationElementParent {
    private static final Integer ILLEGAL_RESULT_COUNT = new Integer(Integer.MAX_VALUE);
    private Integer maxResultCount;
    private String sMaxResultCount;
    private _Boolean cancel;
    private XDSQueryTokenElement queryToken;
    private int noOfTokens;

    XDSQueryExElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.noOfTokens = 0;
        this.maxResultCount = UNLIMITED_RESULTS;
        this.parseAttributes();
        this.validate();
    }

    XDSQueryExElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "query-ex");
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.noOfTokens > 1) {
                throw new XDSParseException(Errors.DuplicateElement("query-token"));
            }
            if (this.maxResultCount == ILLEGAL_RESULT_COUNT) {
                throw new XDSParseException(Errors.BadAttributeValue("max-result-count", this.sMaxResultCount));
            }
            if (this.maxResultCount < 1) {
                throw new XDSParseException(Errors.BadAttributeValue("max-result-count", this.sMaxResultCount));
            }
            if (this.cancel.equals(_Boolean.ILLEGAL)) {
                throw new XDSParseException(Errors.BadBooleanType(this.cancel.toString()));
            }
        }
    }

    public boolean isIdentity() {
        return false;
    }

    private void parseAttributes() throws XDSParseException {
        this.sMaxResultCount = this.attributeValueGet("max-result-count");
        if (this.sMaxResultCount == null) {
            this.maxResultCount = UNLIMITED_RESULTS;
        } else {
            try {
                this.maxResultCount = new Integer(this.sMaxResultCount.trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.maxResultCount = ILLEGAL_RESULT_COUNT;
            }
        }
        this.cancel = _Boolean.getBoolean(this.attributeValueGet("cancel"), _Boolean.FALSE);
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        ElementImpl elementImpl = null;
        if ("query-token".equals(string)) {
            this.setQueryToken(new XDSQueryTokenElement(element, this.document));
            elementImpl = this.queryToken;
        } else {
            elementImpl = super.parseChildElement(element, string, n, n2);
        }
        return elementImpl;
    }

    private void setQueryToken(XDSQueryTokenElement xDSQueryTokenElement) {
        if (this.queryToken == null) {
            this.queryToken = xDSQueryTokenElement;
        }
        ++this.noOfTokens;
    }

    public int getMaxResultCount() {
        return this.maxResultCount;
    }

    public boolean getCancel() {
        return this.cancel.toPrimitive();
    }

    public boolean isCancelled() {
        return this.cancel.toPrimitive();
    }

    public boolean containsQueryToken() {
        return this.queryToken != null;
    }

    public XDSQueryTokenElement extractQueryToken() {
        return this.queryToken;
    }

    public String extractQueryTokenText() {
        return Lib.TextParent_extractText(this, this.queryToken);
    }

    public boolean hasUnlimitedResults() {
        return UNLIMITED_RESULTS.equals(this.maxResultCount);
    }

    public boolean hasLimitedResults() {
        return !this.hasUnlimitedResults();
    }

    public boolean isInitialQuery() {
        return this.queryToken == null;
    }

    public boolean isSubsequentQuery() {
        return this.queryToken != null;
    }

    public boolean isExtended() {
        return !this.hasEntryScope() && !this.hasUnlimitedResults();
    }

    public List childElements() {
        return super.childElements();
    }

    public void setCancel(boolean bl) {
        this.attributeValueSet("cancel", DTD.GetStringValue(bl));
    }

    public void setMaxResultCount(int n) {
        this.attributeValueSet("max-result-count", String.valueOf(n));
    }

    public XDSQueryTokenElement appendQueryTokenElement(String string) {
        return Lib.QueryTokenParent_appendQueryTokenElement(this.document, this.element, string);
    }
}

