/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSContactElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSProductElement;
import org.w3c.dom.Element;

public class XDSSourceElement
extends ElementImpl {
    private XDSProductElement product;
    private int noOfProducts;
    private XDSContactElement contact;
    private int noOfContacts;
    private String version;

    XDSSourceElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    XDSSourceElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "source");
    }

    private void init() {
        this.product = null;
        this.noOfProducts = 0;
        this.contact = null;
        this.noOfContacts = 0;
        this.version = null;
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.noOfProducts > 1) {
                throw new XDSParseException(Errors.DuplicateElement("product"));
            }
            if (this.noOfContacts > 1) {
                throw new XDSParseException(Errors.DuplicateElement("contact"));
            }
        }
    }

    private void setProduct(XDSProductElement xDSProductElement) {
        if (this.product == null) {
            this.product = xDSProductElement;
        }
        ++this.noOfProducts;
    }

    private void setContact(XDSContactElement xDSContactElement) {
        if (this.contact == null) {
            this.contact = xDSContactElement;
        }
        ++this.noOfContacts;
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        ElementImpl elementImpl = null;
        if ("product".compareTo(string) == 0) {
            elementImpl = new XDSProductElement(element, this.document);
            this.setProduct((XDSProductElement)elementImpl);
        } else if ("contact".compareTo(string) == 0) {
            elementImpl = new XDSContactElement(element, this.document);
            this.setContact((XDSContactElement)elementImpl);
        }
        return elementImpl;
    }

    public XDSProductElement extractProductElement() {
        return this.product;
    }

    public String extractProductText() {
        return Lib.GetText(this, this.product);
    }

    public XDSContactElement extractContactElement() {
        return this.contact;
    }

    public String extractContactText() {
        return Lib.GetText(this, this.contact);
    }

    public XDSProductElement appendProductElement() {
        return new XDSProductElement(this.document, this.element);
    }

    public XDSContactElement appendContactElement(String string) {
        this.contact = new XDSContactElement(this.document, this.element);
        this.contact.appendText(string);
        return this.contact;
    }
}

