/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DescriptionElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.ExceptionElement;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.TextParent;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.xml.dom.DOMQuery;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathEvaluationException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XDSStatusElement
extends ElementImpl
implements TextParent,
Comparable {
    private static final String TAG_DOCUMENT = "document";
    private static final String COMMENT_SUPPRESSED = "content suppressed";
    private static final String[] SENSITIVE_XPATH = new String[]{"//*[@is-sensitive = 'true']", "//password", "//old-password"};
    private String level;
    private StatusLevel statusLevel;
    private StatusType statusType;
    private DescriptionElement description;
    private String text;

    XDSStatusElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    XDSStatusElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "status");
    }

    private void init() {
        this.level = null;
        this.statusLevel = null;
        this.statusType = null;
        this.description = null;
        this.text = "";
        this.anyContent = true;
    }

    protected void passText(String string) throws XDSParseException {
        this.text = this.text + string;
    }

    private void validate() throws XDSParseException {
        if (this.document.validate && this.statusLevel == null) {
            if (this.level == null) {
                this.throwMissingAttributeException("level");
            } else {
                throw new XDSParseException(Errors.BadAttributeValue("level", this.level));
            }
        }
    }

    private void parseAttributes() throws XDSParseException {
        this.level = this.attributeValueGet("level");
        this.statusLevel = StatusLevel.getLevel(this.level);
        this.statusType = StatusType.Lookup(this.attributeValueGet("type"));
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        DescriptionElement descriptionElement = null;
        if ("description".compareTo(string) == 0) {
            this.description = descriptionElement = new DescriptionElement(element, this.document);
        }
        return descriptionElement;
    }

    public String extractText() {
        return Lib.TextParent_text(this, this.text);
    }

    public StatusType getType() {
        return this.statusType;
    }

    public StatusLevel getLevel() {
        return this.statusLevel;
    }

    public String getEventID() {
        return Lib.GetAttributeValue(this, "event-id");
    }

    public DescriptionElement descriptionElementExtract() {
        return this.description;
    }

    public String descriptionTextExtract() {
        return Lib.GetText(this, this.description);
    }

    public void setLevel(StatusLevel statusLevel) {
        if (statusLevel != null) {
            this.element.setAttribute("level", statusLevel.toString());
        }
    }

    public void setType(StatusType statusType) {
        this.setAttributeValue("type", statusType, DTDVersion.V1_1);
    }

    public void setEventID(String string) {
        this.attributeValueSet("event-id", string);
    }

    public void appendText(String string) {
        Lib.TextParent_appendText(this, string);
    }

    public void parametersAppend(Map map) {
        Lib.CheckParam(map, "params");
        if (map.size() > 0) {
            Document document = this.domDocument();
            Element element = document.createElement("options");
            this.element.appendChild(element);
            this.appendParams(element, map.values());
        }
    }

    private void appendParams(Element element, Collection collection) {
        if (collection.size() > 0) {
            ArrayList arrayList = new ArrayList(collection.size());
            arrayList.addAll(collection);
            Collections.sort(arrayList);
            Document document = this.domDocument();
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                String string;
                Element element2;
                Parameter parameter = (Parameter)listIterator.next();
                if (parameter.isStructured()) {
                    while (parameter != null) {
                        if (parameter.isSet()) {
                            int n;
                            element2 = document.createElement(parameter.tagName());
                            element.appendChild(element2);
                            string = parameter.getDisplayName();
                            if (string != null) {
                                element2.setAttribute("display-name", string);
                            }
                            if ((n = parameter.getInstanceID()) > -1) {
                                element2.setAttribute("instance-id", String.valueOf(n));
                            }
                            this.appendParams(element2, parameter.getParameters());
                        }
                        parameter = parameter.getNext();
                    }
                    continue;
                }
                if (!parameter.isScalar()) continue;
                List list = parameter.toList();
                if (list.isEmpty()) {
                    element2 = document.createElement(parameter.tagName());
                    element.appendChild(element2);
                    continue;
                }
                ListIterator listIterator2 = list.listIterator();
                while (listIterator2.hasNext()) {
                    Object e = listIterator2.next();
                    element2 = document.createElement(parameter.tagName());
                    element.appendChild(element2);
                    string = parameter.getDisplayName();
                    if (string != null) {
                        element2.setAttribute("display-name", string);
                    }
                    CharacterData characterData = parameter.isContentSensitive() ? document.createComment("content suppressed!") : document.createTextNode(e.toString());
                    element2.appendChild(characterData);
                }
            }
        }
    }

    public void descriptionAppend(String string) {
        if (Lib.IsValue(string)) {
            DescriptionElement descriptionElement = new DescriptionElement(this.document, this.element);
            descriptionElement.appendText(string);
        }
    }

    public void documentAppend(XmlDocument xmlDocument) {
        if (xmlDocument == null) {
            return;
        }
        StringWriter stringWriter = new StringWriter();
        xmlDocument = XDSStatusElement.SuppressContent(xmlDocument);
        try {
            DOMUtil.printDocumentWithFormat((Writer)stringWriter, (Document)xmlDocument.getDocument());
            Element element = this.document.document.createElement(TAG_DOCUMENT);
            this.element.appendChild(element);
            element.setAttribute("xml:space", "preserve");
            element.appendChild(element.getOwnerDocument().createTextNode(stringWriter.toString()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static XmlDocument SuppressContent(XmlDocument xmlDocument) {
        Document document = xmlDocument.getDocument();
        for (int i = 0; i < SENSITIVE_XPATH.length; ++i) {
            try {
                DOMQuery dOMQuery = new DOMQuery(SENSITIVE_XPATH[i]);
                NodeSet nodeSet = dOMQuery.evaluate((Node)document.getDocumentElement());
                Node node = nodeSet.first();
                while (node != null) {
                    Node node2 = node.getParentNode();
                    if (node2 != null) {
                        Node node3 = node.cloneNode(false);
                        Comment comment = node.getOwnerDocument().createComment(COMMENT_SUPPRESSED);
                        node3.appendChild(comment);
                        node2.replaceChild(node3, node);
                    }
                    node = nodeSet.next();
                }
                continue;
            }
            catch (XPathEvaluationException xPathEvaluationException) {
                throw new RuntimeException("Broken XPATH expression.");
            }
        }
        return new XmlDocument(document);
    }

    public void exceptionAppend(Exception exception, boolean bl) {
        this.exceptionAppend((Throwable)exception, bl);
    }

    public void exceptionAppend(Throwable throwable, boolean bl) {
        if (throwable != null) {
            ExceptionElement exceptionElement = new ExceptionElement(this.document, this.element);
            exceptionElement.attributeValueSet("class-name", throwable.getClass().getName());
            exceptionElement.messageAppend(throwable);
            if (bl) {
                exceptionElement.stackTraceAppend(throwable);
            }
        }
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        if (this.statusLevel == null) {
            return 1;
        }
        return this.statusLevel.compareTo(((XDSStatusElement)object).getLevel());
    }
}

