/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.util;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DriverException
extends Exception {
    public static final int CAT_ERROR = 0;
    public static final int CAT_AUTH = 1;
    public static final int CAT_CONNECT = 2;
    public static final int CAT_RETRY = 4;
    public static final int CAT_FATAL = 8;
    private static final StatusLevel DEFAULT_LEVEL = StatusLevel.ERROR;
    private static final StatusType DEFAULT_TYPE = StatusType.DRIVER_GENERAL;
    private StatusLevel level;
    private int category;
    private StatusType type;
    private List throwables;
    private boolean printStackTrace;
    private String message;
    private XmlDocument doc;
    private String id;
    private boolean appendDocument;

    public DriverException(String string) {
        this.message = string;
        this.init();
        this.setLevel(DEFAULT_LEVEL);
    }

    private void init() {
        this.category = 0;
        this.type = DEFAULT_TYPE;
        this.throwables = Collections.EMPTY_LIST;
        this.printStackTrace = false;
        this.id = null;
        this.doc = null;
        this.appendDocument = true;
    }

    public void appendPreMessage(String string) {
        if (XDSUtil.isValue(string)) {
            if (this.message == null) {
                this.message = string;
            } else {
                StringBuffer stringBuffer = new StringBuffer(string.length() + this.message.length() + 2);
                stringBuffer.append(string);
                stringBuffer.append("  ");
                stringBuffer.append(this.message);
                this.message = stringBuffer.toString();
            }
        }
    }

    public void appendPostMessage(String string) {
        if (XDSUtil.isValue(string)) {
            if (this.message == null) {
                this.message = string;
            } else {
                StringBuffer stringBuffer = new StringBuffer(string.length() + this.message.length() + 2);
                stringBuffer.append(this.message);
                stringBuffer.append("  ");
                stringBuffer.append(string);
                this.message = stringBuffer.toString();
            }
        }
    }

    public void addThrowables(List list) {
        if (list == null) {
            return;
        }
        if (this.throwables == Collections.EMPTY_LIST) {
            this.throwables = new ArrayList(list.size());
        }
        this.throwables.addAll(list);
    }

    public void addThrowble(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (this.throwables == Collections.EMPTY_LIST) {
            this.throwables = new LinkedList();
        }
        this.throwables.add(throwable);
    }

    public void setPrintStackTrace(boolean bl) {
        this.printStackTrace = bl;
    }

    public void setAppendDocument(boolean bl) {
        this.appendDocument = bl;
    }

    public boolean getAppendDocument() {
        return this.appendDocument;
    }

    public boolean getPrintStackTrace() {
        return this.printStackTrace;
    }

    public List getThrowables() {
        return this.throwables;
    }

    public void setLevel(StatusLevel statusLevel) {
        this.level = statusLevel;
    }

    public StatusLevel getLevel() {
        return this.level;
    }

    public void setType(StatusType statusType) {
        this.type = statusType;
    }

    public StatusType getType() {
        return this.type;
    }

    public void setCategory(int n) {
        this.category = 0;
        this.category |= n;
    }

    public boolean isFatal() {
        return this.level == StatusLevel.FATAL || (this.category & 8) != 0;
    }

    public boolean isAuthenticationRelated() {
        return (this.category & 1) != 0;
    }

    public boolean isConnectivityRelated() {
        return (this.category & 2) != 0;
    }

    public boolean isSpecialCondition() {
        return this.category != 0 || this.level == StatusLevel.FATAL;
    }

    public boolean isRetry() {
        return (this.category & 4) != 0;
    }

    public String getMessage() {
        return this.message == null ? "" : this.message;
    }

    public void setDocument(XmlDocument xmlDocument) {
        this.doc = xmlDocument;
    }

    public XmlDocument getDocument() {
        return this.doc;
    }

    public void setEventID(String string) {
        this.id = string;
    }

    public String getEventID() {
        return this.id;
    }
}

