/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.util;

import com.novell.nds.dirxml.driver.Trace;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.util.Java;
import com.novell.nds.dirxml.driver.xds.util.TimeUtil;

public class DriverTrace {
    public static final int LEVEL_NONE = Integer.MAX_VALUE;
    private int implLevel;
    private Trace impl;
    private int bufferLevel;
    private StringBuffer buffer;
    private int indent;

    public DriverTrace() {
        try {
            this.setImpl(new Trace(null));
        }
        catch (Error error) {
            this.setImpl(null);
        }
        this.init();
    }

    public DriverTrace(Trace trace) {
        if (trace == null) {
            throw new IllegalArgumentException();
        }
        this.setImpl(trace);
        this.init();
    }

    private void init() {
        this.buffer = new StringBuffer(512);
        this.indent = 0;
    }

    public Trace getImpl() {
        return this.impl;
    }

    private void setImpl(Trace trace) {
        this.impl = trace;
        this.implLevel = this.impl == null ? Integer.MAX_VALUE : this.impl.getTraceLevel();
    }

    private boolean haveImpl() {
        return this.impl != null;
    }

    public void resetIndent() {
        this.indent(0);
        if (this.haveImpl()) {
            this.impl.resetIndent();
        }
    }

    public void indent(int n) {
        this.indent = n;
        if (this.haveImpl()) {
            this.impl.pushIndent(n);
        }
    }

    public void indent() {
        ++this.indent;
        if (this.haveImpl()) {
            this.impl.pushIndent(this.indent);
        }
    }

    public void outdent() {
        --this.indent;
        if (this.haveImpl()) {
            this.impl.popIndent();
        }
    }

    public boolean willTrace(int n) {
        return n <= this.implLevel;
    }

    public void trace(String string, int n) {
        if (this.willTrace(n)) {
            this.traceImpl(string, n);
        }
    }

    private void traceImpl(XmlDocument xmlDocument, int n) {
        xmlDocument.setIndent(true);
        if (this.haveImpl()) {
            this.impl.trace(xmlDocument, n);
        } else {
            this.sysOut(xmlDocument.getDocumentString());
        }
    }

    private void traceImpl(String string) {
        if (this.haveImpl()) {
            this.impl.trace(string);
        } else {
            this.sysOut(string);
        }
    }

    private void traceImpl(String string, int n) {
        if (this.haveImpl()) {
            this.impl.trace(string, n);
        } else {
            this.sysOut(string);
        }
    }

    private void sysOut(String string) {
        for (int i = 0; i < this.indent; ++i) {
            System.out.print("\t");
        }
        System.out.println(string);
    }

    public void trace(String string) {
        this.traceImpl(string, -1);
    }

    public void trace(Throwable throwable, int n) {
        if (throwable != null && this.willTrace(n)) {
            this.traceImpl(throwable.toString(), n);
            if (Java.isJRE(1, 4) && (throwable = throwable.getCause()) != null) {
                this.traceImpl(throwable.toString(), n);
            }
        }
    }

    public void trace(XmlDocument xmlDocument, int n) {
        if (this.willTrace(n)) {
            xmlDocument.setIndent(true);
            this.traceImpl(xmlDocument, n);
        }
    }

    public void sleepInterval(long l, int n) {
        if (l > 0L && this.willTrace(n)) {
            long[] lArray = new long[1];
            long l2 = TimeUtil.toDaysFromMillis(l, lArray);
            this.clear();
            this.setBufferLevel(n);
            this.buffer.append("Sleeping for ");
            if (l2 > 30L) {
                this.buffer.append("a really, really long time.");
            } else {
                long l3 = TimeUtil.toHoursFromMillis(lArray[0], lArray);
                long l4 = TimeUtil.toMinutesFromMillis(lArray[0], lArray);
                long l5 = TimeUtil.toSecondsFromMillis(lArray[0], lArray);
                long l6 = lArray[0];
                if (l2 != 0L) {
                    this.buffer.append(l2 + " day(s), ");
                }
                if (l3 != 0L) {
                    this.buffer.append(l3 + " hour(s), ");
                }
                if (l4 != 0L) {
                    this.buffer.append(l4 + " minute(s), ");
                }
                if (l5 != 0L) {
                    this.buffer.append(l5 + " second(s), ");
                }
                this.buffer.append(l6 + " millisecond(s).");
            }
            this.flush();
        }
    }

    public void setBufferLevel(int n) {
        this.bufferLevel = n;
    }

    public DriverTrace buffer(String string) {
        this.buffer.append(string);
        return this;
    }

    public DriverTrace buffer(Object object) {
        this.buffer.append(object);
        return this;
    }

    public DriverTrace buffer(double d) {
        this.buffer.append(d);
        return this;
    }

    public DriverTrace buffer(long l) {
        this.buffer.append(l);
        return this;
    }

    public DriverTrace buffer(int n) {
        this.buffer.append(n);
        return this;
    }

    public DriverTrace buffer(boolean bl) {
        this.buffer.append(bl);
        return this;
    }

    public String flush() {
        String string = this.buffer.toString();
        if (this.buffer.length() > 0) {
            this.traceImpl(string, this.bufferLevel);
        }
        this.clear();
        return string;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void clear() {
        Java.clear(this.buffer);
    }
}

